/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;

public class DataRow
extends CacheDataRowAdapter {
    protected int part;
    protected int hash;

    protected DataRow(CacheGroupContext grp, int hash, long link, int part, CacheDataRowAdapter.RowData rowData, boolean skipVer) {
        super(link);
        this.hash = hash;
        this.part = part;
        try {
            this.initFromLink(grp, rowData, skipVer);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        if (this.key != null) {
            this.key.partition(part);
        }
    }

    public DataRow(KeyCacheObject key, CacheObject val, GridCacheVersion ver, int part, long expireTime, int cacheId) {
        super(0L);
        this.hash = key.hashCode();
        this.key = key;
        this.val = val;
        this.ver = ver;
        this.part = part;
        this.expireTime = expireTime;
        this.cacheId = cacheId;
        this.verReady = true;
    }

    public DataRow() {
        super(0L);
    }

    @Override
    public void key(KeyCacheObject key) {
        super.key(key);
        this.hash = key.hashCode();
    }

    @Override
    public int partition() {
        return this.part;
    }

    public void partition(int partId) {
        this.part = partId;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    public void link(long link) {
        this.link = link;
    }

    public void cacheId(int cacheId) {
        this.cacheId = cacheId;
    }
}

