/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.binarytuple.ByteBufferAccessor;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.sql.ColumnType;

public class BinaryTupleComparatorUtils {
    static int compareFieldValue(ColumnType typeSpec, BinaryTupleReader tuple1, BinaryTupleReader tuple2, int index) {
        switch (typeSpec) {
            case INT8: 
            case BOOLEAN: {
                return Byte.compare(tuple1.byteValue(index), tuple2.byteValue(index));
            }
            case INT16: {
                return Short.compare(tuple1.shortValue(index), tuple2.shortValue(index));
            }
            case INT32: {
                return Integer.compare(tuple1.intValue(index), tuple2.intValue(index));
            }
            case INT64: {
                return Long.compare(tuple1.longValue(index), tuple2.longValue(index));
            }
            case FLOAT: {
                return Float.compare(tuple1.floatValue(index), tuple2.floatValue(index));
            }
            case DOUBLE: {
                return Double.compare(tuple1.doubleValue(index), tuple2.doubleValue(index));
            }
            case BYTE_ARRAY: {
                return BinaryTupleComparatorUtils.compareAsBytes(tuple1, tuple2, index);
            }
            case UUID: {
                return BinaryTupleComparatorUtils.compareAsUuid(tuple1, tuple2, index);
            }
            case STRING: {
                return BinaryTupleComparatorUtils.compareAsString(tuple1, tuple2, index, false);
            }
            case DECIMAL: {
                BigDecimal numeric1 = tuple1.decimalValue(index, Integer.MIN_VALUE);
                BigDecimal numeric2 = tuple2.decimalValue(index, Integer.MIN_VALUE);
                return numeric1.compareTo(numeric2);
            }
            case TIMESTAMP: {
                return BinaryTupleComparatorUtils.compareAsTimestamp(tuple1, tuple2, index);
            }
            case DATE: {
                return tuple1.dateValue(index).compareTo(tuple2.dateValue(index));
            }
            case TIME: {
                return tuple1.timeValue(index).compareTo(tuple2.timeValue(index));
            }
            case DATETIME: {
                return tuple1.dateTimeValue(index).compareTo(tuple2.dateTimeValue(index));
            }
        }
        throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Unsupported column type in binary tuple comparator. [type={}]", (Object[])new Object[]{typeSpec}));
    }

    public static boolean isFlagSet(ByteBuffer tuple, int flag) {
        return (tuple.get(0) & flag) != 0;
    }

    static int equalityFlag(ByteBuffer tuple) {
        return BinaryTupleComparatorUtils.isFlagSet(tuple, 16) ? 1 : -1;
    }

    static int compareAsTimestamp(BinaryTupleReader tuple1, BinaryTupleReader tuple2, int colIndex) {
        tuple1.seek(colIndex);
        int begin1 = tuple1.begin();
        int end1 = tuple1.end();
        tuple2.seek(colIndex);
        int begin2 = tuple2.begin();
        int end2 = tuple2.end();
        return BinaryTupleComparatorUtils.compareAsTimestamp(tuple1.accessor(), begin1, end1, tuple2.accessor(), begin2, end2);
    }

    public static int compareAsTimestamp(ByteBufferAccessor buf1, int begin1, int end1, ByteBufferAccessor buf2, int begin2, int end2) {
        int fullSize2;
        int trimmedSize2;
        int fullSize1 = end1 - begin1;
        int trimmedSize1 = Math.min(fullSize1, buf1.capacity() - begin1);
        int remaining = Math.min(trimmedSize1, trimmedSize2 = Math.min(fullSize2 = end2 - begin2, buf2.capacity() - begin2));
        if (remaining >= 8) {
            long seconds2;
            long seconds1 = buf1.getLong(begin1);
            int cmp = Long.compare(seconds1, seconds2 = buf2.getLong(begin2));
            if (cmp != 0) {
                return cmp;
            }
            if (remaining == 12) {
                int nanos1 = buf1.getInt(begin1 + 8);
                int nanos2 = buf2.getInt(begin2 + 8);
                return nanos1 - nanos2;
            }
            if (fullSize1 == 8 && fullSize2 == 12) {
                return -1;
            }
            if (fullSize1 == 12 && fullSize2 == 8) {
                return 1;
            }
        }
        return 0;
    }

    static int compareAsUuid(BinaryTupleReader tuple1, BinaryTupleReader tuple2, int colIndex) {
        tuple1.seek(colIndex);
        int begin1 = tuple1.begin();
        tuple2.seek(colIndex);
        int begin2 = tuple2.begin();
        return BinaryTupleComparatorUtils.compareAsUuid(tuple1.accessor(), begin1, tuple2.accessor(), begin2);
    }

    public static int compareAsUuid(ByteBufferAccessor buf1, int begin1, ByteBufferAccessor buf2, int begin2) {
        int trimmedSize2;
        int trimmedSize1 = Math.min(16, buf1.capacity() - begin1);
        int remaining = Math.min(trimmedSize1, trimmedSize2 = Math.min(16, buf2.capacity() - begin2));
        if (remaining >= 8) {
            long msb2;
            long msb1 = buf1.getLong(begin1);
            int cmp = Long.compare(msb1, msb2 = buf2.getLong(begin2));
            if (cmp != 0) {
                return cmp;
            }
            if (remaining == 16) {
                long lsb1 = buf1.getLong(begin1 + 8);
                long lsb2 = buf2.getLong(begin2 + 8);
                return Long.compare(lsb1, lsb2);
            }
        }
        return 0;
    }

    static int compareAsBytes(BinaryTupleReader tuple1, BinaryTupleReader tuple2, int colIndex) {
        tuple1.seek(colIndex);
        int begin1 = tuple1.begin();
        int end1 = tuple1.end();
        tuple2.seek(colIndex);
        int begin2 = tuple2.begin();
        int end2 = tuple2.end();
        return BinaryTupleComparatorUtils.compareAsBytes(tuple1.accessor(), begin1, end1, tuple2.accessor(), begin2, end2);
    }

    public static int compareAsBytes(ByteBufferAccessor buf1, int begin1, int end1, ByteBufferAccessor buf2, int begin2, int end2) {
        int i;
        if (buf1.get(begin1) == -128) {
            ++begin1;
        }
        int fullSize1 = end1 - begin1;
        int trimmedSize1 = Math.min(fullSize1, buf1.capacity() - begin1);
        if (buf2.get(begin2) == -128) {
            ++begin2;
        }
        int fullSize2 = end2 - begin2;
        int trimmedSize2 = Math.min(fullSize2, buf2.capacity() - begin2);
        int remaining = Math.min(trimmedSize1, trimmedSize2);
        int wordBytes = remaining - remaining % 8;
        for (i = 0; i < wordBytes; i += 8) {
            long w2;
            long w1 = Long.reverseBytes(buf1.getLong(begin1 + i));
            int cmp = Long.compareUnsigned(w1, w2 = Long.reverseBytes(buf2.getLong(begin2 + i)));
            if (cmp == 0) continue;
            return cmp;
        }
        for (i = wordBytes; i < remaining; ++i) {
            byte b2;
            byte b1 = buf1.get(begin1 + i);
            int cmp = Byte.compareUnsigned(b1, b2 = buf2.get(begin2 + i));
            if (cmp == 0) continue;
            return cmp;
        }
        if (fullSize1 > remaining && fullSize2 > remaining) {
            return 0;
        }
        return Integer.signum(fullSize1 - fullSize2);
    }

    static int compareAsString(BinaryTupleReader tuple1, BinaryTupleReader tuple2, int colIndex, boolean ignoreCase) {
        tuple1.seek(colIndex);
        int begin1 = tuple1.begin();
        int end1 = tuple1.end();
        tuple2.seek(colIndex);
        int begin2 = tuple2.begin();
        int end2 = tuple2.end();
        return BinaryTupleComparatorUtils.compareAsString(tuple1.accessor(), begin1, end1, tuple2.accessor(), begin2, end2, ignoreCase);
    }

    public static int compareAsString(ByteBufferAccessor buf1, int begin1, int end1, ByteBufferAccessor buf2, int begin2, int end2, boolean ignoreCase) {
        int trimmedSize2;
        int fullStrLength2;
        int asciiResult;
        if (buf1.get(begin1) == -128) {
            ++begin1;
        }
        int fullStrLength1 = end1 - begin1;
        int trimmedSize1 = Math.min(fullStrLength1, buf1.capacity() - begin1);
        if (buf2.get(begin2) == -128) {
            ++begin2;
        }
        if ((asciiResult = BinaryTupleComparatorUtils.compareAsciiSequences(buf1, begin1, fullStrLength1, trimmedSize1, buf2, begin2, fullStrLength2 = end2 - begin2, trimmedSize2 = Math.min(fullStrLength2, buf2.capacity() - begin2), ignoreCase)) != Integer.MIN_VALUE) {
            return asciiResult;
        }
        return BinaryTupleComparatorUtils.fullUnicodeCompare(buf1, begin1, fullStrLength1, trimmedSize1, buf2, begin2, fullStrLength2, trimmedSize2, ignoreCase);
    }

    public static int compareAsString(ByteBufferAccessor buf1, int begin1, int end1, ByteBufferAccessor buf2, int begin2, int end2) {
        return BinaryTupleComparatorUtils.compareAsString(buf1, begin1, end1, buf2, begin2, end2, false);
    }

    private static int getNextCodePoint(ByteBufferAccessor buf, int begin, int[] idx, int trimmedSize) {
        int remainingBytes;
        int startIdx = idx[0];
        byte b1 = buf.get(begin + startIdx);
        ++startIdx;
        if ((b1 & 0x80) == 0) {
            idx[0] = startIdx;
            return b1;
        }
        if ((b1 & 0xE0) == 192) {
            remainingBytes = 1;
        } else if ((b1 & 0xF0) == 224) {
            remainingBytes = 2;
        } else if ((b1 & 0xF8) == 240) {
            remainingBytes = 3;
        } else {
            throw new IllegalArgumentException("Invalid UTF-8");
        }
        if (startIdx + remainingBytes > trimmedSize) {
            return -1;
        }
        int codePoint = b1 & 63 >> remainingBytes;
        for (int i = 0; i < remainingBytes; ++i) {
            byte nextByte = buf.get(begin + startIdx);
            ++startIdx;
            if ((nextByte & 0xC0) != 128) {
                throw new IllegalArgumentException("Invalid UTF-8 continuation");
            }
            codePoint = codePoint << 6 | nextByte & 0x3F;
        }
        idx[0] = startIdx;
        return codePoint;
    }

    private static int fullUnicodeCompare(ByteBufferAccessor buf1, int begin1, int fullStrLength1, int trimmedSize1, ByteBufferAccessor buf2, int begin2, int fullStrLength2, int trimmedSize2, boolean ignoreCase) {
        int remaining = Math.min(trimmedSize1, trimmedSize2);
        int[] idx1 = new int[]{0};
        int[] idx2 = new int[]{0};
        while (idx1[0] < remaining) {
            int cp1 = BinaryTupleComparatorUtils.getNextCodePoint(buf1, begin1, idx1, trimmedSize1);
            int cp2 = BinaryTupleComparatorUtils.getNextCodePoint(buf2, begin2, idx2, trimmedSize2);
            if (cp1 == -1 || cp2 == -1) {
                return 0;
            }
            char v1 = (char)cp1;
            char v2 = (char)cp2;
            if (v1 == v2) continue;
            if (ignoreCase) {
                char upper2;
                char upper1 = Character.toUpperCase(v1);
                if (upper1 == (upper2 = Character.toUpperCase(v2))) continue;
                return Integer.signum(upper1 - upper2);
            }
            return Integer.signum(v1 - v2);
        }
        if (fullStrLength1 > remaining && fullStrLength2 > remaining) {
            return 0;
        }
        return fullStrLength1 == remaining && fullStrLength2 == remaining ? 0 : (fullStrLength1 == remaining ? -1 : 1);
    }

    private static int compareAsciiSequences(ByteBufferAccessor buf1, int begin1, int fullStrLength1, int trimmedSize1, ByteBufferAccessor buf2, int begin2, int fullStrLength2, int trimmedSize2, boolean ignoreCase) {
        int remaining = Math.min(trimmedSize1, trimmedSize2);
        for (int i = 0; i < remaining; ++i) {
            byte b1 = buf1.get(begin1 + i);
            byte b2 = buf2.get(begin2 + i);
            if ((b1 & 0x80) != 0 || (b2 & 0x80) != 0) {
                return Integer.MIN_VALUE;
            }
            char v1 = (char)b1;
            char v2 = (char)b2;
            if (v1 == v2) continue;
            if (ignoreCase) {
                char upper2;
                char upper1 = Character.toUpperCase(v1);
                if (upper1 == (upper2 = Character.toUpperCase(v2))) continue;
                return Integer.signum(upper1 - upper2);
            }
            return Integer.signum(v1 - v2);
        }
        if (fullStrLength1 > remaining && fullStrLength2 > remaining) {
            return 0;
        }
        return Integer.signum(fullStrLength1 - fullStrLength2);
    }
}

