/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.sql;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.QueryValue;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.sql.SqlQueryInfo;

@Controller(value="/management/v1/sql/")
@Tag(name="sql")
public interface SqlQueryApi {
    @Operation(summary="Retrieve all running sql queries.", description="Fetches all running sql queries.")
    @ApiResponse(responseCode="200", description="Successfully retrieved all running sql queries.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SqlQueryInfo.class)))})
    @Get(value="queries")
    public CompletableFuture<Collection<SqlQueryInfo>> queries();

    @Operation(summary="Retrieve sql query.", description="Fetches the current state of a specific sql query.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved the sql query.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SqlQueryInfo.class))}), @ApiResponse(responseCode="404", description="Query not found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="queries/{queryId}")
    public CompletableFuture<SqlQueryInfo> query(@Schema(name="queryId", description="The unique identifier of the sql query.", requiredMode=Schema.RequiredMode.REQUIRED) UUID var1);

    @Operation(summary="Kill sql query.", description="Kills a specific sql query identified by query id.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully killed the sql query.", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query not found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Query is in an illegal state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))})})
    @Delete(value="queries/{queryId}")
    public CompletableFuture<Void> killQuery(@Schema(name="queryId", description="The unique identifier of the sql query.", requiredMode=Schema.RequiredMode.REQUIRED) UUID var1);

    @Operation(summary="Invalidates SQL planner cache.", description="Invalidates SQL planner cache records on node that related to provided table names.")
    @ApiResponse(responseCode="200", description="Successfully cleared SQL query plan cache.")
    @Get(value="plan/clear-cache")
    public CompletableFuture<Void> clearCache(@QueryValue @Schema(description="SQL query plans, which are related to given tables, will be evicted from cache. Case-sensitive, cache will be reset if empty.") Optional<Set<String>> var1);
}

