/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.database.databricks;

import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.metadata.api.HopMetadataProperty;

@DatabaseMetaPlugin(type="DATABRICKS", typeDescription="Databricks", documentationUrl="/database/databases/databricks.html")
@GuiPlugin(id="GUI-DatabricksDatabaseMeta")
public class DatabricksDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final Class<?> PKG = DatabricksDatabaseMeta.class;
    @GuiWidgetElement(id="ucHttpPath", order="10", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.TEXT, label="httpPath")
    @HopMetadataProperty
    private String httpPath;
    @GuiWidgetElement(id="ucCatalogName", order="11", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.TEXT, label="Catalog Name")
    @HopMetadataProperty
    private String catalogName;

    public String getFieldDefinition(IValueMeta iValueMeta, String s, String s1, boolean b, boolean b1, boolean b2) {
        return "";
    }

    public int[] getAccessTypeList() {
        return new int[0];
    }

    public String getDriverClass() {
        return "com.databricks.client.jdbc.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) throws HopDatabaseException {
        String url = "jdbc:databricks://" + hostname + ":" + port + ";HttpPath=" + this.httpPath;
        if (!StringUtils.isEmpty((String)this.catalogName)) {
            url = url + ";CatalogName=" + this.catalogName;
        }
        return url;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, false, false);
    }

    public boolean isSupportsBooleanDataType() {
        return true;
    }

    public boolean isSupportsTimestampDataType() {
        return true;
    }

    public boolean isSupportsOptionsInURL() {
        return true;
    }

    public int getDefaultDatabasePort() {
        return 443;
    }

    public String[] getReservedWords() {
        return new String[]{"ANTI", "CROSS", "EXCEPT", "FULL", "INNER", "INTERSECT", "JOIN", "LATERAL", "LEFT", "MINUS", "NATURAL", "ON", "RIGHT", "SEMI", "UNION", "USING"};
    }

    @Generated
    public String getHttpPath() {
        return this.httpPath;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public void setHttpPath(String httpPath) {
        this.httpPath = httpPath;
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }
}

