/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class TeamMemberRole {
    @Nonnull
    protected final String roleId;
    @Nonnull
    protected final String name;
    @Nonnull
    protected final String description;

    public TeamMemberRole(@Nonnull String roleId, @Nonnull String name, @Nonnull String description) {
        if (roleId == null) {
            throw new IllegalArgumentException("Required value for 'roleId' is null");
        }
        if (roleId.length() > 128) {
            throw new IllegalArgumentException("String 'roleId' is longer than 128");
        }
        if (!Pattern.matches("pid_dbtmr:.*", roleId)) {
            throw new IllegalArgumentException("String 'roleId' does not match pattern");
        }
        this.roleId = roleId;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        if (name.length() > 32) {
            throw new IllegalArgumentException("String 'name' is longer than 32");
        }
        this.name = name;
        if (description == null) {
            throw new IllegalArgumentException("Required value for 'description' is null");
        }
        if (description.length() > 256) {
            throw new IllegalArgumentException("String 'description' is longer than 256");
        }
        this.description = description;
    }

    @Nonnull
    public String getRoleId() {
        return this.roleId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.roleId, this.name, this.description});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberRole other = (TeamMemberRole)obj;
            return !(this.roleId != other.roleId && !this.roleId.equals(other.roleId) || this.name != other.name && !this.name.equals(other.name) || this.description != other.description && !this.description.equals(other.description));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamMemberRole> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamMemberRole value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("role_id");
            StoneSerializers.string().serialize(value.roleId, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("description");
            StoneSerializers.string().serialize(value.description, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamMemberRole deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_description;
            String f_name;
            String f_roleId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_roleId = null;
                f_name = null;
                f_description = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("role_id".equals(field)) {
                        f_roleId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("description".equals(field)) {
                        f_description = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_roleId == null) {
                    throw new JsonParseException(p, "Required field \"role_id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_description == null) {
                    throw new JsonParseException(p, "Required field \"description\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamMemberRole value = new TeamMemberRole(f_roleId, f_name, f_description);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

