/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaninoCheckerUtil {
    List<String> matches = new ArrayList<String>();

    public JaninoCheckerUtil() {
        Object path = "";
        try {
            path = this.getJarPath() + File.separator + "codeExclusions.xml";
            Document document = XmlHandler.loadXmlFile((String)path);
            Node exclusionsNode = XmlHandler.getSubNode((Node)document, (String)"exclusions");
            List exclusionNodes = XmlHandler.getNodes((Node)exclusionsNode, (String)"exclusion");
            for (Node exclusionNode : exclusionNodes) {
                this.matches.add(exclusionNode.getTextContent());
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Unable to load exclusions from: '" + (String)path + "'", (Throwable)e);
        }
    }

    public List<String> checkCode(String code) {
        ArrayList<String> foundBlocks = new ArrayList<String>();
        for (String s : this.matches) {
            if (!code.contains(s)) continue;
            foundBlocks.add(s);
        }
        return foundBlocks;
    }

    public String getJarPath() {
        return new File(JaninoCheckerUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
    }
}

