/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ReaderInputStream
extends InputStream {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private Reader reader_;
    private ConvTable table_;
    private int ccsid_ = -1;
    private String encoding_ = null;
    private BidiConversionProperties properties_ = new BidiConversionProperties();
    private char[] cache_ = new char[1024];
    private byte[] b_cache_ = new byte[2562];
    private int nextRead_ = 0;
    private int nextWrite_ = 0;
    private int mode_ = 2;

    public ReaderInputStream(Reader reader, String encoding) throws UnsupportedEncodingException {
        if (reader == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("reader");
        }
        if (encoding == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("encoding");
        }
        this.reader_ = reader;
        this.encoding_ = encoding;
        this.initializeTable();
    }

    public ReaderInputStream(Reader reader, int ccsid) throws UnsupportedEncodingException {
        if (reader == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("reader");
        }
        if (ccsid < 0 || ccsid > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.reader_ = reader;
        this.ccsid_ = ccsid;
        this.initializeTable();
    }

    public ReaderInputStream(Reader reader, int ccsid, int bidiStringType) throws UnsupportedEncodingException {
        this(reader, ccsid, new BidiConversionProperties(bidiStringType));
    }

    public ReaderInputStream(Reader reader, int ccsid, BidiConversionProperties properties) throws UnsupportedEncodingException {
        if (reader == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("reader");
        }
        if (ccsid < 0 || ccsid > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.reader_ = reader;
        this.ccsid_ = ccsid;
        this.properties_ = properties;
        this.initializeTable();
    }

    public ReaderInputStream(Reader reader, int ccsid, int bidiStringType, int cacheSize) throws UnsupportedEncodingException {
        this(reader, ccsid, new BidiConversionProperties(bidiStringType), cacheSize);
    }

    public ReaderInputStream(Reader reader, int ccsid, BidiConversionProperties properties, int cacheSize) throws UnsupportedEncodingException {
        this(reader, ccsid, properties);
        if (cacheSize < 1) {
            Trace.log(2, "Value of parameter 'cacheSize' is not valid:", cacheSize);
            throw new ExtendedIllegalArgumentException("cacheSize", 4);
        }
        this.cache_ = new char[cacheSize];
        this.b_cache_ = new byte[(cacheSize * 5 + 3) / 2];
    }

    @Override
    public synchronized int available() throws IOException {
        return this.nextWrite_ - this.nextRead_;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.table_ == null) {
            return;
        }
        this.reader_.close();
        this.table_ = null;
    }

    private synchronized boolean fillCache() throws IOException {
        if (this.nextRead_ >= this.nextWrite_) {
            int numRead = this.reader_.read(this.cache_, 0, this.cache_.length);
            if (numRead == -1) {
                return false;
            }
            String s = new String(this.cache_, 0, numRead);
            byte[] b = this.table_.stringToByteArray(s, this.properties_);
            int firstByte = b[0] & 0xFF;
            int lastByte = b[b.length - 1] & 0xFF;
            if (this.mode_ == 2) {
                if (firstByte == 14) {
                    if (lastByte == 15) {
                        this.mode_ = 1;
                        System.arraycopy(b, 0, this.b_cache_, 0, b.length - 1);
                        this.nextRead_ = 0;
                        this.nextWrite_ = b.length - 1;
                    } else {
                        System.arraycopy(b, 0, this.b_cache_, 0, b.length);
                        this.nextRead_ = 0;
                        this.nextWrite_ = b.length;
                    }
                } else if (lastByte == 15) {
                    this.mode_ = 1;
                    System.arraycopy(b, 0, this.b_cache_, 0, b.length - 1);
                    this.nextRead_ = 0;
                    this.nextWrite_ = b.length - 1;
                } else {
                    System.arraycopy(b, 0, this.b_cache_, 0, b.length);
                    this.nextRead_ = 0;
                    this.nextWrite_ = b.length;
                }
            } else if (firstByte == 14) {
                if (lastByte == 15) {
                    System.arraycopy(b, 1, this.b_cache_, 0, b.length - 2);
                    this.nextRead_ = 0;
                    this.nextWrite_ = b.length - 2;
                } else {
                    this.mode_ = 2;
                    System.arraycopy(b, 1, this.b_cache_, 0, b.length - 1);
                    this.nextRead_ = 0;
                    this.nextWrite_ = b.length - 1;
                }
            } else if (lastByte == 15) {
                this.b_cache_[0] = 15;
                System.arraycopy(b, 0, this.b_cache_, 1, b.length - 1);
                this.nextRead_ = 0;
                this.nextWrite_ = b.length;
            } else {
                this.mode_ = 2;
                this.b_cache_[0] = 15;
                System.arraycopy(b, 0, this.b_cache_, 1, b.length);
                this.nextRead_ = 0;
                this.nextWrite_ = b.length + 1;
            }
        }
        if (this.nextRead_ >= this.nextWrite_) {
            return this.fillCache();
        }
        return true;
    }

    public int getBidiStringType() {
        return this.properties_.getBidiStringType();
    }

    public int getCacheSize() {
        return this.cache_.length;
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    public String getEncoding() {
        if (this.ccsid_ == -1 || this.encoding_ != null) {
            return this.encoding_;
        }
        return ConversionMaps.ccsidToEncoding(this.ccsid_);
    }

    private void initializeTable() throws UnsupportedEncodingException {
        String ccsidStr;
        if (this.encoding_ != null && (ccsidStr = ConversionMaps.encodingToCcsidString(this.encoding_)) != null) {
            this.ccsid_ = Integer.parseInt(ccsidStr);
        }
        this.table_ = this.ccsid_ == -1 ? ConvTable.getTable(this.encoding_) : ConvTable.getTable(this.ccsid_, null);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.fillCache()) {
            return this.b_cache_[this.nextRead_++];
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer) throws IOException {
        if (buffer == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (buffer.length == 0) {
            return 0;
        }
        if (this.fillCache()) {
            int max = buffer.length > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : buffer.length;
            System.arraycopy(this.b_cache_, this.nextRead_, buffer, 0, max);
            this.nextRead_ += max;
            return max;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        if (buffer == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (offset < 0 || offset > buffer.length) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", offset);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (length < 0 || length > buffer.length - offset) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (length == 0) {
            return 0;
        }
        if (this.fillCache()) {
            int max = length > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : length;
            System.arraycopy(this.b_cache_, this.nextRead_, buffer, offset, max);
            this.nextRead_ += max;
            return max;
        }
        return -1;
    }

    @Override
    public synchronized long skip(long length) throws IOException {
        if (length < 0L) {
            Trace.log(2, "Value of parameter 'length' is not valid: " + length);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (length == 0L) {
            return 0L;
        }
        long total = 0L;
        byte[] buf = new byte[length < (long)this.b_cache_.length ? (int)length : this.b_cache_.length];
        int r = this.read(buf);
        if (r < 0) {
            return 0L;
        }
        total += (long)r;
        while (r > 0 && total < length) {
            r = this.read(buf);
            if (r <= 0) continue;
            total += (long)r;
        }
        return total;
    }
}

