/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ISeriesNetServerShare;

public class ISeriesNetServerPrintShare
extends ISeriesNetServerShare {
    static final long serialVersionUID = 1L;
    public static final int AFP = 2;
    public static final int AUTO_DETECT = 4;
    public static final int SCS = 3;
    public static final int USER_ASCII = 1;
    String outputQueue_;
    String printDriver_;
    int spooledFileType_;
    String printerFile_;
    boolean isPublished_;
    String encryptionRequired_;
    public static final int NOT_REQUIRED = 0;
    public static final int REQUIRED = 1;
    String authorizationList_;

    ISeriesNetServerPrintShare(String shareName, int spooledFileType, String outQueue, String printDriver, String description, String printerFile, boolean isPublished, String encryptionRequired, String authorizationList) {
        this.setAttributeValues(shareName, spooledFileType, outQueue, printDriver, description, printerFile, isPublished, encryptionRequired, authorizationList);
    }

    void setAttributeValues(String shareName, int spooledFileType, String outQueue, String printDriver, String description, String printerFile, boolean isPublished, String encryptionRequired, String authorizationList) {
        super.setAttributeValues(shareName, description, false);
        this.spooledFileType_ = spooledFileType;
        this.outputQueue_ = outQueue;
        this.printDriver_ = printDriver;
        this.printerFile_ = printerFile;
        this.isPublished_ = isPublished;
        this.encryptionRequired_ = encryptionRequired;
        this.authorizationList_ = authorizationList;
    }

    public String getOutputQueueName() {
        return this.outputQueue_.substring(0, 10).trim();
    }

    public String getOutputQueueLibrary() {
        return this.outputQueue_.substring(10, 20).trim();
    }

    public void setOutputQueueName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() > 10) {
            throw new ExtendedIllegalArgumentException(name, 1);
        }
        StringBuffer buff = new StringBuffer(this.outputQueue_);
        buff.replace(0, 10, "          ");
        buff.replace(0, name.length(), name);
        this.outputQueue_ = buff.toString();
    }

    public void setOutputQueueLibrary(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() > 10) {
            throw new ExtendedIllegalArgumentException(name, 1);
        }
        StringBuffer buff = new StringBuffer(this.outputQueue_);
        buff.replace(10, 20, "          ");
        buff.replace(10, 10 + name.length(), name);
        this.outputQueue_ = buff.toString();
    }

    public String getPrintDriver() {
        return this.printDriver_;
    }

    public void setPrintDriver(String printDriver) {
        if (printDriver == null) {
            throw new NullPointerException("printDriver");
        }
        this.printDriver_ = printDriver;
    }

    public String getPrinterFileName() {
        return this.printerFile_.substring(0, 10).trim();
    }

    public String getPrinterFileLibrary() {
        return this.printerFile_.substring(10, 20).trim();
    }

    public void setPrinterFileName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() > 10) {
            throw new ExtendedIllegalArgumentException(name, 1);
        }
        StringBuffer buff = new StringBuffer(this.printerFile_);
        buff.replace(0, 10, "          ");
        buff.replace(0, name.length(), name);
        this.printerFile_ = buff.toString();
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 1);
    }

    public void setPrinterFileLibrary(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() > 10) {
            throw new ExtendedIllegalArgumentException(name, 1);
        }
        StringBuffer buff = new StringBuffer(this.printerFile_);
        buff.replace(10, 20, "          ");
        buff.replace(10, 10 + name.length(), name);
        this.printerFile_ = buff.toString();
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 1);
    }

    public boolean isPublished() {
        return this.isPublished_;
    }

    public void setPublished(boolean isPublished) {
        this.isPublished_ = isPublished;
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 2);
    }

    public int getSpooledFileType() {
        return this.spooledFileType_;
    }

    public void setSpooledFileType(int spooledFileType) {
        if (spooledFileType < 1 || spooledFileType > 4) {
            throw new ExtendedIllegalArgumentException(Integer.toString(spooledFileType), 2);
        }
        this.spooledFileType_ = spooledFileType;
    }

    public int getEncryptionRequired() {
        if (this.encryptionRequired_ == null) {
            throw new NullPointerException("Encryption required");
        }
        switch (this.encryptionRequired_.charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 0;
    }

    public void setEncryptionRequired(int required) {
        if (required < 0 || required > 1) {
            throw new ExtendedIllegalArgumentException(Integer.toString(required), 2);
        }
        char[] charArray = new char[1];
        switch (required) {
            case 0: {
                charArray[0] = 48;
                break;
            }
            case 1: {
                charArray[0] = 49;
                break;
            }
            default: {
                charArray[0] = 48;
            }
        }
        this.encryptionRequired_ = new String(charArray);
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 3);
    }

    public String getAuthorizationList() {
        if (this.authorizationList_ == null) {
            throw new NullPointerException("Authorization list");
        }
        return this.authorizationList_;
    }

    public void setAuthorizationList(String authorizationList) {
        if (authorizationList.length() != 0) {
            this.authorizationList_ = authorizationList;
        }
        if (this.authorizationList_ != null) {
            this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 4);
        }
    }
}

