/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XmlFormatter {
    private static final String TRANSFORM_PREFIX = "  ";
    private static XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private static XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(String xml) {
        XMLStreamReader rd = null;
        XMLStreamWriter wr = null;
        StringWriter result = new StringWriter();
        try {
            rd = INPUT_FACTORY.createXMLStreamReader(new StringReader(xml));
            XMLOutputFactory xMLOutputFactory = OUTPUT_FACTORY;
            synchronized (xMLOutputFactory) {
                wr = OUTPUT_FACTORY.createXMLStreamWriter(result);
            }
            StartElementBuffer startElementBuffer = null;
            StringBuilder str = new StringBuilder();
            StringBuilder prefix = new StringBuilder();
            StringBuilder cdata = new StringBuilder();
            boolean wasStart = false;
            boolean wasSomething = false;
            block24: while (rd.hasNext()) {
                int event = rd.next();
                if (event != 12 && cdata.length() > 0) {
                    wr.writeCData(cdata.toString());
                    cdata.setLength(0);
                }
                if (startElementBuffer != null) {
                    if (event == 2) {
                        startElementBuffer.writeTo(wr, true);
                        startElementBuffer = null;
                        prefix.setLength(prefix.length() - TRANSFORM_PREFIX.length());
                        wasStart = false;
                        continue;
                    }
                    startElementBuffer.writeTo(wr, false);
                    startElementBuffer = null;
                }
                switch (event) {
                    case 1: {
                        if (!XmlFormatter.whitespacesOnly(str)) {
                            wr.writeCharacters(str.toString());
                        } else if (wasSomething) {
                            wr.writeCharacters("\n" + String.valueOf(prefix));
                        }
                        str.setLength(0);
                        prefix.append(TRANSFORM_PREFIX);
                        startElementBuffer = new StartElementBuffer(rd);
                        wasStart = true;
                        wasSomething = true;
                        continue block24;
                    }
                    case 2: {
                        prefix.setLength(prefix.length() - TRANSFORM_PREFIX.length());
                        if (wasStart) {
                            wr.writeCharacters(str.toString());
                        } else if (!XmlFormatter.whitespacesOnly(str)) {
                            wr.writeCharacters(str.toString());
                        } else {
                            wr.writeCharacters("\n" + String.valueOf(prefix));
                        }
                        str.setLength(0);
                        wr.writeEndElement();
                        wasStart = false;
                        continue block24;
                    }
                    case 4: 
                    case 6: {
                        str.append(rd.getText());
                        continue block24;
                    }
                    case 12: {
                        if (!XmlFormatter.whitespacesOnly(str)) {
                            wr.writeCharacters(str.toString());
                        }
                        str.setLength(0);
                        cdata.append(rd.getText());
                        wasSomething = true;
                        continue block24;
                    }
                    case 5: {
                        if (!XmlFormatter.whitespacesOnly(str)) {
                            wr.writeCharacters(str.toString());
                        } else if (wasSomething) {
                            wr.writeCharacters("\n" + String.valueOf(prefix));
                        }
                        str.setLength(0);
                        wr.writeComment(rd.getText());
                        wasSomething = true;
                        continue block24;
                    }
                    case 8: {
                        wr.writeCharacters("\n");
                        wr.writeEndDocument();
                        continue block24;
                    }
                }
                throw new RuntimeException("Unknown XML event: " + event);
            }
            wr.flush();
            String string = result.toString();
            return string;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (wr != null) {
                    wr.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static boolean whitespacesOnly(StringBuilder str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        INPUT_FACTORY.setProperty("javax.xml.stream.isCoalescing", false);
    }

    private static class StartElementBuffer {
        String prefix;
        String namespace;
        String localName;
        List<AttrBuffer> attrBuffer = new ArrayList<AttrBuffer>();

        public StartElementBuffer(XMLStreamReader rd) {
            this.prefix = rd.getPrefix();
            this.namespace = rd.getNamespaceURI();
            this.localName = rd.getLocalName();
            for (int i = 0; i < rd.getAttributeCount(); ++i) {
                this.attrBuffer.add(new AttrBuffer(rd, i));
            }
        }

        public void writeTo(XMLStreamWriter wr, boolean empty) throws XMLStreamException {
            if (empty) {
                if (this.namespace != null) {
                    wr.writeEmptyElement(this.prefix, this.localName, this.namespace);
                } else {
                    wr.writeEmptyElement(this.localName);
                }
            } else if (this.namespace != null) {
                wr.writeStartElement(this.prefix, this.localName, this.namespace);
            } else {
                wr.writeStartElement(this.localName);
            }
            for (AttrBuffer a : this.attrBuffer) {
                a.writeTo(wr);
            }
        }
    }

    private static class AttrBuffer {
        String prefix;
        String namespace;
        String localName;
        String value;

        public AttrBuffer(XMLStreamReader rd, int attrIndex) {
            this.prefix = rd.getAttributePrefix(attrIndex);
            this.namespace = rd.getAttributeNamespace(attrIndex);
            this.localName = rd.getAttributeLocalName(attrIndex);
            this.value = rd.getAttributeValue(attrIndex);
        }

        public void writeTo(XMLStreamWriter wr) throws XMLStreamException {
            if (this.namespace != null) {
                wr.writeAttribute(this.prefix, this.namespace, this.localName, this.value);
            } else {
                wr.writeAttribute(this.localName, this.value);
            }
        }
    }
}

