/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metrics;

import com.clickhouse.client.api.ClientMisconfigurationException;
import com.clickhouse.client.api.internal.HttpAPIClientHelper;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.clickhouse.client.internal.apache.hc.core5.pool.ConnPoolControl;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;

public class MicrometerLoader {
    public static void applyPoolingMetricsBinder(Object registry, String metricsGroupName, PoolingHttpClientConnectionManager phccm) {
        if (!(registry instanceof MeterRegistry)) {
            throw new ClientMisconfigurationException("Unsupported registry type." + registry.getClass());
        }
        Tags tags = Tags.of((String)"httpclient", (String)metricsGroupName);
        Gauge.builder((String)"httpcomponents.httpclient.pool.total.max", (Object)phccm, connPoolControl -> connPoolControl.getTotalStats().getMax()).description("The configured maximum number of allowed persistent connections for all routes.").tags((Iterable)tags).register((MeterRegistry)registry);
        Gauge.builder((String)"httpcomponents.httpclient.pool.total.connections", (Object)phccm, connPoolControl -> connPoolControl.getTotalStats().getAvailable()).description("The number of persistent and available connections for all routes.").tags((Iterable)tags).tag("state", "available").register((MeterRegistry)registry);
        Gauge.builder((String)"httpcomponents.httpclient.pool.total.connections", (Object)phccm, connPoolControl -> connPoolControl.getTotalStats().getLeased()).description("The number of persistent and leased connections for all routes.").tags((Iterable)tags).tag("state", "leased").register((MeterRegistry)registry);
        Gauge.builder((String)"httpcomponents.httpclient.pool.total.pending", (Object)phccm, connPoolControl -> connPoolControl.getTotalStats().getPending()).description("The number of connection requests being blocked awaiting a free connection for all routes.").tags((Iterable)tags).register((MeterRegistry)registry);
        Gauge.builder((String)"httpcomponents.httpclient.pool.route.max.default", (Object)phccm, ConnPoolControl::getDefaultMaxPerRoute).description("The configured default maximum number of allowed persistent connections per route.").tags((Iterable)tags).register((MeterRegistry)registry);
    }

    public static void applyConnectionMetricsBinder(Object registry, String metricsGroupName, HttpAPIClientHelper.MeteredManagedHttpClientConnectionFactory factory) {
        if (!(registry instanceof MeterRegistry)) {
            throw new ClientMisconfigurationException("Unsupported registry type." + registry.getClass());
        }
        Gauge.builder((String)"httpcomponents.httpclient.connect.time", (Object)factory, HttpAPIClientHelper.MeteredManagedHttpClientConnectionFactory::getTime).description("The running average connection creation time.").tag("httpclient", metricsGroupName).register((MeterRegistry)registry);
    }
}

