/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Suppliers;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.audit.IAuditLogger;
import org.apache.cassandra.auth.AllowAllNetworkAuthorizer;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.INetworkAuthorizer;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileInputStreamPlus;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.security.ISslContextFactory;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.FutureCombiner;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBUtilities {
    private static final ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());
    private static final Logger logger;
    public static final String UNKNOWN_RELEASE_VERSION = "Unknown";
    public static final BigInteger TWO;
    private static final String DEFAULT_TRIGGER_DIR = "triggers";
    private static final String OPERATING_SYSTEM;
    public static final boolean isLinux;
    private static volatile InetAddress localInetAddress;
    private static volatile InetAddress broadcastInetAddress;
    private static volatile InetAddress broadcastNativeAddress;
    private static volatile InetAddressAndPort broadcastNativeAddressAndPort;
    private static volatile InetAddressAndPort broadcastInetAddressAndPort;
    private static volatile InetAddressAndPort localInetAddressAndPort;
    private static volatile String previousReleaseVersionString;
    private static int availableProcessors;
    public static final int MAX_UNSIGNED_SHORT = 65535;
    private static final Supplier<String> loadedVersionString;

    public static void setAvailableProcessors(int value) {
        availableProcessors = value;
    }

    public static int getAvailableProcessors() {
        if (availableProcessors > 0) {
            return availableProcessors;
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static InetAddress getJustLocalAddress() {
        if (localInetAddress == null) {
            if (DatabaseDescriptor.getListenAddress() == null) {
                try {
                    localInetAddress = InetAddress.getLocalHost();
                    logger.info("InetAddress.getLocalHost() was used to resolve listen_address to {}, double check this is correct. Please check your node's config and set the listen_address in cassandra.yaml accordingly if applicable.", (Object)localInetAddress);
                }
                catch (UnknownHostException e) {
                    logger.info("InetAddress.getLocalHost() could not resolve the address for the hostname ({}), please check your node's config and set the listen_address in cassandra.yaml. Falling back to {}", (Object)e, (Object)InetAddress.getLoopbackAddress());
                    localInetAddress = InetAddress.getLoopbackAddress();
                }
            } else {
                localInetAddress = DatabaseDescriptor.getListenAddress();
            }
        }
        return localInetAddress;
    }

    public static InetAddressAndPort getLocalAddressAndPort() {
        if (localInetAddressAndPort == null) {
            localInetAddressAndPort = DatabaseDescriptor.getRawConfig() == null ? InetAddressAndPort.getByAddress(FBUtilities.getJustLocalAddress()) : InetAddressAndPort.getByAddressOverrideDefaults(FBUtilities.getJustLocalAddress(), DatabaseDescriptor.getStoragePort());
        }
        return localInetAddressAndPort;
    }

    public static InetAddress getJustBroadcastAddress() {
        if (broadcastInetAddress == null) {
            broadcastInetAddress = DatabaseDescriptor.getBroadcastAddress() == null ? FBUtilities.getJustLocalAddress() : DatabaseDescriptor.getBroadcastAddress();
        }
        return broadcastInetAddress;
    }

    public static InetAddressAndPort getBroadcastAddressAndPort() {
        if (broadcastInetAddressAndPort == null) {
            broadcastInetAddressAndPort = DatabaseDescriptor.getRawConfig() == null ? InetAddressAndPort.getByAddress(FBUtilities.getJustBroadcastAddress()) : InetAddressAndPort.getByAddressOverrideDefaults(FBUtilities.getJustBroadcastAddress(), DatabaseDescriptor.getStoragePort());
        }
        return broadcastInetAddressAndPort;
    }

    public static void setBroadcastInetAddress(InetAddress addr) {
        broadcastInetAddress = addr;
        broadcastInetAddressAndPort = InetAddressAndPort.getByAddress(broadcastInetAddress);
    }

    public static void setBroadcastInetAddressAndPort(InetAddressAndPort addr) {
        broadcastInetAddress = addr.getAddress();
        broadcastInetAddressAndPort = addr;
    }

    public static InetAddress getJustBroadcastNativeAddress() {
        if (broadcastNativeAddress == null) {
            broadcastNativeAddress = DatabaseDescriptor.getBroadcastRpcAddress() == null ? DatabaseDescriptor.getRpcAddress() : DatabaseDescriptor.getBroadcastRpcAddress();
        }
        return broadcastNativeAddress;
    }

    public static InetAddressAndPort getBroadcastNativeAddressAndPort() {
        if (broadcastNativeAddressAndPort == null) {
            broadcastNativeAddressAndPort = DatabaseDescriptor.getRawConfig() == null ? InetAddressAndPort.getByAddress(FBUtilities.getJustBroadcastNativeAddress()) : InetAddressAndPort.getByAddressOverrideDefaults(FBUtilities.getJustBroadcastNativeAddress(), DatabaseDescriptor.getNativeTransportPort());
        }
        return broadcastNativeAddressAndPort;
    }

    public static String getNetworkInterface(InetAddress localAddress) {
        try {
            for (NetworkInterface ifc : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (!ifc.isUp()) continue;
                for (InetAddress addr : Collections.list(ifc.getInetAddresses())) {
                    if (!addr.equals(localAddress)) continue;
                    return ifc.getDisplayName();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static Pair<BigInteger, Boolean> midpoint(BigInteger left, BigInteger right, int sigbits) {
        BigInteger midpoint;
        boolean remainder;
        if (left.compareTo(right) < 0) {
            BigInteger sum = left.add(right);
            remainder = sum.testBit(0);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger max = TWO.pow(sigbits);
            BigInteger distance = max.add(right).subtract(left);
            remainder = distance.testBit(0);
            midpoint = distance.shiftRight(1).add(left).mod(max);
        }
        return Pair.create(midpoint, remainder);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2, int offset1, int offset2, int len1, int len2) {
        return FastByteOperations.compareUnsigned(bytes1, offset1, len1, bytes2, offset2, len2);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2) {
        return FBUtilities.compareUnsigned(bytes1, bytes2, 0, 0, bytes1.length, bytes2.length);
    }

    public static void sortSampledKeys(List<DecoratedKey> keys, Range<Token> range) {
        if (((Token)range.left).compareTo(range.right) >= 0) {
            final Token right = (Token)range.right;
            Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

                @Override
                public int compare(DecoratedKey o1, DecoratedKey o2) {
                    if (right.compareTo(o1.getToken()) < 0 && right.compareTo(o2.getToken()) < 0 || right.compareTo(o1.getToken()) > 0 && right.compareTo(o2.getToken()) > 0) {
                        return o1.compareTo(o2);
                    }
                    return o2.compareTo(o1);
                }
            };
            Collections.sort(keys, comparator);
        } else {
            Collections.sort(keys);
        }
    }

    public static String resourceToFile(String filename) throws ConfigurationException {
        ClassLoader loader = FBUtilities.class.getClassLoader();
        URL scpurl = loader.getResource(filename);
        if (scpurl == null) {
            throw new ConfigurationException("unable to locate " + filename);
        }
        return new File(scpurl.getFile()).absolutePath();
    }

    public static File cassandraTriggerDir() {
        File triggerDir = null;
        if (System.getProperty("cassandra.triggers_dir") != null) {
            triggerDir = new File(System.getProperty("cassandra.triggers_dir"));
        } else {
            URL confDir = FBUtilities.class.getClassLoader().getResource(DEFAULT_TRIGGER_DIR);
            if (confDir != null) {
                triggerDir = new File(confDir.getFile());
            }
        }
        if (triggerDir == null || !triggerDir.exists()) {
            logger.warn("Trigger directory doesn't exist, please create it and try again.");
            return null;
        }
        return triggerDir;
    }

    public static void setPreviousReleaseVersionString(String previousReleaseVersionString) {
        FBUtilities.previousReleaseVersionString = previousReleaseVersionString;
    }

    public static String getPreviousReleaseVersionString() {
        return previousReleaseVersionString;
    }

    public static String getReleaseVersionString() {
        String v = loadedVersionString.get();
        return v != null ? v : System.getProperty("cassandra.releaseVersion", UNKNOWN_RELEASE_VERSION);
    }

    public static String getReleaseVersionMajor() {
        String releaseVersion = FBUtilities.getReleaseVersionString();
        if (UNKNOWN_RELEASE_VERSION.equals(releaseVersion)) {
            throw new AssertionError((Object)"Release version is unknown");
        }
        return releaseVersion.substring(0, releaseVersion.indexOf(46));
    }

    public static long timestampMicros() {
        return Clock.Global.currentTimeMillis() * 1000L;
    }

    public static int nowInSeconds() {
        return (int)(Clock.Global.currentTimeMillis() / 1000L);
    }

    public static Instant now() {
        long epochMilli = Clock.Global.currentTimeMillis();
        return Instant.ofEpochMilli(epochMilli);
    }

    public static <T> List<T> waitOnFutures(Iterable<? extends java.util.concurrent.Future<? extends T>> futures) {
        return FBUtilities.waitOnFutures(futures, -1L, null);
    }

    public static <T> List<T> waitOnFutures(Iterable<? extends java.util.concurrent.Future<? extends T>> futures, long timeout, TimeUnit units) {
        long endNanos = 0L;
        if (timeout > 0L) {
            endNanos = Clock.Global.nanoTime() + units.toNanos(timeout);
        }
        ArrayList<T> results = new ArrayList<T>();
        Throwable fail = null;
        for (java.util.concurrent.Future<T> f : futures) {
            try {
                if (endNanos == 0L) {
                    results.add(f.get());
                    continue;
                }
                long waitFor = Math.max(1L, endNanos - Clock.Global.nanoTime());
                results.add(f.get(waitFor, TimeUnit.NANOSECONDS));
            }
            catch (Throwable t) {
                fail = Throwables.merge(fail, t);
            }
        }
        Throwables.maybeFail(fail);
        return results;
    }

    public static <T> T waitOnFuture(java.util.concurrent.Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException ee) {
            throw Throwables.cleaned(ee);
        }
        catch (InterruptedException ie) {
            throw new UncheckedInterruptedException(ie);
        }
    }

    public static <T, F extends java.util.concurrent.Future<? extends T>> F waitOnFirstFuture(Iterable<? extends F> futures) {
        return FBUtilities.waitOnFirstFuture(futures, 100L);
    }

    public static <T, F extends java.util.concurrent.Future<? extends T>> F waitOnFirstFuture(Iterable<? extends F> futures, long delay) {
        java.util.concurrent.Future f;
        while (true) {
            boolean isDone;
            Iterator<F> iter;
            if (!(iter = futures.iterator()).hasNext()) {
                throw new IllegalArgumentException();
            }
            while (!(isDone = (f = (java.util.concurrent.Future)iter.next()).isDone()) && iter.hasNext()) {
            }
            try {
                f.get(delay, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                if (!isDone) continue;
            }
            break;
        }
        return (F)f;
    }

    public static <T> Future<List<T>> allOf(Collection<? extends Future<? extends T>> futures) {
        return FutureCombiner.allOf(futures);
    }

    public static IPartitioner newPartitioner(Descriptor desc) throws IOException {
        EnumSet<MetadataType> types = EnumSet.of(MetadataType.VALIDATION, MetadataType.HEADER);
        Map<MetadataType, MetadataComponent> sstableMetadata = desc.getMetadataSerializer().deserialize(desc, types);
        ValidationMetadata validationMetadata = (ValidationMetadata)sstableMetadata.get((Object)MetadataType.VALIDATION);
        SerializationHeader.Component header = (SerializationHeader.Component)sstableMetadata.get((Object)MetadataType.HEADER);
        return FBUtilities.newPartitioner(validationMetadata.partitioner, Optional.of(header.getKeyType()));
    }

    public static IPartitioner newPartitioner(String partitionerClassName) throws ConfigurationException {
        return FBUtilities.newPartitioner(partitionerClassName, Optional.empty());
    }

    @VisibleForTesting
    static IPartitioner newPartitioner(String partitionerClassName, Optional<AbstractType<?>> comparator) throws ConfigurationException {
        if (!partitionerClassName.contains(".")) {
            partitionerClassName = "org.apache.cassandra.dht." + partitionerClassName;
        }
        if (partitionerClassName.equals("org.apache.cassandra.dht.LocalPartitioner")) {
            assert (comparator.isPresent()) : "Expected a comparator for local partitioner";
            return new LocalPartitioner(comparator.get());
        }
        return (IPartitioner)FBUtilities.instanceOrConstruct(partitionerClassName, "partitioner");
    }

    public static IAuthorizer newAuthorizer(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IAuthorizer)FBUtilities.construct(className, "authorizer");
    }

    public static IAuthenticator newAuthenticator(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IAuthenticator)FBUtilities.construct(className, "authenticator");
    }

    public static IRoleManager newRoleManager(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IRoleManager)FBUtilities.construct(className, "role manager");
    }

    public static INetworkAuthorizer newNetworkAuthorizer(String className) {
        if (className == null) {
            return new AllowAllNetworkAuthorizer();
        }
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (INetworkAuthorizer)FBUtilities.construct(className, "network authorizer");
    }

    public static IAuditLogger newAuditLogger(String className, Map<String, String> parameters) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.audit." + className;
        }
        try {
            Class auditLoggerClass = FBUtilities.classForName(className, "Audit logger");
            return (IAuditLogger)auditLoggerClass.getConstructor(Map.class).newInstance(parameters);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unable to create instance of IAuditLogger.", ex);
        }
    }

    public static ISslContextFactory newSslContextFactory(String className, Map<String, Object> parameters) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.security." + className;
        }
        try {
            Class<?> sslContextFactoryClass = Class.forName(className);
            return (ISslContextFactory)sslContextFactoryClass.getConstructor(Map.class).newInstance(parameters);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unable to create instance of ISslContextFactory for " + className, ex);
        }
    }

    public static <T> Class<T> classForName(String classname, String readable) throws ConfigurationException {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new ConfigurationException(String.format("Unable to find %s class '%s'", readable, classname), e);
        }
    }

    public static <T> T instanceOrConstruct(String classname, String readable) throws ConfigurationException {
        Class<T> cls = FBUtilities.classForName(classname, readable);
        try {
            Field instance = cls.getField("instance");
            return cls.cast(instance.get(null));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return FBUtilities.construct(cls, classname, readable);
        }
    }

    public static <T> T construct(String classname, String readable) throws ConfigurationException {
        Class<T> cls = FBUtilities.classForName(classname, readable);
        return FBUtilities.construct(cls, classname, readable);
    }

    private static <T> T construct(Class<T> cls, String classname, String readable) throws ConfigurationException {
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Default constructor for %s class '%s' is inaccessible.", readable, classname));
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(String.format("Cannot use abstract class '%s' as %s.", classname, readable));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw new ConfigurationException(String.format("Error instantiating %s class '%s'.", readable, classname), e);
        }
    }

    public static <T> NavigableSet<T> singleton(T column, Comparator<? super T> comparator) {
        TreeSet<T> s = new TreeSet<T>(comparator);
        s.add(column);
        return s;
    }

    public static <T> NavigableSet<T> emptySortedSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    @Nonnull
    public static String toString(@Nullable Map<?, ?> map) {
        if (map == null) {
            return "";
        }
        Joiner.MapJoiner joiner = Joiner.on((String)", ").withKeyValueSeparator(":");
        return joiner.join(map);
    }

    public static Field getProtectedField(Class klass, String fieldName) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> CloseableIterator<T> closeableIterator(Iterator<T> iterator) {
        return new WrappedCloseableIterator<T>(iterator);
    }

    public static Map<String, String> fromJsonMap(String json) {
        try {
            return (Map)jsonMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> fromJsonList(String json) {
        try {
            return (List)jsonMapper.readValue(json, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String json(Object object) {
        try {
            return jsonMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void serializeToJsonFile(Object object, File outputFile) throws IOException {
        try (FileOutputStreamPlus out = outputFile.newOutputStream(File.WriteMode.OVERWRITE);){
            jsonMapper.writeValue((OutputStream)out, object);
        }
    }

    public static <T> T deserializeFromJsonFile(Class<T> tClass, File file) throws IOException {
        try (FileInputStreamPlus in = file.newInputStream();){
            Object object = jsonMapper.readValue((InputStream)in, tClass);
            return (T)object;
        }
    }

    public static String prettyPrintMemory(long size) {
        return FBUtilities.prettyPrintMemory(size, false);
    }

    public static String prettyPrintMemory(long size, boolean includeSpace) {
        if (size >= 0x40000000L) {
            return String.format("%.3f%sGiB", (double)size / 1.073741824E9, includeSpace ? " " : "");
        }
        if (size >= 0x100000L) {
            return String.format("%.3f%sMiB", (double)size / 1048576.0, includeSpace ? " " : "");
        }
        return String.format("%.3f%sKiB", (double)size / 1024.0, includeSpace ? " " : "");
    }

    public static String prettyPrintMemoryPerSecond(long rate) {
        if (rate >= 0x40000000L) {
            return String.format("%.3fGiB/s", (double)rate / 1.073741824E9);
        }
        if (rate >= 0x100000L) {
            return String.format("%.3fMiB/s", (double)rate / 1048576.0);
        }
        return String.format("%.3fKiB/s", (double)rate / 1024.0);
    }

    public static String prettyPrintMemoryPerSecond(long bytes, long timeInNano) {
        if (timeInNano == 0L) {
            return "NaN  KiB/s";
        }
        long rate = (long)((double)bytes / (double)timeInNano * 1000.0 * 1000.0 * 1000.0);
        return FBUtilities.prettyPrintMemoryPerSecond(rate);
    }

    public static void exec(ProcessBuilder pb) throws IOException {
        Process p = pb.start();
        try {
            int errCode = p.waitFor();
            if (errCode != 0) {
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                Throwable throwable = null;
                try {
                    try {
                        BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        Throwable throwable2 = null;
                        try {
                            try {
                                String str;
                                String lineSep = CassandraRelevantProperties.LINE_SEPARATOR.getString();
                                StringBuilder sb = new StringBuilder();
                                while ((str = in.readLine()) != null) {
                                    sb.append(str).append(lineSep);
                                }
                                while ((str = err.readLine()) != null) {
                                    sb.append(str).append(lineSep);
                                }
                                throw new IOException("Exception while executing the command: " + StringUtils.join(pb.command(), (String)" ") + ", command error Code: " + errCode + ", command output: " + sb.toString());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (err != null) {
                                if (throwable2 != null) {
                                    try {
                                        err.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                } else {
                                    err.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                catch (Throwable throwable7) {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            in.close();
                        }
                    }
                    throw throwable7;
                }
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    public static void updateChecksumInt(Checksum checksum, int v) {
        checksum.update(v >>> 24 & 0xFF);
        checksum.update(v >>> 16 & 0xFF);
        checksum.update(v >>> 8 & 0xFF);
        checksum.update(v >>> 0 & 0xFF);
    }

    public static void updateChecksum(CRC32 checksum, ByteBuffer buffer, int offset, int length) {
        int position = buffer.position();
        int limit = buffer.limit();
        buffer.position(offset).limit(offset + length);
        checksum.update(buffer);
        buffer.position(position).limit(limit);
    }

    public static void updateChecksum(CRC32 checksum, ByteBuffer buffer) {
        int position = buffer.position();
        checksum.update(buffer);
        buffer.position(position);
    }

    public static long abs(long index) {
        long negbit = index >> 63;
        return (index ^ negbit) - negbit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> byte[] serialize(T object, IVersionedSerializer<T> serializer, int version) {
        int size = (int)serializer.serializedSize(object, version);
        try (DataOutputBufferFixed buffer = new DataOutputBufferFixed(size);){
            serializer.serialize(object, buffer, version);
            assert (buffer.getLength() == size && buffer.getData().length == size) : String.format("Final buffer length %s to accommodate data size of %s (predicted %s) for %s", buffer.getData().length, buffer.getLength(), size, object);
            byte[] byArray = buffer.getData();
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long copy(InputStream from, OutputStream to, long limit) throws IOException {
        int sofar;
        byte[] buffer = new byte[64];
        long copied = 0L;
        int toCopy = buffer.length;
        do {
            if (limit < (long)buffer.length + copied) {
                toCopy = (int)(limit - copied);
            }
            if ((sofar = from.read(buffer, 0, toCopy)) == -1) break;
            to.write(buffer, 0, sofar);
        } while (limit != (copied += (long)sofar));
        return copied;
    }

    public static File getToolsOutputDirectory() {
        File historyDir = new File(CassandraRelevantProperties.USER_HOME.getString(), ".cassandra");
        FileUtils.createDirectory(historyDir);
        return historyDir;
    }

    public static void closeAll(Collection<? extends AutoCloseable> l) throws Exception {
        Exception toThrow = null;
        for (AutoCloseable autoCloseable : l) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (toThrow == null) {
                    toThrow = e;
                    continue;
                }
                toThrow.addSuppressed(e);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static byte[] toWriteUTFBytes(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(s);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    public static long align(long val, int boundary) {
        return val + (long)boundary & (long)(~(boundary - 1));
    }

    @VisibleForTesting
    public static void reset() {
        localInetAddress = null;
        localInetAddressAndPort = null;
        broadcastInetAddress = null;
        broadcastInetAddressAndPort = null;
        broadcastNativeAddress = null;
    }

    public static void preventIllegalAccessWarnings() {
        try {
            Class<?> c = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field f = c.getDeclaredField("logger");
            f.setAccessible(true);
            f.set(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String camelToSnake(String camel) {
        StringBuilder sb = new StringBuilder();
        for (char c : camel.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (sb.length() > 0) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        FBUtilities.preventIllegalAccessWarnings();
        jsonMapper.registerModule((Module)new JavaTimeModule());
        jsonMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        logger = LoggerFactory.getLogger(FBUtilities.class);
        TWO = new BigInteger("2");
        OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
        isLinux = OPERATING_SYSTEM.contains("linux");
        availableProcessors = Integer.getInteger("cassandra.available_processors", DatabaseDescriptor.getAvailableProcessors());
        loadedVersionString = Suppliers.memoize(() -> {
            try (InputStream in = FBUtilities.class.getClassLoader().getResourceAsStream("org/apache/cassandra/config/version.properties");){
                if (in == null) {
                    String string2 = null;
                    return string2;
                }
                Properties props = new Properties();
                props.load(in);
                String string = props.getProperty("CassandraVersion");
                return string;
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                logger.warn("Unable to load version.properties", (Throwable)e);
                return "debug version";
            }
        });
    }

    private static final class WrappedCloseableIterator<T>
    extends AbstractIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> source;

        public WrappedCloseableIterator(Iterator<T> source) {
            this.source = source;
        }

        @Override
        protected T computeNext() {
            if (!this.source.hasNext()) {
                return (T)this.endOfData();
            }
            return this.source.next();
        }

        @Override
        public void close() {
        }
    }
}

