/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webservices.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.hop.pipeline.transforms.webservices.wsdl.DomUtils;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlTypes;
import org.w3c.dom.Element;

public final class ComplexType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONST_GROUP = "group";
    public static final String CONST_CHOICE = "choice";
    public static final String CONST_SEQUENCE = "sequence";
    private final HashMap<String, QName> _elements = new HashMap();
    private final List<String> _elementNames = new ArrayList<String>();
    private final String Name;
    private WsdlTypes _wsdlTypes;

    ComplexType(Element type, WsdlTypes wsdlTypes) {
        this.Name = type.getAttribute("name");
        this._wsdlTypes = wsdlTypes;
        Element child = DomUtils.getChildElementByName(type, "simpleContent");
        if (child != null) {
            this.processSimpleContent(child);
        } else {
            child = DomUtils.getChildElementByName(type, "complexContent");
            if (child != null) {
                this.processComplexContent(child);
            } else {
                child = DomUtils.getChildElementByName(type, CONST_GROUP);
                if (child != null) {
                    this.processGroup(child);
                } else {
                    child = DomUtils.getChildElementByName(type, "all");
                    if (child != null) {
                        this.processAll(child);
                    } else {
                        child = DomUtils.getChildElementByName(type, CONST_CHOICE);
                        if (child != null) {
                            this.processChoice(child);
                        } else {
                            child = DomUtils.getChildElementByName(type, CONST_SEQUENCE);
                            if (child != null) {
                                this.processSequence(child);
                            }
                        }
                    }
                }
            }
        }
        this._wsdlTypes = null;
    }

    public String getName() {
        return this.Name;
    }

    public QName getElementType(String elementName) {
        return this._elements.get(elementName.toLowerCase());
    }

    public List<String> listObjectNames() {
        return this._elementNames;
    }

    private void processAll(Element all) {
        List<Element> elements = DomUtils.getChildElementsByName(all, "element");
        Iterator<Element> itr = elements.iterator();
        while (itr.hasNext()) {
            this.processElement(itr.next());
        }
    }

    private void processAny(Element any) {
    }

    private void processChoice(Element choice) {
        this.processSequence(choice);
    }

    private void processComplexContent(Element complexContent) {
        Element child = DomUtils.getChildElementByName(complexContent, "extension");
        if (child != null) {
            this.processComplexExtension(child);
        } else {
            child = DomUtils.getChildElementByName(complexContent, "restriction");
            if (child != null) {
                this.processComplexRestriction(child);
            }
        }
    }

    private void processComplexExtension(Element complexExtension) {
        Element child = DomUtils.getChildElementByName(complexExtension, CONST_GROUP);
        if (child != null) {
            this.processGroup(child);
        } else {
            child = DomUtils.getChildElementByName(complexExtension, "all");
            if (child != null) {
                this.processAll(child);
            } else {
                child = DomUtils.getChildElementByName(complexExtension, CONST_CHOICE);
                if (child != null) {
                    this.processChoice(child);
                } else {
                    child = DomUtils.getChildElementByName(complexExtension, CONST_SEQUENCE);
                    if (child != null) {
                        this.processSequence(child);
                    }
                }
            }
        }
    }

    private void processComplexRestriction(Element complexRestriction) {
        Element child = DomUtils.getChildElementByName(complexRestriction, CONST_GROUP);
        if (child != null) {
            this.processGroup(child);
        } else {
            child = DomUtils.getChildElementByName(complexRestriction, "all");
            if (child != null) {
                this.processAll(child);
            } else {
                child = DomUtils.getChildElementByName(complexRestriction, CONST_CHOICE);
                if (child != null) {
                    this.processChoice(child);
                } else {
                    child = DomUtils.getChildElementByName(complexRestriction, CONST_SEQUENCE);
                    if (child != null) {
                        this.processSequence(child);
                    }
                }
            }
        }
    }

    private void processElement(Element element) {
        if (element.hasAttribute("name")) {
            String elementName = element.getAttribute("name");
            String elementType = element.getAttribute("type");
            this._elements.put(elementName.toLowerCase(), this._wsdlTypes.getTypeQName(elementType));
            this._elementNames.add(elementName);
        }
    }

    private void processGroup(Element group) {
        Element child = DomUtils.getChildElementByName(group, "all");
        if (child != null) {
            this.processAll(child);
        } else {
            child = DomUtils.getChildElementByName(group, CONST_CHOICE);
            if (child != null) {
                this.processChoice(child);
            } else {
                child = DomUtils.getChildElementByName(group, CONST_SEQUENCE);
                if (child != null) {
                    this.processSequence(child);
                }
            }
        }
    }

    private void processSequence(Element sequence) {
        List<Element> elements = DomUtils.getChildElementsByName(sequence, "element");
        Iterator<Element> itr = elements.iterator();
        while (itr.hasNext()) {
            this.processElement(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, CONST_GROUP);
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processGroup(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, CONST_CHOICE);
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processChoice(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, CONST_SEQUENCE);
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processSequence(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, "any");
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processAny(itr.next());
        }
    }

    private void processSimpleContent(Element simpleContent) {
        Element child = DomUtils.getChildElementByName(simpleContent, "extension");
        if (child != null) {
            this.processSimpleExtension(child);
        } else {
            child = DomUtils.getChildElementByName(simpleContent, "restriction");
            if (child != null) {
                this.processSimpleRestriction(child);
            }
        }
    }

    private void processSimpleExtension(Element any) {
    }

    private void processSimpleRestriction(Element simpleRestriction) {
    }
}

