/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

public enum LongTime {

    public static final long MAX_NANOS = Long.MAX_VALUE;
    public static final long MAX_MICROS = 9223372036854775L;
    public static final long MAX_MILLIS = 9223372036854L;
    public static final long MAX_SECS = 9223372036L;
    public static final long EPOCH_SECS = 0L;
    public static final long EPOCH_MILLIS = 9223372037L;
    public static final long EPOCH_MICROS = 9223372037000L;
    public static final long EPOCH_NANOS = 9223372037000000L;

    public static boolean isSecs(long time) {
        return 0L <= time && time <= 9223372036L;
    }

    public static boolean isMillis(long time) {
        return 9223372037L <= time && time <= 9223372036854L;
    }

    public static boolean isMicros(long time) {
        return 9223372037000L <= time && time <= 9223372036854775L;
    }

    public static boolean isNanos(long time) {
        return 9223372037000000L <= time;
    }

    public static long toSecs(long time) {
        if (time < 9223372037L) {
            return time;
        }
        if (time < 9223372037000L) {
            return time / 1000L;
        }
        if (time < 9223372037000000L) {
            return time / 1000000L;
        }
        return time / 1000000000L;
    }

    public static long toMillis(long time) {
        if (time < 0L) {
            return time;
        }
        if (time < 9223372037L) {
            return time * 1000L;
        }
        if (time < 9223372037000L) {
            return time;
        }
        if (time < 9223372037000000L) {
            return time / 1000L;
        }
        return time / 1000000L;
    }

    public static long toMicros(long time) {
        if (time < 0L) {
            return time;
        }
        if (time < 9223372037L) {
            return time * 1000000L;
        }
        if (time < 9223372037000L) {
            return time * 1000L;
        }
        if (time < 9223372037000000L) {
            return time;
        }
        return time / 1000L;
    }

    public static long toNanos(long time) {
        if (time >= 9223372037000000L) {
            return time;
        }
        if (time >= 9223372037000L) {
            return time * 1000L;
        }
        if (time >= 9223372037L) {
            return time * 1000000L;
        }
        if (time >= 0L) {
            return time * 1000000000L;
        }
        return time;
    }
}

