/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.kafka.CheckStopReadingFn;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

class WatchForKafkaTopicPartitions
extends PTransform<PBegin, PCollection<KafkaSourceDescriptor>> {
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_CHECK_DURATION = Duration.standardHours((long)1L);
    private static final @UnknownKeyFor @NonNull @Initialized String COUNTER_NAMESPACE = "watch_kafka_topic_partition";
    private final @UnknownKeyFor @NonNull @Initialized Duration checkDuration;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> kafkaConsumerFactoryFn;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kafkaConsumerConfig;
    private final @Nullable @UnknownKeyFor @Initialized CheckStopReadingFn checkStopReadingFn;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> topics;
    private final @Nullable @UnknownKeyFor @Initialized Pattern topicPattern;
    private final @Nullable @UnknownKeyFor @Initialized Instant startReadTime;
    private final @Nullable @UnknownKeyFor @Initialized Instant stopReadTime;

    public WatchForKafkaTopicPartitions(@Nullable @UnknownKeyFor @Initialized Duration checkDuration, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> kafkaConsumerFactoryFn, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kafkaConsumerConfig, @Nullable @UnknownKeyFor @Initialized CheckStopReadingFn checkStopReadingFn, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> topics, @Nullable @UnknownKeyFor @Initialized Pattern topicPattern, @Nullable @UnknownKeyFor @Initialized Instant startReadTime, @Nullable @UnknownKeyFor @Initialized Instant stopReadTime) {
        this.checkDuration = (Duration)MoreObjects.firstNonNull((Object)checkDuration, (Object)DEFAULT_CHECK_DURATION);
        this.kafkaConsumerFactoryFn = kafkaConsumerFactoryFn;
        this.kafkaConsumerConfig = kafkaConsumerConfig;
        this.checkStopReadingFn = checkStopReadingFn;
        this.topics = topics;
        this.topicPattern = topicPattern;
        this.startReadTime = startReadTime;
        this.stopReadTime = stopReadTime;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KafkaSourceDescriptor> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return (PCollection)((PCollection)((PCollection)input.apply((PTransform)Impulse.create())).apply("Match new TopicPartitions", (PTransform)Watch.growthOf((Watch.Growth.PollFn)new WatchPartitionFn(this.kafkaConsumerFactoryFn, this.kafkaConsumerConfig, this.topics, this.topicPattern)).withPollInterval(this.checkDuration))).apply((PTransform)ParDo.of((DoFn)new ConvertToDescriptor(this.checkStopReadingFn, this.startReadTime, this.stopReadTime)));
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TopicPartition> getAllTopicPartitions(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> kafkaConsumerFactoryFn, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kafkaConsumerConfig, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> topics, @Nullable @UnknownKeyFor @Initialized Pattern topicPattern) {
        ArrayList<TopicPartition> current = new ArrayList<TopicPartition>();
        try (Consumer kafkaConsumer = (Consumer)kafkaConsumerFactoryFn.apply(kafkaConsumerConfig);){
            if (topics != null && !topics.isEmpty()) {
                for (String topic : topics) {
                    for (PartitionInfo partition : kafkaConsumer.partitionsFor(topic)) {
                        current.add(new TopicPartition(topic, partition.partition()));
                    }
                }
            } else {
                for (Map.Entry topicInfo : kafkaConsumer.listTopics().entrySet()) {
                    if (topicPattern != null && !topicPattern.matcher((CharSequence)topicInfo.getKey()).matches()) continue;
                    for (PartitionInfo partition : (List)topicInfo.getValue()) {
                        current.add(new TopicPartition(partition.topic(), partition.partition()));
                    }
                }
            }
        }
        return current;
    }

    private static class WatchPartitionFn
    extends Watch.Growth.PollFn<byte[], TopicPartition> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> kafkaConsumerFactoryFn;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kafkaConsumerConfig;
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> topics;
        private final @Nullable @UnknownKeyFor @Initialized Pattern topicPattern;

        private WatchPartitionFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> kafkaConsumerFactoryFn, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kafkaConsumerConfig, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> topics, @Nullable @UnknownKeyFor @Initialized Pattern topicPattern) {
            this.kafkaConsumerFactoryFn = kafkaConsumerFactoryFn;
            this.kafkaConsumerConfig = kafkaConsumerConfig;
            this.topics = topics;
            this.topicPattern = topicPattern;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.PollResult<@UnknownKeyFor @NonNull @Initialized TopicPartition> apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] element, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Contextful.Fn.Context c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Instant now = Instant.now();
            return Watch.Growth.PollResult.incomplete((Instant)now, WatchForKafkaTopicPartitions.getAllTopicPartitions(this.kafkaConsumerFactoryFn, this.kafkaConsumerConfig, this.topics, this.topicPattern)).withWatermark(now);
        }
    }

    private static class ConvertToDescriptor
    extends DoFn<KV<byte[], TopicPartition>, KafkaSourceDescriptor> {
        private final @Nullable @UnknownKeyFor @Initialized CheckStopReadingFn checkStopReadingFn;
        private final @Nullable @UnknownKeyFor @Initialized Instant startReadTime;
        private final @Nullable @UnknownKeyFor @Initialized Instant stopReadTime;

        private ConvertToDescriptor(@Nullable @UnknownKeyFor @Initialized CheckStopReadingFn checkStopReadingFn, @Nullable @UnknownKeyFor @Initialized Instant startReadTime, @Nullable @UnknownKeyFor @Initialized Instant stopReadTime) {
            this.checkStopReadingFn = checkStopReadingFn;
            this.startReadTime = startReadTime;
            this.stopReadTime = stopReadTime;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized TopicPartition> partition, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KafkaSourceDescriptor> receiver) {
            TopicPartition topicPartition = Objects.requireNonNull((TopicPartition)partition.getValue());
            if (this.checkStopReadingFn == null || !((Boolean)this.checkStopReadingFn.apply(topicPartition)).booleanValue()) {
                Counter foundedTopicPartition = Metrics.counter((String)WatchForKafkaTopicPartitions.COUNTER_NAMESPACE, (String)topicPartition.toString());
                foundedTopicPartition.inc();
                receiver.output((Object)KafkaSourceDescriptor.of(topicPartition, null, this.startReadTime, null, this.stopReadTime, null));
            }
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.checkStopReadingFn != null) {
                this.checkStopReadingFn.setup();
            }
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.checkStopReadingFn != null) {
                this.checkStopReadingFn.teardown();
            }
        }
    }
}

