/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.AutoValue_ErrorHandling;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class ErrorHandling
implements Serializable {
    @SchemaFieldDescription(value="The name of the output PCollection containing failed writes.")
    public abstract @UnknownKeyFor @NonNull @Initialized String getOutput();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_ErrorHandling.Builder();
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasOutput(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling errorHandling) {
        return ErrorHandling.getOutputOrNull(errorHandling) != null;
    }

    @Nullable
    public static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getOutputOrNull(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling errorHandling) {
        return errorHandling == null ? null : errorHandling.getOutput();
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema errorSchema(@UnknownKeyFor @NonNull @Initialized Schema inputSchema) {
        return Schema.of(Schema.Field.of("failed_row", Schema.FieldType.row(inputSchema)), Schema.Field.of("error_message", Schema.FieldType.STRING));
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema errorSchemaBytes() {
        return Schema.of(Schema.Field.of("failed_row", Schema.FieldType.BYTES), Schema.Field.of("error_message", Schema.FieldType.STRING));
    }

    public static @UnknownKeyFor @NonNull @Initialized Row errorRecord(@UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized Row inputRow, @UnknownKeyFor @NonNull @Initialized Throwable th) {
        return Row.withSchema(errorSchema).withFieldValue("failed_row", (Object)inputRow).withFieldValue("error_message", (Object)th.getMessage()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Row errorRecord(@UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] inputBytes, @UnknownKeyFor @NonNull @Initialized Throwable th) {
        return Row.withSchema(errorSchema).withFieldValue("failed_row", (Object)inputBytes).withFieldValue("error_message", (Object)th.getMessage()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutput(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized ErrorHandling build();
    }
}

