/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryWriteConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_BigQueryWriteConfiguration
extends BigQueryWriteConfiguration {
    private final String table;
    private final @Nullable String createDisposition;
    private final @Nullable String writeDisposition;
    private final @Nullable Long triggeringFrequencySeconds;
    private final @Nullable Boolean useAtLeastOnceSemantics;
    private final @Nullable Boolean autoSharding;
    private final @Nullable Integer numStreams;
    private final @Nullable String kmsKey;
    private final @Nullable BigQueryWriteConfiguration.ErrorHandling errorHandling;
    private final @Nullable Boolean useCdcWrites;
    private final @Nullable List<String> primaryKey;
    private final @Nullable List<String> keep;
    private final @Nullable List<String> drop;
    private final @Nullable String only;

    private AutoValue_BigQueryWriteConfiguration(String table, @Nullable String createDisposition, @Nullable String writeDisposition, @Nullable Long triggeringFrequencySeconds, @Nullable Boolean useAtLeastOnceSemantics, @Nullable Boolean autoSharding, @Nullable Integer numStreams, @Nullable String kmsKey, @Nullable BigQueryWriteConfiguration.ErrorHandling errorHandling, @Nullable Boolean useCdcWrites, @Nullable List<String> primaryKey, @Nullable List<String> keep, @Nullable List<String> drop, @Nullable String only) {
        this.table = table;
        this.createDisposition = createDisposition;
        this.writeDisposition = writeDisposition;
        this.triggeringFrequencySeconds = triggeringFrequencySeconds;
        this.useAtLeastOnceSemantics = useAtLeastOnceSemantics;
        this.autoSharding = autoSharding;
        this.numStreams = numStreams;
        this.kmsKey = kmsKey;
        this.errorHandling = errorHandling;
        this.useCdcWrites = useCdcWrites;
        this.primaryKey = primaryKey;
        this.keep = keep;
        this.drop = drop;
        this.only = only;
    }

    @Override
    @SchemaFieldDescription(value="The bigquery table to write to. Format: [${PROJECT}:]${DATASET}.${TABLE}")
    public String getTable() {
        return this.table;
    }

    @Override
    @SchemaFieldDescription(value="Optional field that specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED (the job may create the table), CREATE_NEVER (the job must fail if the table does not exist already).")
    public @Nullable String getCreateDisposition() {
        return this.createDisposition;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE (overwrites the table data), WRITE_APPEND (append the data to the table), WRITE_EMPTY (job must fail if the table is not empty).")
    public @Nullable String getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    @SchemaFieldDescription(value="Determines how often to 'commit' progress into BigQuery. Default is every 5 seconds.")
    public @Nullable Long getTriggeringFrequencySeconds() {
        return this.triggeringFrequencySeconds;
    }

    @Override
    @SchemaFieldDescription(value="This option enables lower latency for insertions to BigQuery but may ocassionally duplicate data elements.")
    public @Nullable Boolean getUseAtLeastOnceSemantics() {
        return this.useAtLeastOnceSemantics;
    }

    @Override
    @SchemaFieldDescription(value="This option enables using a dynamically determined number of Storage Write API streams to write to BigQuery. Only applicable to unbounded data.")
    public @Nullable Boolean getAutoSharding() {
        return this.autoSharding;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the number of write streams that the Storage API sink will use. This parameter is only applicable when writing unbounded data.")
    public @Nullable Integer getNumStreams() {
        return this.numStreams;
    }

    @Override
    @SchemaFieldDescription(value="Use this Cloud KMS key to encrypt your data")
    public @Nullable String getKmsKey() {
        return this.kmsKey;
    }

    @Override
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public @Nullable BigQueryWriteConfiguration.ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="This option enables the use of BigQuery CDC functionality. The expected PCollection should contain Beam Rows with a schema wrapping the record to be inserted and adding the CDC info similar to: {row_mutation_info: {mutation_type:\"...\", change_sequence_number:\"...\"}, record: {...}}")
    public @Nullable Boolean getUseCdcWrites() {
        return this.useCdcWrites;
    }

    @Override
    @SchemaFieldDescription(value="If CREATE_IF_NEEDED disposition is set, BigQuery table(s) will be created with this columns as primary key. Required when CDC writes are enabled with CREATE_IF_NEEDED.")
    public @Nullable List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    @SchemaFieldDescription(value="A list of field names to keep in the input record. All other fields are dropped before writing. Is mutually exclusive with 'drop' and 'only'.")
    public @Nullable List<String> getKeep() {
        return this.keep;
    }

    @Override
    @SchemaFieldDescription(value="A list of field names to drop from the input record before writing. Is mutually exclusive with 'keep' and 'only'.")
    public @Nullable List<String> getDrop() {
        return this.drop;
    }

    @Override
    @SchemaFieldDescription(value="The name of a single record field that should be written. Is mutually exclusive with 'keep' and 'drop'.")
    public @Nullable String getOnly() {
        return this.only;
    }

    public String toString() {
        return "BigQueryWriteConfiguration{table=" + this.table + ", createDisposition=" + this.createDisposition + ", writeDisposition=" + this.writeDisposition + ", triggeringFrequencySeconds=" + this.triggeringFrequencySeconds + ", useAtLeastOnceSemantics=" + this.useAtLeastOnceSemantics + ", autoSharding=" + this.autoSharding + ", numStreams=" + this.numStreams + ", kmsKey=" + this.kmsKey + ", errorHandling=" + this.errorHandling + ", useCdcWrites=" + this.useCdcWrites + ", primaryKey=" + this.primaryKey + ", keep=" + this.keep + ", drop=" + this.drop + ", only=" + this.only + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQueryWriteConfiguration) {
            BigQueryWriteConfiguration that = (BigQueryWriteConfiguration)o;
            return this.table.equals(that.getTable()) && (this.createDisposition == null ? that.getCreateDisposition() == null : this.createDisposition.equals(that.getCreateDisposition())) && (this.writeDisposition == null ? that.getWriteDisposition() == null : this.writeDisposition.equals(that.getWriteDisposition())) && (this.triggeringFrequencySeconds == null ? that.getTriggeringFrequencySeconds() == null : this.triggeringFrequencySeconds.equals(that.getTriggeringFrequencySeconds())) && (this.useAtLeastOnceSemantics == null ? that.getUseAtLeastOnceSemantics() == null : this.useAtLeastOnceSemantics.equals(that.getUseAtLeastOnceSemantics())) && (this.autoSharding == null ? that.getAutoSharding() == null : this.autoSharding.equals(that.getAutoSharding())) && (this.numStreams == null ? that.getNumStreams() == null : this.numStreams.equals(that.getNumStreams())) && (this.kmsKey == null ? that.getKmsKey() == null : this.kmsKey.equals(that.getKmsKey())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling())) && (this.useCdcWrites == null ? that.getUseCdcWrites() == null : this.useCdcWrites.equals(that.getUseCdcWrites())) && (this.primaryKey == null ? that.getPrimaryKey() == null : this.primaryKey.equals(that.getPrimaryKey())) && (this.keep == null ? that.getKeep() == null : this.keep.equals(that.getKeep())) && (this.drop == null ? that.getDrop() == null : this.drop.equals(that.getDrop())) && (this.only == null ? that.getOnly() == null : this.only.equals(that.getOnly()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.table.hashCode();
        h$ *= 1000003;
        h$ ^= this.createDisposition == null ? 0 : this.createDisposition.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeDisposition == null ? 0 : this.writeDisposition.hashCode();
        h$ *= 1000003;
        h$ ^= this.triggeringFrequencySeconds == null ? 0 : this.triggeringFrequencySeconds.hashCode();
        h$ *= 1000003;
        h$ ^= this.useAtLeastOnceSemantics == null ? 0 : this.useAtLeastOnceSemantics.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoSharding == null ? 0 : this.autoSharding.hashCode();
        h$ *= 1000003;
        h$ ^= this.numStreams == null ? 0 : this.numStreams.hashCode();
        h$ *= 1000003;
        h$ ^= this.kmsKey == null ? 0 : this.kmsKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
        h$ *= 1000003;
        h$ ^= this.useCdcWrites == null ? 0 : this.useCdcWrites.hashCode();
        h$ *= 1000003;
        h$ ^= this.primaryKey == null ? 0 : this.primaryKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.keep == null ? 0 : this.keep.hashCode();
        h$ *= 1000003;
        h$ ^= this.drop == null ? 0 : this.drop.hashCode();
        h$ *= 1000003;
        return h$ ^= this.only == null ? 0 : this.only.hashCode();
    }

    static final class Builder
    extends BigQueryWriteConfiguration.Builder {
        private String table;
        private @Nullable String createDisposition;
        private @Nullable String writeDisposition;
        private @Nullable Long triggeringFrequencySeconds;
        private @Nullable Boolean useAtLeastOnceSemantics;
        private @Nullable Boolean autoSharding;
        private @Nullable Integer numStreams;
        private @Nullable String kmsKey;
        private @Nullable BigQueryWriteConfiguration.ErrorHandling errorHandling;
        private @Nullable Boolean useCdcWrites;
        private @Nullable List<String> primaryKey;
        private @Nullable List<String> keep;
        private @Nullable List<String> drop;
        private @Nullable String only;

        Builder() {
        }

        @Override
        public BigQueryWriteConfiguration.Builder setTable(String table) {
            if (table == null) {
                throw new NullPointerException("Null table");
            }
            this.table = table;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setCreateDisposition(String createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setWriteDisposition(String writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setTriggeringFrequencySeconds(Long triggeringFrequencySeconds) {
            this.triggeringFrequencySeconds = triggeringFrequencySeconds;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setUseAtLeastOnceSemantics(Boolean useAtLeastOnceSemantics) {
            this.useAtLeastOnceSemantics = useAtLeastOnceSemantics;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setAutoSharding(Boolean autoSharding) {
            this.autoSharding = autoSharding;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setNumStreams(Integer numStreams) {
            this.numStreams = numStreams;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setErrorHandling(BigQueryWriteConfiguration.ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setUseCdcWrites(Boolean useCdcWrites) {
            this.useCdcWrites = useCdcWrites;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setPrimaryKey(List<String> primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setKeep(List<String> keep) {
            this.keep = keep;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setDrop(List<String> drop) {
            this.drop = drop;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration.Builder setOnly(String only) {
            this.only = only;
            return this;
        }

        @Override
        public BigQueryWriteConfiguration build() {
            if (this.table == null) {
                String missing = " table";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryWriteConfiguration(this.table, this.createDisposition, this.writeDisposition, this.triggeringFrequencySeconds, this.useAtLeastOnceSemantics, this.autoSharding, this.numStreams, this.kmsKey, this.errorHandling, this.useCdcWrites, this.primaryKey, this.keep, this.drop, this.only);
        }
    }
}

