/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import io.micrometer.context.ContextAccessor;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import io.micrometer.context.ThreadLocalAccessor;
import java.util.AbstractQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.internal.shaded.reactor.core.observability.SignalListener;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ContextPropagationSupport;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxContextWriteRestoringThreadLocals;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxContextWriteRestoringThreadLocalsFuseable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.MonoContextWriteRestoringThreadLocals;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SignalType;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SynchronousSink;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;
import org.neo4j.driver.internal.shaded.reactor.util.context.ContextView;

final class ContextPropagation {
    static final Function<Context, Context> NO_OP = c -> c;
    static final Function<Context, Context> WITH_GLOBAL_REGISTRY_NO_PREDICATE;
    static ContextSnapshotFactory globalContextSnapshotFactory;

    ContextPropagation() {
    }

    static <T> Flux<T> fluxRestoreThreadLocals(Flux<? extends T> flux, boolean fuseable) {
        return fuseable ? new FluxContextWriteRestoringThreadLocalsFuseable<T>(flux, Function.identity()) : new FluxContextWriteRestoringThreadLocals<T>(flux, Function.identity());
    }

    static <T> Mono<T> monoRestoreThreadLocals(Mono<? extends T> mono) {
        return new MonoContextWriteRestoringThreadLocals<T>(mono, Function.identity());
    }

    static void configureContextSnapshotFactory(boolean clearMissing) {
        if (ContextPropagationSupport.isContextPropagation103OnClasspath) {
            globalContextSnapshotFactory = ContextSnapshotFactory.builder().clearMissing(clearMissing).build();
        }
    }

    static <C> ContextSnapshot.Scope setThreadLocals(Object context) {
        if (ContextPropagationSupport.isContextPropagation103OnClasspath) {
            return globalContextSnapshotFactory.setThreadLocalsFrom(context, new String[0]);
        }
        ContextRegistry registry = ContextRegistry.getInstance();
        ContextAccessor contextAccessor = registry.getContextAccessorForRead(context);
        Map<Object, Object> previousValues = null;
        for (ThreadLocalAccessor threadLocalAccessor : registry.getThreadLocalAccessors()) {
            Object key = threadLocalAccessor.key();
            Object value = contextAccessor.readValue(context, key);
            previousValues = ContextPropagation.setThreadLocal(key, value, threadLocalAccessor, previousValues);
        }
        if (ContextPropagationSupport.isContextPropagation101Available()) {
            return ReactorScopeImpl.from(previousValues, registry);
        }
        return ReactorScopeImpl100.from(previousValues, registry);
    }

    private static <V> Map<Object, Object> setThreadLocal(Object key, @Nullable V value, ThreadLocalAccessor<?> accessor, @Nullable Map<Object, Object> previousValues) {
        previousValues = previousValues != null ? previousValues : new HashMap<Object, Object>();
        previousValues.put(key, accessor.getValue());
        if (value != null) {
            accessor.setValue(value);
        } else {
            accessor.reset();
        }
        return previousValues;
    }

    static ContextSnapshot captureThreadLocals() {
        if (ContextPropagationSupport.isContextPropagation103OnClasspath) {
            return globalContextSnapshotFactory.captureAll(new Object[0]);
        }
        return ContextSnapshot.captureAll((Object[])new Object[0]);
    }

    public static Function<Runnable, Runnable> scopePassingOnScheduleHook() {
        return delegate -> {
            ContextSnapshot contextSnapshot = ContextPropagation.captureThreadLocals();
            return contextSnapshot.wrap(delegate);
        };
    }

    static Function<Context, Context> contextCapture() {
        return WITH_GLOBAL_REGISTRY_NO_PREDICATE;
    }

    static Context contextCaptureToEmpty() {
        return ContextPropagation.contextCapture().apply(Context.empty());
    }

    static <T, R> BiConsumer<T, SynchronousSink<R>> contextRestoreForHandle(BiConsumer<T, SynchronousSink<R>> handler, Supplier<Context> contextSupplier) {
        if (ContextPropagationSupport.shouldRestoreThreadLocalsInSomeOperators()) {
            Context ctx = contextSupplier.get();
            if (ctx.isEmpty()) {
                return handler;
            }
            if (ContextPropagationSupport.isContextPropagation103OnClasspath) {
                return (v, sink) -> {
                    try (ContextSnapshot.Scope ignored = globalContextSnapshotFactory.setThreadLocalsFrom((Object)ctx, new String[0]);){
                        handler.accept((Object)v, (SynchronousSink)sink);
                    }
                };
            }
            return (v, sink) -> {
                try (ContextSnapshot.Scope ignored = ContextSnapshot.setAllThreadLocalsFrom((Object)ctx);){
                    handler.accept((Object)v, (SynchronousSink)sink);
                }
            };
        }
        return handler;
    }

    static <T> SignalListener<T> contextRestoreForTap(SignalListener<T> original, Supplier<Context> contextSupplier) {
        if (!ContextPropagationSupport.isContextPropagationAvailable()) {
            return original;
        }
        Context ctx = contextSupplier.get();
        if (ctx.isEmpty()) {
            return original;
        }
        if (ContextPropagationSupport.isContextPropagation103OnClasspath) {
            return new ContextRestore103SignalListener<T>(original, ctx, globalContextSnapshotFactory);
        }
        return new ContextRestoreSignalListener<T>(original, ctx);
    }

    static {
        globalContextSnapshotFactory = null;
        ContextCaptureNoPredicate contextCaptureNoPredicate = WITH_GLOBAL_REGISTRY_NO_PREDICATE = ContextPropagationSupport.isContextPropagationAvailable() ? new ContextCaptureNoPredicate() : NO_OP;
        if (ContextPropagationSupport.isContextPropagation103Available()) {
            globalContextSnapshotFactory = ContextSnapshotFactory.builder().clearMissing(false).build();
        }
    }

    private static class ReactorScopeImpl100
    implements ContextSnapshot.Scope {
        private final Map<Object, Object> previousValues;
        private final ContextRegistry contextRegistry;

        private ReactorScopeImpl100(Map<Object, Object> previousValues, ContextRegistry contextRegistry) {
            this.previousValues = previousValues;
            this.contextRegistry = contextRegistry;
        }

        public void close() {
            for (ThreadLocalAccessor accessor : this.contextRegistry.getThreadLocalAccessors()) {
                if (!this.previousValues.containsKey(accessor.key())) continue;
                Object previousValue = this.previousValues.get(accessor.key());
                this.resetThreadLocalValue(accessor, previousValue);
            }
        }

        private <V> void resetThreadLocalValue(ThreadLocalAccessor<?> accessor, @Nullable V previousValue) {
            if (previousValue != null) {
                accessor.setValue(previousValue);
            } else {
                accessor.reset();
            }
        }

        public static ContextSnapshot.Scope from(@Nullable Map<Object, Object> previousValues, ContextRegistry registry) {
            return previousValues != null ? new ReactorScopeImpl100(previousValues, registry) : () -> {};
        }
    }

    private static class ReactorScopeImpl
    implements ContextSnapshot.Scope {
        private final Map<Object, Object> previousValues;
        private final ContextRegistry contextRegistry;

        private ReactorScopeImpl(Map<Object, Object> previousValues, ContextRegistry contextRegistry) {
            this.previousValues = previousValues;
            this.contextRegistry = contextRegistry;
        }

        public void close() {
            for (ThreadLocalAccessor accessor : this.contextRegistry.getThreadLocalAccessors()) {
                if (!this.previousValues.containsKey(accessor.key())) continue;
                Object previousValue = this.previousValues.get(accessor.key());
                this.resetThreadLocalValue(accessor, previousValue);
            }
        }

        private <V> void resetThreadLocalValue(ThreadLocalAccessor<?> accessor, @Nullable V previousValue) {
            if (previousValue != null) {
                accessor.restore(previousValue);
            } else {
                accessor.reset();
            }
        }

        public static ContextSnapshot.Scope from(@Nullable Map<Object, Object> previousValues, ContextRegistry registry) {
            return previousValues != null ? new ReactorScopeImpl(previousValues, registry) : () -> {};
        }
    }

    static class Envelope<T> {
        final T body;
        final ContextSnapshot contextSnapshot;

        Envelope(T body, ContextSnapshot contextSnapshot) {
            this.body = body;
            this.contextSnapshot = contextSnapshot;
        }
    }

    static final class ContextQueue<T>
    extends AbstractQueue<T> {
        static final String NOT_SUPPORTED_MESSAGE = "ContextQueue wrapper is intended for use with instances returned by Queues class. Iterator based methods are usually unsupported.";
        final Queue<Envelope<T>> envelopeQueue;
        boolean cleanOnNull;
        boolean hasPrevious = false;
        Thread lastReader;
        ContextSnapshot.Scope scope;

        ContextQueue(Queue<?> queue) {
            this.envelopeQueue = queue;
        }

        @Override
        public int size() {
            return this.envelopeQueue.size();
        }

        @Override
        public boolean offer(T o) {
            ContextSnapshot contextSnapshot = ContextPropagation.captureThreadLocals();
            return this.envelopeQueue.offer(new Envelope<T>(o, contextSnapshot));
        }

        @Override
        public T poll() {
            Envelope<T> envelope = this.envelopeQueue.poll();
            if (envelope == null) {
                if (this.cleanOnNull && this.scope != null) {
                    this.scope.close();
                }
                this.cleanOnNull = true;
                this.lastReader = Thread.currentThread();
                this.hasPrevious = false;
                return null;
            }
            this.restoreTheContext(envelope);
            this.hasPrevious = true;
            return envelope.body;
        }

        private void restoreTheContext(Envelope<T> envelope) {
            ContextSnapshot contextSnapshot = envelope.contextSnapshot;
            ContextSnapshot currentContextSnapshot = ContextPropagation.captureThreadLocals();
            if (!contextSnapshot.equals(currentContextSnapshot)) {
                if (!this.hasPrevious || !Thread.currentThread().equals(this.lastReader)) {
                    this.cleanOnNull = true;
                    this.lastReader = Thread.currentThread();
                }
                this.scope = contextSnapshot.setThreadLocals();
            } else if (!this.hasPrevious || !Thread.currentThread().equals(this.lastReader)) {
                this.cleanOnNull = false;
                this.lastReader = Thread.currentThread();
            }
        }

        @Override
        @Nullable
        public T peek() {
            Envelope<T> envelope = this.envelopeQueue.peek();
            return envelope == null ? null : (T)envelope.body;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
        }
    }

    static final class ContextCaptureNoPredicate
    implements Function<Context, Context> {
        ContextCaptureNoPredicate() {
        }

        @Override
        public Context apply(Context context) {
            return (Context)ContextPropagation.captureThreadLocals().updateContext((Object)context);
        }
    }

    static final class ContextRestore103SignalListener<T>
    extends ContextRestoreSignalListener<T> {
        final ContextSnapshotFactory contextSnapshotFactory;

        public ContextRestore103SignalListener(SignalListener<T> original, ContextView context, ContextSnapshotFactory contextSnapshotFactory) {
            super(original, context);
            this.contextSnapshotFactory = contextSnapshotFactory;
        }

        @Override
        ContextSnapshot.Scope restoreThreadLocals() {
            return this.contextSnapshotFactory.setThreadLocalsFrom((Object)this.context, new String[0]);
        }
    }

    static class ContextRestoreSignalListener<T>
    implements SignalListener<T> {
        final SignalListener<T> original;
        final ContextView context;

        public ContextRestoreSignalListener(SignalListener<T> original, ContextView context) {
            this.original = original;
            this.context = context;
        }

        ContextSnapshot.Scope restoreThreadLocals() {
            return ContextSnapshot.setAllThreadLocalsFrom((Object)this.context);
        }

        @Override
        public final void doFirst() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doFirst();
            }
        }

        @Override
        public final void doFinally(SignalType terminationType) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doFinally(terminationType);
            }
        }

        @Override
        public final void doOnSubscription() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnSubscription();
            }
        }

        @Override
        public final void doOnFusion(int negotiatedFusion) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnFusion(negotiatedFusion);
            }
        }

        @Override
        public final void doOnRequest(long requested) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnRequest(requested);
            }
        }

        @Override
        public final void doOnCancel() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnCancel();
            }
        }

        @Override
        public final void doOnNext(T value) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnNext(value);
            }
        }

        @Override
        public final void doOnComplete() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnComplete();
            }
        }

        @Override
        public final void doOnError(Throwable error) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnError(error);
            }
        }

        @Override
        public final void doAfterComplete() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doAfterComplete();
            }
        }

        @Override
        public final void doAfterError(Throwable error) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doAfterError(error);
            }
        }

        @Override
        public final void doOnMalformedOnNext(T value) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnMalformedOnNext(value);
            }
        }

        @Override
        public final void doOnMalformedOnError(Throwable error) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnMalformedOnError(error);
            }
        }

        @Override
        public final void doOnMalformedOnComplete() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnMalformedOnComplete();
            }
        }

        @Override
        public final void handleListenerError(Throwable listenerError) {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.handleListenerError(listenerError);
            }
        }

        @Override
        public final Context addToContext(Context originalContext) {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                Context context = this.original.addToContext(originalContext);
                return context;
            }
        }
    }
}

