/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;

@HopServerServlet(id="registerExecInfo", name="Register execution information")
public class DeleteExecutionInfoServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -1901302231769020201L;
    public static final String CONTEXT_PATH = "/hop/deleteExecInfo";
    public static final String PARAMETER_ID = "id";
    public static final String PARAMETER_LOCATION = "location";

    public DeleteExecutionInfoServlet() {
    }

    public DeleteExecutionInfoServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Delete execution information");
        }
        String id = StringEscapeUtils.escapeHtml((String)request.getParameter(PARAMETER_ID));
        String locationName = StringEscapeUtils.escapeHtml((String)request.getParameter(PARAMETER_LOCATION));
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        response.setContentType("text/xml");
        out.print(XmlHandler.getXmlHeader());
        response.setStatus(200);
        try {
            if (StringUtils.isEmpty((String)id)) {
                throw new HopException("Please specify the ID of the execution to delete.");
            }
            if (StringUtils.isEmpty((String)locationName)) {
                throw new HopException("Please specify the name of the execution information location to delete in.");
            }
            MultiMetadataProvider provider = this.pipelineMap.getHopServerConfig().getMetadataProvider();
            IHopMetadataSerializer serializer = provider.getSerializer(ExecutionInfoLocation.class);
            ExecutionInfoLocation location = (ExecutionInfoLocation)serializer.load(locationName);
            if (location == null) {
                throw new HopException("Unable to find execution information location " + locationName);
            }
            location.getExecutionInfoLocation().deleteExecution(id);
            out.println(new WebResult("OK", "Execution deletion was successful at location " + locationName));
        }
        catch (Exception ex) {
            out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
        }
    }

    public String toString() {
        return "Delete execution";
    }

    @Override
    public String getService() {
        return "/hop/deleteExecInfo (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

