/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.queryablestate.network.messages.MessageType;
import org.apache.flink.queryablestate.network.messages.RequestFailure;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufOutputStream;
import org.apache.flink.util.Preconditions;

@Internal
public final class MessageSerializer<REQ extends MessageBody, RESP extends MessageBody> {
    private static final int VERSION = 2040641296;
    private static final int HEADER_LENGTH = 8;
    private static final int REQUEST_ID_SIZE = 8;
    private final MessageDeserializer<REQ> requestDeserializer;
    private final MessageDeserializer<RESP> responseDeserializer;

    public MessageSerializer(MessageDeserializer<REQ> requestDeser, MessageDeserializer<RESP> responseDeser) {
        this.requestDeserializer = (MessageDeserializer)Preconditions.checkNotNull(requestDeser);
        this.responseDeserializer = (MessageDeserializer)Preconditions.checkNotNull(responseDeser);
    }

    public static <REQ extends MessageBody> ByteBuf serializeRequest(ByteBufAllocator alloc, long requestId, REQ request) {
        Preconditions.checkNotNull(request);
        return MessageSerializer.writePayload(alloc, requestId, MessageType.REQUEST, request.serialize());
    }

    public static <RESP extends MessageBody> ByteBuf serializeResponse(ByteBufAllocator alloc, long requestId, RESP response) {
        Preconditions.checkNotNull(response);
        return MessageSerializer.writePayload(alloc, requestId, MessageType.REQUEST_RESULT, response.serialize());
    }

    public static ByteBuf serializeRequestFailure(ByteBufAllocator alloc, long requestId, Throwable cause) throws IOException {
        ByteBuf buf = alloc.ioBuffer();
        buf.writeInt(0);
        MessageSerializer.writeHeader(buf, MessageType.REQUEST_FAILURE);
        buf.writeLong(requestId);
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(buf);
             ObjectOutputStream out = new ObjectOutputStream((OutputStream)bbos);){
            out.writeObject(cause);
        }
        int frameLength = buf.readableBytes() - 4;
        buf.setInt(0, frameLength);
        return buf;
    }

    public static ByteBuf serializeServerFailure(ByteBufAllocator alloc, Throwable cause) throws IOException {
        ByteBuf buf = alloc.ioBuffer();
        buf.writeInt(0);
        MessageSerializer.writeHeader(buf, MessageType.SERVER_FAILURE);
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(buf);
             ObjectOutputStream out = new ObjectOutputStream((OutputStream)bbos);){
            out.writeObject(cause);
        }
        int frameLength = buf.readableBytes() - 4;
        buf.setInt(0, frameLength);
        return buf;
    }

    private static void writeHeader(ByteBuf buf, MessageType messageType) {
        buf.writeInt(2040641296);
        buf.writeInt(messageType.ordinal());
    }

    private static ByteBuf writePayload(ByteBufAllocator alloc, long requestId, MessageType messageType, byte[] payload) {
        int frameLength = 16 + payload.length;
        ByteBuf buf = alloc.ioBuffer(frameLength + 4);
        buf.writeInt(frameLength);
        MessageSerializer.writeHeader(buf, messageType);
        buf.writeLong(requestId);
        buf.writeBytes(payload);
        return buf;
    }

    public static MessageType deserializeHeader(ByteBuf buf) {
        int version = buf.readInt();
        Preconditions.checkState((version == 2040641296 ? 1 : 0) != 0, (Object)("Version Mismatch:  Found " + version + ", Expected: " + 2040641296 + '.'));
        int msgType = buf.readInt();
        MessageType[] values = MessageType.values();
        Preconditions.checkState((msgType >= 0 && msgType < values.length ? 1 : 0) != 0, (Object)("Illegal message type with index " + msgType + '.'));
        return values[msgType];
    }

    public static long getRequestId(ByteBuf buf) {
        return buf.readLong();
    }

    public REQ deserializeRequest(ByteBuf buf) {
        Preconditions.checkNotNull((Object)buf);
        return this.requestDeserializer.deserializeMessage(buf);
    }

    public RESP deserializeResponse(ByteBuf buf) {
        Preconditions.checkNotNull((Object)buf);
        return this.responseDeserializer.deserializeMessage(buf);
    }

    public static RequestFailure deserializeRequestFailure(ByteBuf buf) throws IOException, ClassNotFoundException {
        Throwable cause;
        long requestId = buf.readLong();
        try (ByteBufInputStream bis = new ByteBufInputStream(buf);
             ObjectInputStream in = new ObjectInputStream((InputStream)bis);){
            cause = (Throwable)in.readObject();
        }
        return new RequestFailure(requestId, cause);
    }

    /*
     * Exception decompiling
     */
    public static Throwable deserializeServerFailure(ByteBuf buf) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

