/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.util.ReflectionUtil;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class FileTree
extends Composite {
    private static final Class<?> PKG = FileTree.class;
    private Set<FileObject> fileObjects = new LinkedHashSet<FileObject>();
    private final AtomicBoolean findDependencies = new AtomicBoolean(true);
    private static final String FILE_OBJECT = "fileObject";
    private static final String FOLDER = "folder";
    private final Tree tree;

    public FileTree(Composite composite, FileObject rootFolder, String rootFolderName) throws FileSystemException {
        super(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        PropsUi.setLook((Widget)this);
        this.tree = new Tree((Composite)this, 34);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.tree.setLayoutData((Object)gd);
        Button btnFindDependencies = new Button((Composite)this, 32);
        btnFindDependencies.setSelection(true);
        btnFindDependencies.addListener(13, event -> this.findDependencies.set(btnFindDependencies.getSelection()));
        GridData gdBtnFindDependencies = new GridData(32);
        gdBtnFindDependencies.verticalIndent = 10;
        btnFindDependencies.setLayoutData((Object)gdBtnFindDependencies);
        Label lblFindDependencies = new Label((Composite)this, 0);
        lblFindDependencies.setText(BaseMessages.getString(PKG, (String)"FileTreeWidget.IncludeDependencies.Label", (String[])new String[0]));
        GridData gdLblFindDependencies = new GridData(768);
        gdLblFindDependencies.verticalIndent = 10;
        lblFindDependencies.setLayoutData((Object)gdLblFindDependencies);
        TreeItem rootItem = new TreeItem(this.tree, 0);
        rootItem.setText(rootFolderName);
        rootItem.setImage(GuiResource.getInstance().getImageFolder());
        rootItem.setData("type", (Object)FOLDER);
        rootItem.setData(FILE_OBJECT, (Object)rootFolder);
        this.populateFolder(rootFolder, rootItem);
        this.tree.addListener(13, event -> {
            if (event.detail == 32) {
                TreeItem[] selectedTreeItems = this.tree.getSelection();
                TreeItem item = (TreeItem)event.item;
                boolean checked = item.getChecked();
                if (selectedTreeItems.length > 0) {
                    for (TreeItem treeItem : selectedTreeItems) {
                        if (!treeItem.getChecked() != checked) continue;
                        this.selectionEvent(rootItem, treeItem, checked);
                    }
                } else {
                    this.selectionEvent(rootItem, item, checked);
                }
                this.tree.deselectAll();
            }
        });
        rootItem.setExpanded(true);
    }

    private void selectionEvent(TreeItem rootItem, TreeItem treeItem, boolean checked) {
        if (treeItem.getData("type").equals(FOLDER)) {
            this.checkItems(rootItem, treeItem, checked);
            this.checkGrayedItems(treeItem);
        } else {
            FileObject fileObject = (FileObject)treeItem.getData(FILE_OBJECT);
            if (this.findDependencies.get()) {
                this.addDependencies(fileObject, rootItem, checked);
            }
            if (checked) {
                this.fileObjects.add(fileObject);
                treeItem.setChecked(true);
            } else {
                this.fileObjects.remove(fileObject);
                treeItem.setChecked(false);
            }
            this.checkGrayedItems(treeItem.getParentItem());
        }
    }

    private void populateFolder(FileObject folder, TreeItem folderItem) throws FileSystemException {
        String baseFilename;
        Object[] children = folder.getChildren();
        Arrays.sort(children);
        for (Object child : children) {
            if (!child.isFolder() || (baseFilename = child.getName().getBaseName()).startsWith(".")) continue;
            TreeItem childFolderItem = new TreeItem(folderItem, 0);
            childFolderItem.setImage(GuiResource.getInstance().getImageFolder());
            childFolderItem.setText(child.getName().getBaseName());
            childFolderItem.setData("type", (Object)FOLDER);
            childFolderItem.setData(FILE_OBJECT, child);
            this.populateFolder((FileObject)child, childFolderItem);
        }
        for (Object child : children) {
            if (!child.isFile() || (baseFilename = child.getName().getBaseName()).startsWith(".")) continue;
            TreeItem childItem = new TreeItem(folderItem, 0);
            childItem.setImage(GuiResource.getInstance().getImageFile());
            childItem.setText(child.getName().getBaseName());
            childItem.setData("type", (Object)"file");
            childItem.setData(FILE_OBJECT, child);
        }
    }

    void addDependencies(FileObject file, TreeItem rootItem, boolean checked) {
        ArrayList<FileObject> dependencies = new ArrayList<FileObject>();
        if (file.getName().getURI().endsWith(".hwf") || file.getName().getURI().endsWith(".hpl")) {
            dependencies.addAll(this.findDependencies(file.getName().getURI()));
        }
        for (FileObject dependency : dependencies) {
            this.checkItemsByFileObject(rootItem, dependency.getName().getURI(), checked);
        }
        if (checked) {
            this.fileObjects.addAll(dependencies);
        } else {
            dependencies.forEach(this.fileObjects::remove);
        }
    }

    void checkItems(TreeItem rootItem, TreeItem item, boolean checked) {
        TreeItem[] items;
        item.setGrayed(false);
        item.setChecked(checked);
        for (TreeItem treeItem : items = item.getItems()) {
            if (treeItem.getData("type").equals("file")) {
                FileObject fileObject = (FileObject)treeItem.getData(FILE_OBJECT);
                if (this.findDependencies.get() && item != rootItem) {
                    this.addDependencies(fileObject, rootItem, checked);
                }
                if (checked) {
                    this.fileObjects.add(fileObject);
                } else {
                    this.fileObjects.remove(fileObject);
                }
            }
            this.checkItems(rootItem, treeItem, checked);
        }
    }

    void checkGrayedItems(TreeItem parentItem) {
        if (parentItem == null) {
            return;
        }
        TreeItem[] items = parentItem.getItems();
        boolean allChecked = true;
        boolean atLeastOneChecked = false;
        for (TreeItem treeItem : items) {
            if (!treeItem.getChecked() || treeItem.getChecked() && treeItem.getGrayed()) {
                allChecked = false;
            }
            atLeastOneChecked = treeItem.getChecked() || atLeastOneChecked;
        }
        if (allChecked) {
            parentItem.setGrayed(false);
            parentItem.setChecked(atLeastOneChecked);
        } else {
            parentItem.setGrayed(true);
            parentItem.setChecked(atLeastOneChecked);
        }
        this.checkGrayedItems(parentItem.getParentItem());
    }

    public List<FileObject> findDependencies(String filePath) {
        ArrayList<FileObject> dependencies = new ArrayList<FileObject>();
        ArrayList<HopMetadataPropertyType> properties = new ArrayList<HopMetadataPropertyType>(Arrays.asList(HopMetadataPropertyType.PIPELINE_FILE, HopMetadataPropertyType.WORKFLOW_FILE, HopMetadataPropertyType.HOP_FILE));
        try {
            HopGui hopGui = HopGui.getInstance();
            if (filePath.endsWith("hpl")) {
                PipelineMeta pipelineMeta = new PipelineMeta(filePath, (IHopMetadataProvider)hopGui.getMetadataProvider(), hopGui.getVariables());
                List transformMetasMetas = pipelineMeta.getTransforms();
                for (TransformMeta transformMeta : transformMetasMetas) {
                    List<Field> fields = FileTree.getAllFields(new LinkedList<Field>(), transformMeta.getTransform().getClass());
                    fields.removeIf(field -> !field.isAnnotationPresent(HopMetadataProperty.class) || !properties.contains(field.getAnnotation(HopMetadataProperty.class).hopMetadataPropertyType()));
                    for (Field field2 : fields) {
                        FileObject fileObject;
                        String fileFound = hopGui.getVariables().resolve((String)ReflectionUtil.getFieldValue((Object)transformMeta.getTransform(), (String)field2.getName(), (boolean)false));
                        if (fileFound == null || fileFound.equals(filePath) || !(fileObject = HopVfs.getFileObject((String)fileFound)).exists() || dependencies.contains(fileObject)) continue;
                        dependencies.add(fileObject);
                        dependencies.addAll(this.findDependencies(fileObject.getName().getURI()));
                    }
                }
            } else {
                WorkflowMeta workflowMeta = new WorkflowMeta(hopGui.getVariables(), filePath, (IHopMetadataProvider)hopGui.getMetadataProvider());
                List actionMetas = workflowMeta.getActions();
                for (ActionMeta actionMeta : actionMetas) {
                    List<Field> fields = FileTree.getAllFields(new LinkedList<Field>(), actionMeta.getAction().getClass());
                    fields.removeIf(field -> !field.isAnnotationPresent(HopMetadataProperty.class) || !properties.contains(field.getAnnotation(HopMetadataProperty.class).hopMetadataPropertyType()));
                    for (Field field3 : fields) {
                        FileObject fileObject;
                        String fileFound = hopGui.getVariables().resolve((String)ReflectionUtil.getFieldValue((Object)actionMeta.getAction(), (String)field3.getName(), (boolean)false));
                        if (fileFound == null || fileFound.equals(filePath) || !(fileObject = HopVfs.getFileObject((String)fileFound)).exists() || dependencies.contains(fileObject)) continue;
                        dependencies.add(fileObject);
                        dependencies.addAll(this.findDependencies(fileObject.getName().getURI()));
                    }
                }
            }
        }
        catch (FileSystemException | HopException e) {
            return dependencies;
        }
        return dependencies;
    }

    void checkItemsByFileObject(TreeItem rootItem, String file, boolean checked) {
        TreeItem[] children;
        for (TreeItem treeItem : children = rootItem.getItems()) {
            if (treeItem.getData("type").equals(FOLDER)) {
                this.checkItemsByFileObject(treeItem, file, checked);
            }
            if (!treeItem.getData("type").equals("file") || !((FileObject)treeItem.getData(FILE_OBJECT)).getName().getURI().equals(file)) continue;
            treeItem.setGrayed(false);
            treeItem.setChecked(checked);
            this.checkGrayedItems(treeItem.getParentItem());
        }
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            FileTree.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    @Generated
    public Set<FileObject> getFileObjects() {
        return this.fileObjects;
    }
}

