/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.pipeline.transforms.mailinput;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mail.pipeline.transforms.mailinput.MailInput;
import org.apache.hop.mail.pipeline.transforms.mailinput.MailInputData;
import org.apache.hop.mail.pipeline.transforms.mailinput.MailInputField;
import org.apache.hop.mail.workflow.actions.getpop.MailConnectionMeta;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="MailInput", image="mailinput.svg", name="i18n::MailInput.Name", description="i18n::MailInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::MailInputMeta.keyword"}, documentationUrl="/pipeline/transforms/emailinput.html")
public class MailInputMeta
extends BaseTransformMeta<MailInput, MailInputData> {
    private static final Class<?> PKG = MailInputMeta.class;
    private static final String CONST_SPACE = "      ";
    private static final String CONST_FIELD = "field";
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final int DEFAULT_BATCH_SIZE = 500;
    private String conditionReceivedDateStr;
    @HopMetadataProperty(key="conditionreceiveddate")
    public int conditionReceivedDate;
    public Map<String, String> valueImaps = new HashMap<String, String>(){
        {
            this.put("imaplistall", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetAll.Label", (String[])new String[0]));
            this.put("imaplistnew", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetNew.Label", (String[])new String[0]));
            this.put("imaplistold", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetOld.Label", (String[])new String[0]));
            this.put("imaplistread", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetRead.Label", (String[])new String[0]));
            this.put("imaplistunread", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetUnread.Label", (String[])new String[0]));
            this.put("imaplistflagged", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetFlagged.Label", (String[])new String[0]));
            this.put("imaplistnotflagged", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetNotFlagged.Label", (String[])new String[0]));
            this.put("imaplistdraft", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetDraft.Label", (String[])new String[0]));
            this.put("imaplistnotdraft", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetNotDraft.Label", (String[])new String[0]));
            this.put("imaplistanswered", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetAnswered.Label", (String[])new String[0]));
            this.put("imaplistnotanswered", BaseMessages.getString(PKG, (String)"ActionGetPOP.IMAPListGetNotAnswered.Label", (String[])new String[0]));
        }
    };
    private int valueImapList;
    @HopMetadataProperty(key="valueimaplist")
    private String valueImap;
    @HopMetadataProperty(key="servername")
    private String serverName;
    @HopMetadataProperty(key="username")
    private String username;
    @HopMetadataProperty(password=true)
    private String password;
    @HopMetadataProperty(key="usessl")
    private boolean useSsl;
    @HopMetadataProperty(key="usexoauth2")
    private boolean useXOAuth2;
    @HopMetadataProperty(key="sslport")
    private String sslPort;
    @HopMetadataProperty(key="firstmails")
    private String firstMails;
    @HopMetadataProperty(key="retrievemails")
    public int retrieveMails;
    @HopMetadataProperty
    private boolean delete;
    @HopMetadataProperty
    private String protocol;
    @HopMetadataProperty(key="imapfirstmails")
    private String imapFirstMails;
    @HopMetadataProperty(key="imapfolder")
    private String imapFolder;
    @HopMetadataProperty
    private String senderSearch;
    @HopMetadataProperty
    private boolean notTermSenderSearch;
    @HopMetadataProperty
    private String recipientSearch;
    @HopMetadataProperty
    private String subjectSearch;
    @HopMetadataProperty
    private String receivedDate1;
    @HopMetadataProperty
    private String receivedDate2;
    @HopMetadataProperty
    private boolean notTermSubjectSearch;
    @HopMetadataProperty
    private boolean notTermRecipientSearch;
    @HopMetadataProperty
    private boolean notTermReceivedDateSearch;
    @HopMetadataProperty(key="includesubfolders")
    private boolean includeSubFolders;
    @HopMetadataProperty(key="useproxy")
    private boolean useProxy;
    @HopMetadataProperty(key="proxyusername")
    private String proxyUsername;
    @HopMetadataProperty(key="folderfield")
    private String folderField;
    @HopMetadataProperty(key="usedynamicfolder")
    private boolean useDynamicFolder;
    @HopMetadataProperty(key="rowlimit")
    private String rowLimit;
    @HopMetadataProperty(key="connection_name")
    private String connectionName;
    @HopMetadataProperty(key="field", groupKey="fields")
    private List<MailInputField> inputFields;
    @HopMetadataProperty(key="USE_BATCH")
    private boolean useBatch;
    @HopMetadataProperty(key="startMsg")
    private String start;
    @HopMetadataProperty(key="endMsg")
    private String end;
    @HopMetadataProperty(key="BATCH_SIZE")
    private Integer batchSize = 500;
    @HopMetadataProperty
    private boolean stopOnError;

    public Object clone() {
        MailInputMeta retval = (MailInputMeta)((Object)super.clone());
        int nrFields = this.inputFields.size();
        ArrayList<MailInputField> retvalFields = new ArrayList<MailInputField>();
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields.get(i) == null) continue;
            retvalFields.add((MailInputField)this.inputFields.get(i).clone());
        }
        retval.setInputFields(retvalFields);
        return retval;
    }

    public void setDefault() {
        this.serverName = null;
        this.username = null;
        this.password = null;
        this.useSsl = false;
        this.useXOAuth2 = false;
        this.sslPort = null;
        this.retrieveMails = 0;
        this.firstMails = null;
        this.delete = false;
        this.protocol = "POP3";
        this.imapFirstMails = "0";
        this.valueImapList = 0;
        this.imapFolder = null;
        this.senderSearch = null;
        this.notTermSenderSearch = false;
        this.notTermRecipientSearch = false;
        this.notTermSubjectSearch = false;
        this.receivedDate1 = null;
        this.receivedDate2 = null;
        this.notTermReceivedDateSearch = false;
        this.recipientSearch = null;
        this.subjectSearch = null;
        this.includeSubFolders = false;
        this.useProxy = false;
        this.proxyUsername = null;
        this.folderField = null;
        this.useDynamicFolder = false;
        this.rowLimit = "0";
        this.batchSize = 500;
        this.useBatch = false;
        this.start = null;
        this.end = null;
        this.stopOnError = true;
        boolean nrFields = false;
        this.inputFields = new ArrayList<MailInputField>();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MailInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MailInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.inputFields.size(); ++i) {
            MailInputField field = this.inputFields.get(i);
            ValueMetaString v = new ValueMetaString(variables.resolve(field.getName()));
            switch (field.getColumn()) {
                case 0: 
                case 11: 
                case 17: {
                    v = new ValueMetaInteger(variables.resolve(field.getName()));
                    v.setLength(10, 0);
                    break;
                }
                case 7: 
                case 8: {
                    v = new ValueMetaDate(variables.resolve(field.getName()));
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    v = new ValueMetaBoolean(variables.resolve(field.getName()));
                    break;
                }
                default: {
                    v.setLength(250);
                    v.setPrecision(-1);
                }
            }
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public void setValueImapList(int valueImapList) {
        this.valueImapList = valueImapList;
        this.valueImap = MailConnectionMeta.getValueImapListDesc(valueImapList);
    }

    public String getValueImap() {
        return MailConnectionMeta.getValueImapListCode(this.valueImapList);
    }

    public int getConditionReceivedDate() {
        return MailConnectionMeta.getConditionDateByDesc(this.conditionReceivedDateStr);
    }

    @Generated
    public String getConditionReceivedDateStr() {
        return this.conditionReceivedDateStr;
    }

    @Generated
    public Map<String, String> getValueImaps() {
        return this.valueImaps;
    }

    @Generated
    public int getValueImapList() {
        return this.valueImapList;
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public boolean isUseSsl() {
        return this.useSsl;
    }

    @Generated
    public boolean isUseXOAuth2() {
        return this.useXOAuth2;
    }

    @Generated
    public String getSslPort() {
        return this.sslPort;
    }

    @Generated
    public String getFirstMails() {
        return this.firstMails;
    }

    @Generated
    public int getRetrieveMails() {
        return this.retrieveMails;
    }

    @Generated
    public boolean isDelete() {
        return this.delete;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getImapFirstMails() {
        return this.imapFirstMails;
    }

    @Generated
    public String getImapFolder() {
        return this.imapFolder;
    }

    @Generated
    public String getSenderSearch() {
        return this.senderSearch;
    }

    @Generated
    public boolean isNotTermSenderSearch() {
        return this.notTermSenderSearch;
    }

    @Generated
    public String getRecipientSearch() {
        return this.recipientSearch;
    }

    @Generated
    public String getSubjectSearch() {
        return this.subjectSearch;
    }

    @Generated
    public String getReceivedDate1() {
        return this.receivedDate1;
    }

    @Generated
    public String getReceivedDate2() {
        return this.receivedDate2;
    }

    @Generated
    public boolean isNotTermSubjectSearch() {
        return this.notTermSubjectSearch;
    }

    @Generated
    public boolean isNotTermRecipientSearch() {
        return this.notTermRecipientSearch;
    }

    @Generated
    public boolean isNotTermReceivedDateSearch() {
        return this.notTermReceivedDateSearch;
    }

    @Generated
    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    @Generated
    public boolean isUseProxy() {
        return this.useProxy;
    }

    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Generated
    public String getFolderField() {
        return this.folderField;
    }

    @Generated
    public boolean isUseDynamicFolder() {
        return this.useDynamicFolder;
    }

    @Generated
    public String getRowLimit() {
        return this.rowLimit;
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public List<MailInputField> getInputFields() {
        return this.inputFields;
    }

    @Generated
    public boolean isUseBatch() {
        return this.useBatch;
    }

    @Generated
    public String getStart() {
        return this.start;
    }

    @Generated
    public String getEnd() {
        return this.end;
    }

    @Generated
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public boolean isStopOnError() {
        return this.stopOnError;
    }

    @Generated
    public void setConditionReceivedDateStr(String conditionReceivedDateStr) {
        this.conditionReceivedDateStr = conditionReceivedDateStr;
    }

    @Generated
    public void setConditionReceivedDate(int conditionReceivedDate) {
        this.conditionReceivedDate = conditionReceivedDate;
    }

    @Generated
    public void setValueImaps(Map<String, String> valueImaps) {
        this.valueImaps = valueImaps;
    }

    @Generated
    public void setValueImap(String valueImap) {
        this.valueImap = valueImap;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    @Generated
    public void setUseXOAuth2(boolean useXOAuth2) {
        this.useXOAuth2 = useXOAuth2;
    }

    @Generated
    public void setSslPort(String sslPort) {
        this.sslPort = sslPort;
    }

    @Generated
    public void setFirstMails(String firstMails) {
        this.firstMails = firstMails;
    }

    @Generated
    public void setRetrieveMails(int retrieveMails) {
        this.retrieveMails = retrieveMails;
    }

    @Generated
    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setImapFirstMails(String imapFirstMails) {
        this.imapFirstMails = imapFirstMails;
    }

    @Generated
    public void setImapFolder(String imapFolder) {
        this.imapFolder = imapFolder;
    }

    @Generated
    public void setSenderSearch(String senderSearch) {
        this.senderSearch = senderSearch;
    }

    @Generated
    public void setNotTermSenderSearch(boolean notTermSenderSearch) {
        this.notTermSenderSearch = notTermSenderSearch;
    }

    @Generated
    public void setRecipientSearch(String recipientSearch) {
        this.recipientSearch = recipientSearch;
    }

    @Generated
    public void setSubjectSearch(String subjectSearch) {
        this.subjectSearch = subjectSearch;
    }

    @Generated
    public void setReceivedDate1(String receivedDate1) {
        this.receivedDate1 = receivedDate1;
    }

    @Generated
    public void setReceivedDate2(String receivedDate2) {
        this.receivedDate2 = receivedDate2;
    }

    @Generated
    public void setNotTermSubjectSearch(boolean notTermSubjectSearch) {
        this.notTermSubjectSearch = notTermSubjectSearch;
    }

    @Generated
    public void setNotTermRecipientSearch(boolean notTermRecipientSearch) {
        this.notTermRecipientSearch = notTermRecipientSearch;
    }

    @Generated
    public void setNotTermReceivedDateSearch(boolean notTermReceivedDateSearch) {
        this.notTermReceivedDateSearch = notTermReceivedDateSearch;
    }

    @Generated
    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    @Generated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @Generated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Generated
    public void setFolderField(String folderField) {
        this.folderField = folderField;
    }

    @Generated
    public void setUseDynamicFolder(boolean useDynamicFolder) {
        this.useDynamicFolder = useDynamicFolder;
    }

    @Generated
    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Generated
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    @Generated
    public void setInputFields(List<MailInputField> inputFields) {
        this.inputFields = inputFields;
    }

    @Generated
    public void setUseBatch(boolean useBatch) {
        this.useBatch = useBatch;
    }

    @Generated
    public void setStart(String start) {
        this.start = start;
    }

    @Generated
    public void setEnd(String end) {
        this.end = end;
    }

    @Generated
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    private static final class Tags {
        static final String USE_BATCH = "useBatch";
        static final String BATCH_SIZE = "batchSize";
        static final String START_MSG = "startMsg";
        static final String END_MSG = "endMsg";
        static final String STOP_ON_ERROR = "stopOnError";

        private Tags() {
        }
    }
}

