/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.sun.mail.imap.IMAPSSLStore;
import com.sun.mail.pop3.POP3SSLStore;
import jakarta.mail.BodyPart;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.URLName;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.search.AndTerm;
import jakarta.mail.search.BodyTerm;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.FromStringTerm;
import jakarta.mail.search.NotTerm;
import jakarta.mail.search.ReceivedDateTerm;
import jakarta.mail.search.RecipientStringTerm;
import jakarta.mail.search.SearchTerm;
import jakarta.mail.search.SubjectTerm;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="MailServerConnection", name="i18n::MailServerConnection.name", description="i18n::MailServerConnection.description", image="mail.svg", documentationUrl="", hopMetadataPropertyType=HopMetadataPropertyType.MAIL_SERVER_CONNECTION)
public class MailServerConnection
extends HopMetadataBase
implements IHopMetadata {
    private static final Class<?> PKG = MailServerConnection.class;
    public static final String FOLDER_SEPARATOR = "/";
    public static final int PROTOCOL_POP3 = 0;
    public static final int PROTOCOL_IMAP = 1;
    public static final int PROTOCOL_MBOX = 2;
    public static final String INBOX_FOLDER = "INBOX";
    public static final String PROTOCOL_STRING_IMAP = "IMAP";
    public static final String PROTOCOL_STRING_POP3 = "POP3";
    public static final String[] protocolCodes = new String[]{"POP3", "IMAP", "MBOX"};
    public static final String PROTOCOL_STRING_MBOX = protocolCodes[2];
    public static final int DEFAULT_IMAP_PORT = 110;
    public static final int DEFAULT_POP3_PORT = 110;
    public static final int DEFAULT_SSL_POP3_PORT = 995;
    public static final int DEFAULT_SSL_IMAP_PORT = 993;
    public static final String CONST_MAIL = "mail.";
    private static final String CONST_POP3_UNSUPPORTED = "MailConnection.Error.ReceivedDatePOP3Unsupported";
    public static final String[] conditionDateCode = new String[]{"ignore", "equal", "smaller", "greater", "between"};
    public static final int CONDITION_DATE_IGNORE = 0;
    public static final int CONDITION_DATE_EQUAL = 1;
    public static final int CONDITION_DATE_SMALLER = 2;
    public static final int CONDITION_DATE_GREATER = 3;
    public static final int CONDITION_DATE_BETWEEN = 4;
    public static final String[] actionTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionGetPOP.ActionType.GetMessages.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionGetPOP.ActionType.MoveMessages.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionGetPOP.ActionType.DeleteMessages.Label", (String[])new String[0])};
    public static final String[] actionTypeCode = new String[]{"get", "move", "delete"};
    public static final int ACTION_TYPE_GET = 0;
    public static final int ACTION_TYPE_MOVE = 1;
    public static final int ACTION_TYPE_DELETE = 2;
    public static final String[] valueIMAPListCode = new String[]{"imaplistall", "imaplistnew", "imaplistold", "imaplistread", "imaplistunread", "imaplistflagged", "imaplistnotflagged", "imaplistdraft", "imaplistnotdraft", "imaplistanswered", "imaplistnotanswered"};
    public static final int VALUE_IMAP_LIST_ALL = 0;
    public static final int VALUE_IMAP_LIST_NEW = 1;
    public static final int VALUE_IMAP_LIST_OLD = 2;
    public static final int VALUE_IMAP_LIST_READ = 3;
    public static final int VALUE_IMAP_LIST_UNREAD = 4;
    public static final int VALUE_IMAP_LIST_FLAGGED = 5;
    public static final int VALUE_IMAP_LIST_NOT_FLAGGED = 6;
    public static final int VALUE_IMAP_LIST_DRAFT = 7;
    public static final int VALUE_IMAP_LIST_NOT_DRAFT = 8;
    public static final int VALUE_IMAP_LIST_ANWERED = 9;
    public static final int VALUE_IMAP_LIST_NOT_ANSWERED = 10;
    public static final String[] afterGetIMAPDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionGetPOP.afterGetIMAP.Nothing.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionGetPOP.afterGetIMAP.Delete.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionGetPOP.afterGetIMAP.MoveTo.Label", (String[])new String[0])};
    public static final String[] afterGetIMAPCode = new String[]{"nothing", "delete", "move"};
    public static final int AFTER_GET_IMAP_NOTHING = 0;
    public static final int AFTER_GET_IMAP_DELETE = 1;
    public static final int AFTER_GET_IMAP_MOVE = 2;
    private Session session;
    private IVariables variables;
    private Properties props;
    private Store store;
    private Folder folder = null;
    private int nrSavedMessages = 0;
    private int nrMovedMessages = 0;
    private int nrDeletedMessages = 0;
    private int nrSavedAttachedFiles = 0;
    private int messagenr = -1;
    private Message[] messages;
    private Message message;
    private SearchTerm searchTerm = null;
    @HopMetadataProperty
    private String protocol;
    @HopMetadataProperty
    private String serverHost;
    @HopMetadataProperty
    private String serverPort;
    @HopMetadataProperty
    private boolean useAuthentication;
    @HopMetadataProperty
    private String username;
    @HopMetadataProperty(password=true)
    private String password;
    @HopMetadataProperty
    private boolean useXOAuth2;
    @HopMetadataProperty
    private boolean useSecureAuthentication;
    @HopMetadataProperty
    private String secureConnectionType;
    @HopMetadataProperty
    private boolean useProxy;
    @HopMetadataProperty
    private String proxyHost;
    @HopMetadataProperty
    private String proxyUsername;
    @HopMetadataProperty
    private String trustedHosts;
    @HopMetadataProperty
    private boolean checkServerIdentity;
    private Folder destinationIMAPFolder = null;

    public MailServerConnection() {
        this.props = new Properties();
    }

    public MailServerConnection(IVariables variables) {
        this();
        this.variables = variables;
    }

    public Session getSession(IVariables variables) {
        this.variables = variables;
        if (this.protocol.equals("SMTP")) {
            this.protocol = "smtp";
            if (this.useSecureAuthentication) {
                if (this.useXOAuth2) {
                    this.props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                }
                if (this.secureConnectionType.equals("TLS")) {
                    this.props.put("mail.smtp.starttls.enable", "true");
                } else if (this.secureConnectionType.equals("TLS 1.2")) {
                    this.props.put("mail.smtp.starttls.enable", "true");
                    this.props.put("mail.smtp.ssl.protocols", "TLSv1.2");
                } else {
                    this.protocol = "smtps";
                    this.props.put("mail.smtps.quitwait", "false");
                }
                this.props.put("mail.smtp.ssl.checkServerIdentity", (Object)this.isCheckServerIdentity());
                if (!Utils.isEmpty((CharSequence)this.trustedHosts)) {
                    this.props.put("mail.smtp.ssl.trust", variables.resolve(this.trustedHosts));
                }
            }
            this.props.put(CONST_MAIL + this.protocol.toLowerCase() + ".host", variables.resolve(this.serverHost));
            if (!Utils.isEmpty((CharSequence)this.serverPort)) {
                this.props.put(CONST_MAIL + this.protocol.toLowerCase() + ".port", variables.resolve(this.serverPort));
            }
            if (this.useAuthentication) {
                this.props.put(CONST_MAIL + this.protocol + ".auth", "true");
            }
        } else {
            String protocolString = "";
            if (this.isUseProxy()) {
                this.props.put("mail.imap.sasl.enable", "true");
                this.props.put("mail.imap.sasl.authorizationid", this.proxyUsername);
            }
            if (this.protocol.equals(PROTOCOL_STRING_POP3)) {
                this.props.setProperty("mail.pop3s.rsetbeforequit", "true");
                this.props.setProperty("mail.pop3.rsetbeforequit", "true");
            } else if (this.protocol.equals("MBOX")) {
                this.props.setProperty("mstor.mbox.metadataStrategy", "none");
                this.props.setProperty("mstor.cache.disabled", "true");
            }
            String string = this.protocol.equals(PROTOCOL_STRING_POP3) ? "pop3" : (protocolString = this.protocol.equals("MBOX") ? "mstor" : "imap");
            if (this.useSecureAuthentication && !this.protocol.equals("MBOX")) {
                this.props.setProperty(CONST_MAIL + protocolString + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                this.props.setProperty(CONST_MAIL + protocolString + ".socketFactory.fallback", "false");
                this.props.setProperty(CONST_MAIL + protocolString + ".port", variables.resolve(this.serverPort));
                this.props.setProperty(CONST_MAIL + protocolString + ".socketFactory.port", variables.resolve(this.serverPort));
                if (this.useXOAuth2) {
                    this.props.setProperty(CONST_MAIL + protocolString + ".ssl.enable", "true");
                    this.props.setProperty(CONST_MAIL + protocolString + ".auth.mechanisms", "XOAUTH2");
                }
            }
        }
        this.session = Session.getInstance((Properties)this.props, null);
        return this.session;
    }

    public Transport getTransport() throws MessagingException {
        Transport transport = this.session.getTransport(this.protocol);
        String authPass = this.getPassword(this.password);
        if (this.useAuthentication) {
            if (!Utils.isEmpty((CharSequence)this.serverPort)) {
                transport.connect(this.variables.resolve(Const.NVL((String)this.serverHost, (String)"")), Integer.parseInt(this.variables.resolve(Const.NVL((String)this.serverPort, (String)""))), this.variables.resolve(Const.NVL((String)this.username, (String)"")), authPass);
            } else {
                transport.connect(this.variables.resolve(Const.NVL((String)this.serverHost, (String)"")), this.variables.resolve(Const.NVL((String)this.username, (String)"")), authPass);
            }
        } else {
            transport.connect();
        }
        return transport;
    }

    public Store getStore() throws MessagingException {
        if (this.useSecureAuthentication && !this.protocol.equals("MBOX")) {
            URLName url = new URLName(this.protocol, this.variables.resolve(this.serverHost), Integer.valueOf(this.variables.resolve(this.serverPort)).intValue(), "", this.variables.resolve(this.username), this.variables.resolve(this.password));
            switch (this.protocol) {
                case "POP3": {
                    this.store = new POP3SSLStore(this.session, url);
                    break;
                }
                case "IMAP": {
                    this.store = new IMAPSSLStore(this.session, url);
                }
            }
        } else {
            this.store = this.protocol.equals("MBOX") ? this.session.getStore(new URLName(this.protocol + ":" + this.serverHost)) : this.session.getStore(this.protocol);
        }
        return this.store;
    }

    public MailServerConnection(MailServerConnection connection) {
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MailServerConnection)) {
            return false;
        }
        MailServerConnection connection = (MailServerConnection)((Object)object);
        return this.name != null && this.name.equalsIgnoreCase(connection.name);
    }

    public void connect() throws HopException, NoSuchProviderException {
        try {
            if (this.useSecureAuthentication || this.protocol.equals("MBOX")) {
                this.store.connect();
            } else if (Integer.valueOf(this.variables.resolve(this.serverPort)) > -1) {
                this.store.connect(this.variables.resolve(this.serverHost), Integer.valueOf(this.variables.resolve(this.serverPort)).intValue(), this.variables.resolve(this.username), this.variables.resolve(this.password));
            } else {
                this.store.connect(this.variables.resolve(this.serverHost), this.variables.resolve(this.username), this.variables.resolve(this.password));
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.Connecting", (String[])new String[]{this.serverHost, this.username, Const.NVL((String)this.serverPort, (String)"")}), (Throwable)e);
        }
    }

    public boolean testConnection(Session session) {
        try {
            this.session = session;
            Store theStore = this.getStore();
            theStore.connect();
            return true;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPassword(String authPassword) {
        return Encr.decryptPasswordOptionallyEncrypted((String)this.variables.resolve(Const.NVL((String)authPassword, (String)"")));
    }

    public void setDestinationFolder(String folderName, boolean createFolder) throws HopException {
        try {
            String[] folderparts = folderName.split(FOLDER_SEPARATOR);
            if (!this.store.isConnected()) {
                this.store.connect();
            }
            Folder f = this.store.getDefaultFolder();
            for (int i = 0; i < folderparts.length; ++i) {
                if ((f = f.getFolder(folderparts[i])).exists()) continue;
                if (createFolder) {
                    f.create(1);
                    continue;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.FolderNotFound", (String[])new String[]{folderName}));
            }
            this.destinationIMAPFolder = f;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public void setSenderTerm(String sender, boolean notTerm) {
        if (!Utils.isEmpty((CharSequence)sender)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new FromStringTerm(sender)));
            } else {
                this.addSearchTerm((SearchTerm)new FromStringTerm(sender));
            }
        }
    }

    private void addSearchTerm(SearchTerm term) {
        this.searchTerm = this.searchTerm != null ? new AndTerm(this.searchTerm, term) : term;
    }

    public void setReceipientTerm(String receipient) {
        if (!Utils.isEmpty((CharSequence)receipient)) {
            this.addSearchTerm((SearchTerm)new RecipientStringTerm(Message.RecipientType.TO, receipient));
        }
    }

    public void setSubjectTerm(String subject, boolean notTerm) {
        if (!Utils.isEmpty((CharSequence)subject)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new SubjectTerm(subject)));
            } else {
                this.addSearchTerm((SearchTerm)new SubjectTerm(subject));
            }
        }
    }

    public void setBodyTerm(String bodyfilter, boolean notTerm) {
        if (!Utils.isEmpty((CharSequence)bodyfilter)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new BodyTerm(bodyfilter)));
            } else {
                this.addSearchTerm((SearchTerm)new BodyTerm(bodyfilter));
            }
        }
    }

    public void setReceivedDateTermEQ(Date receiveddate) {
        if (!this.protocol.equals(PROTOCOL_STRING_POP3)) {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(3, receiveddate));
        }
    }

    public void setReceivedDateTermLT(Date futureDate) {
        if (!this.protocol.equals(PROTOCOL_STRING_POP3)) {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(2, futureDate));
        }
    }

    public void setReceivedDateTermGT(Date pastDate) {
        if (!this.protocol.equals(PROTOCOL_STRING_POP3)) {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(5, pastDate));
        }
    }

    public void setReceivedDateTermBetween(Date beginDate, Date endDate) {
        if (!this.protocol.equals(PROTOCOL_STRING_POP3)) {
            this.addSearchTerm((SearchTerm)new AndTerm((SearchTerm)new ReceivedDateTerm(2, endDate), (SearchTerm)new ReceivedDateTerm(5, beginDate)));
        }
    }

    public void setFlagTermNew() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.RECENT), true));
    }

    public void setFlagTermOld() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.RECENT), false));
    }

    public void setFlagTermRead() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), true));
    }

    public void setFlagTermUnread() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
    }

    public void setFlagTermFlagged() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), true));
    }

    public void setFlagTermNotFlagged() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), false));
    }

    public void setFlagTermDraft() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DRAFT), true));
    }

    public void setFlagTermNotDraft() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DRAFT), false));
    }

    private HashSet<String> returnSubfolders(Folder folder) throws HopException {
        HashSet<String> list = new HashSet<String>();
        try {
            if ((folder.getType() & 2) != 0) {
                Folder[] f = folder.list();
                for (int i = 0; i < f.length; ++i) {
                    if ((f[i].getType() & 2) == 0) continue;
                    list.add(f[i].getFullName());
                    list.addAll(this.returnSubfolders(f[i]));
                }
            }
        }
        catch (MessagingException m) {
            throw new HopException((Throwable)m);
        }
        return list;
    }

    public String[] returnAllFolders(Folder folder) throws HopException {
        HashSet<Object> list = new HashSet();
        list = this.returnSubfolders(folder);
        return list.toArray(new String[list.size()]);
    }

    public String[] returnAllFolders() throws HopException {
        return this.returnAllFolders(this.getFolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] returnAllFolders(String folder) throws HopException {
        Folder dfolder = null;
        String[] retval = null;
        try {
            dfolder = Utils.isEmpty((CharSequence)folder) ? this.getStore().getDefaultFolder() : this.getStore().getFolder(folder);
            retval = this.returnAllFolders(dfolder);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (dfolder != null) {
                    dfolder.close(false);
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public int getSavedAttachedFilesCounter() {
        return this.nrSavedAttachedFiles;
    }

    public void updateSavedAttachedFilesCounter() {
        ++this.nrSavedAttachedFiles;
    }

    public int getSavedMessagesCounter() {
        return this.nrSavedMessages;
    }

    public int getDeletedMessagesCounter() {
        return this.nrDeletedMessages;
    }

    public int getMovedMessagesCounter() {
        return this.nrMovedMessages;
    }

    private void updateMessageNr() {
        ++this.messagenr;
    }

    private int getMessageNr() {
        return this.messagenr;
    }

    private void updateDeletedMessagesCounter() {
        ++this.nrDeletedMessages;
    }

    private void setDeletedMessagesCounter() {
        this.nrDeletedMessages = this.getMessagesCount();
    }

    private void updatedMovedMessagesCounter() {
        ++this.nrMovedMessages;
    }

    private void setMovedMessagesCounter() {
        this.nrMovedMessages = this.getMessagesCount();
    }

    public void updateSavedMessagesCounter() {
        ++this.nrSavedMessages;
    }

    public void disconnect(boolean expunge) throws HopException {
        try {
            this.closeFolder(expunge);
            this.clearFilters();
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
            if (this.session != null) {
                this.session = null;
            }
            if (this.destinationIMAPFolder != null) {
                this.destinationIMAPFolder.close(expunge);
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ClosingConnection", (String[])new String[0]), (Throwable)e);
        }
    }

    public void closeFolder(boolean expunge) throws HopException {
        try {
            if (this.folder != null && this.folder.isOpen()) {
                this.folder.close(expunge);
                this.folder = null;
                this.messages = null;
                this.message = null;
                this.messagenr = -1;
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ClosingFolder", (String[])new String[]{this.getFolderName()}), (Throwable)e);
        }
    }

    public void clearFilters() {
        this.nrSavedMessages = 0;
        this.nrDeletedMessages = 0;
        this.nrMovedMessages = 0;
        this.nrSavedAttachedFiles = 0;
        if (this.searchTerm != null) {
            this.searchTerm = null;
        }
    }

    public void disconnect() throws HopException {
        this.disconnect(true);
    }

    public String getFolderName() {
        if (this.folder == null) {
            return "";
        }
        return this.folder.getName();
    }

    public void openFolder(boolean write) throws HopException {
        this.openFolder(null, true, write);
    }

    public void openFolder(String folderName, boolean write) throws HopException {
        this.openFolder(folderName, false, write);
    }

    public void openFolder(String folderName, boolean defaultFolder, boolean write) throws HopException {
        try {
            if (this.getFolder() != null) {
                this.closeFolder(true);
            }
            if (defaultFolder) {
                this.folder = this.protocol.equals("MBOX") ? this.store.getDefaultFolder() : this.getRecursiveFolder(INBOX_FOLDER);
                if (this.folder == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.InvalidDefaultFolder.Label", (String[])new String[0]));
                }
                if ((this.folder.getType() & 1) == 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.DefaultFolderCanNotHoldMessage", (String[])new String[0]));
                }
            } else {
                if (this.protocol.equals(PROTOCOL_STRING_IMAP) || this.protocol.equals("MBOX")) {
                    this.folder = this.getRecursiveFolder(folderName);
                }
                if (this.folder == null || !this.folder.exists()) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.InvalidFolder.Label", (String[])new String[0]));
                }
            }
            if (write) {
                this.folder.open(2);
            } else {
                this.folder.open(1);
            }
        }
        catch (Exception e) {
            throw new HopException(defaultFolder ? BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.OpeningDefaultFolder", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.OpeningFolder", (String[])new String[]{folderName}), (Throwable)e);
        }
    }

    private Folder getRecursiveFolder(String folderName) throws MessagingException {
        String[] folderparts = folderName.split(FOLDER_SEPARATOR);
        if (!this.store.isConnected()) {
            this.store.connect();
        }
        Folder dfolder = this.store.getDefaultFolder();
        for (int i = 0; i < folderparts.length; ++i) {
            dfolder = dfolder.getFolder(folderparts[i]);
        }
        return dfolder;
    }

    public void retrieveMessages() throws HopException {
        try {
            this.messages = this.searchTerm != null ? this.folder.search(this.searchTerm) : this.folder.getMessages();
        }
        catch (Exception e) {
            this.messages = null;
            throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.RetrieveMessages", (String[])new String[]{this.getFolderName()}), (Throwable)e);
        }
    }

    public int getMessagesCount() {
        return this.messages.length;
    }

    public void fetchNext() throws HopException {
        this.updateMessageNr();
        try {
            this.message = this.messages[this.getMessageNr()];
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.FetchingMessages", (String[])new String[0]), (Throwable)e);
        }
    }

    public void deleteMessage() throws HopException {
        try {
            this.message.setFlag(Flags.Flag.DELETED, true);
            this.updateDeletedMessagesCounter();
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.DeletingMessage", (String[])new String[]{"" + this.getMessage().getMessageNumber()}), (Throwable)e);
        }
    }

    public void deleteMessages(boolean setCounter) throws HopException {
        try {
            this.folder.setFlags(this.messages, new Flags(Flags.Flag.DELETED), true);
            if (setCounter) {
                this.setDeletedMessagesCounter();
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.DeletingMessage", (String[])new String[0]), (Throwable)e);
        }
    }

    public void moveMessage() throws HopException {
        try {
            this.folder.copyMessages(new Message[]{this.message}, this.destinationIMAPFolder);
            this.updatedMovedMessagesCounter();
            this.deleteMessage();
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.MovingMessage", (String[])new String[]{"" + this.getMessage().getMessageNumber(), this.destinationIMAPFolder.getName()}), (Throwable)e);
        }
    }

    public void moveMessages() throws HopException {
        try {
            this.folder.copyMessages(this.messages, this.destinationIMAPFolder);
            this.deleteMessages(false);
            this.setMovedMessagesCounter();
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.MovingMessages", (String[])new String[]{this.destinationIMAPFolder.getName()}), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveMessageContentToFile(String filename, String folderName) throws HopException {
        OutputStream os = null;
        try {
            os = HopVfs.getOutputStream((String)(folderName + (folderName.endsWith(FOLDER_SEPARATOR) ? "" : FOLDER_SEPARATOR) + filename), (boolean)false);
            this.getMessage().writeTo(os);
            this.updateSavedMessagesCounter();
            if (os == null) return;
        }
        catch (Exception e) {
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.SavingMessageContent", (String[])new String[]{"" + this.message.getMessageNumber(), filename, folderName}), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return;
    }

    public void saveAttachedFiles(String folderName, Pattern pattern) throws HopException {
        Object content = null;
        try {
            content = this.getMessage().getContent();
            if (content instanceof Multipart) {
                Multipart multipart = (Multipart)content;
                this.handleMultipart(folderName, multipart, pattern);
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.SavingAttachedFiles", (String[])new String[]{"" + this.message.getMessageNumber(), folderName}), (Throwable)e);
        }
        finally {
            if (content != null) {
                content = null;
            }
        }
    }

    private void handleMultipart(String folderName, Multipart multipart, Pattern pattern) throws HopException {
        try {
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                this.handlePart(folderName, (Part)multipart.getBodyPart(i), pattern);
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    private void handlePart(String folderName, Part part, Pattern pattern) throws HopException {
        block6: {
            try {
                String filename;
                String disposition = part.getDisposition();
                if (disposition == null || disposition.length() < 1) {
                    disposition = "attachment";
                }
                if (!disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) break block6;
                String mimeText = null;
                try {
                    mimeText = MimeUtility.decodeText((String)part.getFileName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mimeText != null && this.isWildcardMatch(filename = MimeUtility.decodeText((String)part.getFileName()), pattern)) {
                    MailServerConnection.saveFile(folderName, filename, part.getInputStream());
                    this.updateSavedAttachedFilesCounter();
                }
            }
            catch (Exception e) {
                throw new HopException((Throwable)e);
            }
        }
    }

    private static void saveFile(String folderName, String filename, InputStream input) throws HopException {
        BufferedOutputStream bos;
        block9: {
            OutputStream fos = null;
            bos = null;
            BufferedInputStream bis = null;
            try {
                Object targetFileName;
                if (filename == null) {
                    File f = File.createTempFile("xx", ".out");
                    f.deleteOnExit();
                    filename = f.getName();
                    targetFileName = folderName + FOLDER_SEPARATOR + filename;
                } else {
                    targetFileName = MailServerConnection.findValidTarget(folderName, filename);
                }
                fos = HopVfs.getOutputStream((String)targetFileName, (boolean)false);
                bos = new BufferedOutputStream(fos);
                bis = new BufferedInputStream(input);
                IOUtils.copy((InputStream)bis, (OutputStream)bos);
                bos.flush();
                if (bis == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw new HopException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        IOUtils.closeQuietly(bis);
                        bis = null;
                    }
                    if (bos != null) {
                        IOUtils.closeQuietly(bos);
                        bos = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)bis);
            bis = null;
        }
        if (bos != null) {
            IOUtils.closeQuietly((OutputStream)bos);
            bos = null;
        }
    }

    private boolean isWildcardMatch(String filename, Pattern pattern) {
        boolean retval = true;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(filename);
            retval = matcher.matches();
        }
        return retval;
    }

    @VisibleForTesting
    static String findValidTarget(String folderName, String fileName) throws HopException {
        if (fileName == null || folderName == null) {
            throw new IllegalArgumentException("Cannot have null arguments to findValidTarget");
        }
        String fileNameRoot = FilenameUtils.getBaseName((String)fileName);
        Object ext = "." + FilenameUtils.getExtension((String)fileName);
        if (((String)ext).length() == 1) {
            ext = "";
        }
        String rtn = "";
        String base = FilenameUtils.concat((String)folderName, (String)fileNameRoot);
        int baseSz = base.length();
        StringBuilder build = new StringBuilder(baseSz).append(base);
        int i = -1;
        do {
            build.setLength(baseSz);
            build.append(++i > 0 ? Integer.toString(i) : "").append((String)ext);
        } while (HopVfs.fileExists((String)(rtn = build.toString())));
        return rtn;
    }

    public String getMessageBody() throws Exception {
        return this.getMessageBody(this.getMessage());
    }

    public String getMessageBody(Message m) throws MessagingException, IOException {
        return this.getMessageBodyOrContentType((Part)m, false);
    }

    public String getMessageBodyContentType(Message m) throws MessagingException, IOException {
        return this.getMessageBodyOrContentType((Part)m, true);
    }

    private String getMessageBodyOrContentType(Part p, boolean returnContentType) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            String s = (String)p.getContent();
            return returnContentType ? p.getContentType() : s;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (!bp.isMimeType("text/plain") || text != null) continue;
                text = this.getMessageBodyOrContentType((Part)bp, returnContentType);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = this.getMessageBodyOrContentType((Part)mp.getBodyPart(i), returnContentType);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    public boolean isMessageDraft(Message msg) {
        try {
            return msg.isSet(Flags.Flag.DRAFT);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageFlagged() {
        return this.isMessageFlagged(this.getMessage());
    }

    public boolean isMessageFlagged(Message msg) {
        try {
            return msg.isSet(Flags.Flag.FLAGGED);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageNew() {
        return this.isMessageNew(this.getMessage());
    }

    public boolean isMessageNew(Message msg) {
        try {
            return msg.isSet(Flags.Flag.RECENT);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageRead() {
        return this.isMessageRead(this.getMessage());
    }

    public boolean isMessageRead(Message msg) {
        try {
            return msg.isSet(Flags.Flag.SEEN);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageDeleted() {
        return this.isMessageDeleted(this.getMessage());
    }

    public boolean isMessageDeleted(Message msg) {
        try {
            return msg.isSet(Flags.Flag.DELETED);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public int getAttachedFilesCount(Pattern pattern) throws HopException {
        return this.getAttachedFilesCount(this.getMessage(), pattern);
    }

    public int getAttachedFilesCount(Message message, Pattern pattern) throws HopException {
        int retval;
        block9: {
            Object content = null;
            retval = 0;
            try {
                content = message.getContent();
                if (!(content instanceof Multipart)) break block9;
                Multipart multipart = (Multipart)content;
                int n = multipart.getCount();
                for (int i = 0; i < n; ++i) {
                    String filename;
                    BodyPart part = multipart.getBodyPart(i);
                    String disposition = part.getDisposition();
                    if (disposition == null || !disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) continue;
                    String mimeText = null;
                    try {
                        mimeText = MimeUtility.decodeText((String)part.getFileName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (mimeText == null || !this.isWildcardMatch(filename = MimeUtility.decodeText((String)part.getFileName()), pattern)) continue;
                    ++retval;
                }
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MailConnection.Error.CountingAttachedFiles", (String[])new String[]{"" + this.message.getMessageNumber()}), (Throwable)e);
            }
            finally {
                if (content != null) {
                    content = null;
                }
            }
        }
        return retval;
    }

    @Generated
    public Session getSession() {
        return this.session;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public Folder getFolder() {
        return this.folder;
    }

    @Generated
    public int getNrSavedMessages() {
        return this.nrSavedMessages;
    }

    @Generated
    public int getNrMovedMessages() {
        return this.nrMovedMessages;
    }

    @Generated
    public int getNrDeletedMessages() {
        return this.nrDeletedMessages;
    }

    @Generated
    public int getNrSavedAttachedFiles() {
        return this.nrSavedAttachedFiles;
    }

    @Generated
    public Message[] getMessages() {
        return this.messages;
    }

    @Generated
    public Message getMessage() {
        return this.message;
    }

    @Generated
    public SearchTerm getSearchTerm() {
        return this.searchTerm;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getServerHost() {
        return this.serverHost;
    }

    @Generated
    public String getServerPort() {
        return this.serverPort;
    }

    @Generated
    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public boolean isUseXOAuth2() {
        return this.useXOAuth2;
    }

    @Generated
    public boolean isUseSecureAuthentication() {
        return this.useSecureAuthentication;
    }

    @Generated
    public String getSecureConnectionType() {
        return this.secureConnectionType;
    }

    @Generated
    public boolean isUseProxy() {
        return this.useProxy;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Generated
    public String getTrustedHosts() {
        return this.trustedHosts;
    }

    @Generated
    public boolean isCheckServerIdentity() {
        return this.checkServerIdentity;
    }

    @Generated
    public Folder getDestinationIMAPFolder() {
        return this.destinationIMAPFolder;
    }

    @Generated
    public void setSession(Session session) {
        this.session = session;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setStore(Store store) {
        this.store = store;
    }

    @Generated
    public void setFolder(Folder folder) {
        this.folder = folder;
    }

    @Generated
    public void setNrSavedMessages(int nrSavedMessages) {
        this.nrSavedMessages = nrSavedMessages;
    }

    @Generated
    public void setNrMovedMessages(int nrMovedMessages) {
        this.nrMovedMessages = nrMovedMessages;
    }

    @Generated
    public void setNrDeletedMessages(int nrDeletedMessages) {
        this.nrDeletedMessages = nrDeletedMessages;
    }

    @Generated
    public void setNrSavedAttachedFiles(int nrSavedAttachedFiles) {
        this.nrSavedAttachedFiles = nrSavedAttachedFiles;
    }

    @Generated
    public void setMessagenr(int messagenr) {
        this.messagenr = messagenr;
    }

    @Generated
    public void setMessages(Message[] messages) {
        this.messages = messages;
    }

    @Generated
    public void setMessage(Message message) {
        this.message = message;
    }

    @Generated
    public void setSearchTerm(SearchTerm searchTerm) {
        this.searchTerm = searchTerm;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    @Generated
    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    @Generated
    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setUseXOAuth2(boolean useXOAuth2) {
        this.useXOAuth2 = useXOAuth2;
    }

    @Generated
    public void setUseSecureAuthentication(boolean useSecureAuthentication) {
        this.useSecureAuthentication = useSecureAuthentication;
    }

    @Generated
    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = secureConnectionType;
    }

    @Generated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Generated
    public void setTrustedHosts(String trustedHosts) {
        this.trustedHosts = trustedHosts;
    }

    @Generated
    public void setCheckServerIdentity(boolean checkServerIdentity) {
        this.checkServerIdentity = checkServerIdentity;
    }

    @Generated
    public void setDestinationIMAPFolder(Folder destinationIMAPFolder) {
        this.destinationIMAPFolder = destinationIMAPFolder;
    }
}

