/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import com.google.auth.Credentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.gs.GoogleStorageFileObject;
import org.apache.hop.vfs.gs.GoogleStorageFileProvider;
import org.apache.hop.vfs.gs.GoogleStorageFileSystemConfigBuilder;

public class GoogleStorageFileSystem
extends AbstractFileSystem {
    Storage storage = null;
    FileSystemOptions fileSystemOptions;

    protected GoogleStorageFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
        this.fileSystemOptions = fileSystemOptions;
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new GoogleStorageFileObject(GoogleStorageFileSystemConfigBuilder.getInstance().getSchema(this.fileSystemOptions), name, this);
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(GoogleStorageFileProvider.capabilities);
    }

    Storage setupStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        StorageOptions.Builder optionsBuilder = StorageOptions.newBuilder();
        optionsBuilder.setCredentials((Credentials)GoogleStorageFileSystemConfigBuilder.getInstance().getGoogleCredentials(this.fileSystemOptions));
        this.storage = (Storage)optionsBuilder.build().getService();
        return this.storage;
    }

    String getBucketName(FileName name) {
        String path = name.getPath();
        int idx = path.indexOf(47, 1);
        if (idx > -1) {
            return name.getPath().substring(1, idx);
        }
        return name.getPath().substring(1);
    }

    String getBucketPath(FileName name) {
        int idx = name.getPath().indexOf(47, 1);
        if (idx > -1) {
            return name.getPath().substring(idx + 1);
        }
        return "";
    }
}

