/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

import org.monetdb.mcl.net.ValidationError;

public enum ParameterType {
    Str,
    Int,
    Bool,
    Path;


    public static boolean parseBool(String string) {
        boolean bl = false;
        String string2 = string;
        while (true) {
            switch (string) {
                case "true": 
                case "yes": 
                case "on": {
                    return true;
                }
                case "false": 
                case "no": 
                case "off": {
                    return false;
                }
            }
            if (bl) break;
            string = string.toLowerCase();
            bl = true;
        }
        throw new IllegalArgumentException("invalid boolean value: " + string2);
    }

    public Object parse(String string, String string2) throws ValidationError {
        if (string2 == null) {
            return null;
        }
        try {
            switch (this.ordinal()) {
                case 2: {
                    return ParameterType.parseBool(string2);
                }
                case 1: {
                    return Integer.parseInt(string2);
                }
                case 0: 
                case 3: {
                    return string2;
                }
            }
            throw new IllegalStateException("unreachable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string3 = illegalArgumentException.toString();
            throw new ValidationError(string, string3);
        }
    }

    public String format(Object object) {
        switch (this.ordinal()) {
            case 2: {
                return (Boolean)object != false ? "true" : "false";
            }
            case 1: {
                return Integer.toString((Integer)object);
            }
            case 0: 
            case 3: {
                return (String)object;
            }
        }
        throw new IllegalStateException("unreachable");
    }
}

