/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.randomvalue;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Uuid4Util;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueData;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueMeta;

public class RandomValue
extends BaseTransform<RandomValueMeta, RandomValueData> {
    private static final Class<?> PKG = RandomValueMeta.class;

    public RandomValue(TransformMeta transformMeta, RandomValueMeta meta, RandomValueData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] getRandomValue(IRowMeta inputRowMeta, Object[] inputRowData) {
        Object[] row = RowDataUtil.createResizedCopy((Object[])inputRowData, (int)((RandomValueData)this.data).outputRowMeta.size());
        int index = inputRowMeta.size();
        for (RandomValueMeta.RVField field : ((RandomValueMeta)this.meta).getFields()) {
            switch (field.getType()) {
                case NUMBER: {
                    row[index] = ((RandomValueData)this.data).randomGenerator.nextDouble();
                    break;
                }
                case INTEGER: {
                    row[index] = (long)((RandomValueData)this.data).randomGenerator.nextInt();
                    break;
                }
                case STRING: {
                    row[index] = Long.toString(Math.abs(((RandomValueData)this.data).randomGenerator.nextLong()), 32);
                    break;
                }
                case UUID: {
                    row[index] = UUID.randomUUID().toString();
                    break;
                }
                case UUID4: {
                    row[index] = ((RandomValueData)this.data).u4.getUUID4AsString();
                    break;
                }
                case HMAC_MD5: {
                    try {
                        row[index] = this.generateRandomMACHash(RandomValueMeta.RandomType.HMAC_MD5);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACMD5", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
                case HMAC_SHA1: {
                    try {
                        row[index] = this.generateRandomMACHash(RandomValueMeta.RandomType.HMAC_SHA1);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACSHA1", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
                case HMAC_SHA256: {
                    try {
                        row[index] = this.generateRandomMACHash(RandomValueMeta.RandomType.HMAC_SHA256);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACSHA1", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
                case HMAC_SHA512: {
                    try {
                        row[index] = this.generateRandomMACHash(RandomValueMeta.RandomType.HMAC_SHA512);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACSHA1", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
                case HMAC_SHA384: {
                    try {
                        row[index] = this.generateRandomMACHash(RandomValueMeta.RandomType.HMAC_SHA384);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACSHA1", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
            }
            ++index;
        }
        return row;
    }

    private String generateRandomMACHash(RandomValueMeta.RandomType algorithm) throws Exception {
        Key sk = null;
        switch (algorithm) {
            case HMAC_MD5: {
                sk = ((RandomValueData)this.data).keyGenHmacMD5.generateKey();
                break;
            }
            case HMAC_SHA1: {
                sk = ((RandomValueData)this.data).keyGenHmacSHA1.generateKey();
                break;
            }
            case HMAC_SHA256: {
                sk = ((RandomValueData)this.data).keyGenHmacSHA256.generateKey();
                break;
            }
            case HMAC_SHA384: {
                sk = ((RandomValueData)this.data).keyGenHmacSHA384.generateKey();
                break;
            }
            case HMAC_SHA512: {
                sk = ((RandomValueData)this.data).keyGenHmacSHA512.generateKey();
                break;
            }
        }
        if (sk == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"RandomValue.Log.SecretKeyNull", (String[])new String[0]));
        }
        Mac mac = Mac.getInstance(sk.getAlgorithm());
        mac.init(sk);
        byte[] hashCode = mac.doFinal();
        StringBuilder encoded = new StringBuilder();
        for (byte value : hashCode) {
            Object b = Integer.toHexString(value);
            if (((String)b).length() == 1) {
                b = "0" + (String)b;
            }
            encoded.append(((String)b).substring(((String)b).length() - 2));
        }
        return encoded.toString();
    }

    public boolean processRow() throws HopException {
        IRowMeta imeta;
        Object[] row;
        if (((RandomValueData)this.data).readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((RandomValueData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((RandomValueMeta)this.meta).getFields(((RandomValueData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                ((RandomValueData)this.data).outputRowMeta = new RowMeta();
                ((RandomValueMeta)this.meta).getFields(((RandomValueData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getRandomValue(imeta, row);
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"RandomValue.Log.ValueReturned", (String[])new String[]{((RandomValueData)this.data).outputRowMeta.getString(row)}));
        }
        this.putRow(((RandomValueData)this.data).outputRowMeta, row);
        if (!((RandomValueData)this.data).readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        List previous = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
        if (previous != null && !previous.isEmpty()) {
            ((RandomValueData)this.data).readsRows = true;
        }
        boolean random = false;
        boolean genHmacMD5 = false;
        boolean genHmacSHA1 = false;
        boolean genHmacSHA256 = false;
        boolean genHmacSHA512 = false;
        boolean genHmacSHA384 = false;
        boolean uuid4 = false;
        for (RandomValueMeta.RVField field : ((RandomValueMeta)this.meta).getFields()) {
            switch (field.getType()) {
                case NUMBER: 
                case INTEGER: 
                case STRING: {
                    random = true;
                    break;
                }
                case HMAC_MD5: {
                    genHmacMD5 = true;
                    break;
                }
                case HMAC_SHA1: {
                    genHmacSHA1 = true;
                    break;
                }
                case HMAC_SHA256: {
                    genHmacSHA256 = true;
                    break;
                }
                case HMAC_SHA512: {
                    genHmacSHA512 = true;
                    break;
                }
                case HMAC_SHA384: {
                    genHmacSHA384 = true;
                    break;
                }
                case UUID4: {
                    uuid4 = true;
                    break;
                }
            }
        }
        if (random) {
            if (StringUtils.isEmpty((String)((RandomValueMeta)this.meta).getSeed())) {
                ((RandomValueData)this.data).randomGenerator = new Random();
            } else {
                long seed = Const.toLong((String)this.resolve(((RandomValueMeta)this.meta).getSeed()), (long)0L);
                ((RandomValueData)this.data).randomGenerator = new Random(seed);
            }
        }
        if (genHmacMD5) {
            try {
                ((RandomValueData)this.data).keyGenHmacMD5 = KeyGenerator.getInstance("HmacMD5");
            }
            catch (NoSuchAlgorithmException s) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacMD5AlgorithmException", (String[])new String[]{s.getMessage()}));
                return false;
            }
        }
        if (genHmacSHA1) {
            try {
                ((RandomValueData)this.data).keyGenHmacSHA1 = KeyGenerator.getInstance("HmacSHA1");
            }
            catch (NoSuchAlgorithmException s) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacSHA1AlgorithmException", (String[])new String[]{s.getMessage()}));
                return false;
            }
        }
        if (genHmacSHA256) {
            try {
                ((RandomValueData)this.data).keyGenHmacSHA256 = KeyGenerator.getInstance("HmacSHA256");
            }
            catch (NoSuchAlgorithmException s) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacSHA1AlgorithmException", (String[])new String[]{s.getMessage()}));
                return false;
            }
        }
        if (genHmacSHA512) {
            try {
                ((RandomValueData)this.data).keyGenHmacSHA512 = KeyGenerator.getInstance("HmacSHA512");
            }
            catch (NoSuchAlgorithmException s) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacSHA1AlgorithmException", (String[])new String[]{s.getMessage()}));
                return false;
            }
        }
        if (genHmacSHA384) {
            try {
                ((RandomValueData)this.data).keyGenHmacSHA384 = KeyGenerator.getInstance("HmacSHA384");
            }
            catch (NoSuchAlgorithmException s) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacSHA1AlgorithmException", (String[])new String[]{s.getMessage()}));
                return false;
            }
        }
        if (uuid4) {
            ((RandomValueData)this.data).u4 = new Uuid4Util();
        }
        return true;
    }
}

