/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.fileproperties.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class AddPropertiesError {
    public static final AddPropertiesError RESTRICTED_CONTENT = new AddPropertiesError().withTag(Tag.RESTRICTED_CONTENT);
    public static final AddPropertiesError OTHER = new AddPropertiesError().withTag(Tag.OTHER);
    public static final AddPropertiesError UNSUPPORTED_FOLDER = new AddPropertiesError().withTag(Tag.UNSUPPORTED_FOLDER);
    public static final AddPropertiesError PROPERTY_FIELD_TOO_LARGE = new AddPropertiesError().withTag(Tag.PROPERTY_FIELD_TOO_LARGE);
    public static final AddPropertiesError DOES_NOT_FIT_TEMPLATE = new AddPropertiesError().withTag(Tag.DOES_NOT_FIT_TEMPLATE);
    public static final AddPropertiesError DUPLICATE_PROPERTY_GROUPS = new AddPropertiesError().withTag(Tag.DUPLICATE_PROPERTY_GROUPS);
    public static final AddPropertiesError PROPERTY_GROUP_ALREADY_EXISTS = new AddPropertiesError().withTag(Tag.PROPERTY_GROUP_ALREADY_EXISTS);
    private Tag _tag;
    private String templateNotFoundValue;
    private LookupError pathValue;

    private AddPropertiesError() {
    }

    private AddPropertiesError withTag(Tag _tag) {
        AddPropertiesError result = new AddPropertiesError();
        result._tag = _tag;
        return result;
    }

    private AddPropertiesError withTagAndTemplateNotFound(Tag _tag, String templateNotFoundValue) {
        AddPropertiesError result = new AddPropertiesError();
        result._tag = _tag;
        result.templateNotFoundValue = templateNotFoundValue;
        return result;
    }

    private AddPropertiesError withTagAndPath(Tag _tag, LookupError pathValue) {
        AddPropertiesError result = new AddPropertiesError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTemplateNotFound() {
        return this._tag == Tag.TEMPLATE_NOT_FOUND;
    }

    public static AddPropertiesError templateNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        if (!Pattern.matches("(/|ptid:).*", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new AddPropertiesError().withTagAndTemplateNotFound(Tag.TEMPLATE_NOT_FOUND, value);
    }

    public String getTemplateNotFoundValue() {
        if (this._tag != Tag.TEMPLATE_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.TEMPLATE_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.templateNotFoundValue;
    }

    public boolean isRestrictedContent() {
        return this._tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static AddPropertiesError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddPropertiesError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isUnsupportedFolder() {
        return this._tag == Tag.UNSUPPORTED_FOLDER;
    }

    public boolean isPropertyFieldTooLarge() {
        return this._tag == Tag.PROPERTY_FIELD_TOO_LARGE;
    }

    public boolean isDoesNotFitTemplate() {
        return this._tag == Tag.DOES_NOT_FIT_TEMPLATE;
    }

    public boolean isDuplicatePropertyGroups() {
        return this._tag == Tag.DUPLICATE_PROPERTY_GROUPS;
    }

    public boolean isPropertyGroupAlreadyExists() {
        return this._tag == Tag.PROPERTY_GROUP_ALREADY_EXISTS;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.templateNotFoundValue, this.pathValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AddPropertiesError) {
            AddPropertiesError other = (AddPropertiesError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEMPLATE_NOT_FOUND: {
                    return this.templateNotFoundValue == other.templateNotFoundValue || this.templateNotFoundValue.equals(other.templateNotFoundValue);
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case UNSUPPORTED_FOLDER: {
                    return true;
                }
                case PROPERTY_FIELD_TOO_LARGE: {
                    return true;
                }
                case DOES_NOT_FIT_TEMPLATE: {
                    return true;
                }
                case DUPLICATE_PROPERTY_GROUPS: {
                    return true;
                }
                case PROPERTY_GROUP_ALREADY_EXISTS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<AddPropertiesError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(AddPropertiesError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEMPLATE_NOT_FOUND: {
                    g.writeStartObject();
                    this.writeTag("template_not_found", g);
                    g.writeFieldName("template_not_found");
                    StoneSerializers.string().serialize(value.templateNotFoundValue, g);
                    g.writeEndObject();
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g.writeString("restricted_content");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case UNSUPPORTED_FOLDER: {
                    g.writeString("unsupported_folder");
                    break;
                }
                case PROPERTY_FIELD_TOO_LARGE: {
                    g.writeString("property_field_too_large");
                    break;
                }
                case DOES_NOT_FIT_TEMPLATE: {
                    g.writeString("does_not_fit_template");
                    break;
                }
                case DUPLICATE_PROPERTY_GROUPS: {
                    g.writeString("duplicate_property_groups");
                    break;
                }
                case PROPERTY_GROUP_ALREADY_EXISTS: {
                    g.writeString("property_group_already_exists");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public AddPropertiesError deserialize(JsonParser p) throws IOException, JsonParseException {
            AddPropertiesError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("template_not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("template_not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = AddPropertiesError.templateNotFound(fieldValue);
            } else if ("restricted_content".equals(tag)) {
                value = RESTRICTED_CONTENT;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = AddPropertiesError.path(fieldValue);
            } else if ("unsupported_folder".equals(tag)) {
                value = UNSUPPORTED_FOLDER;
            } else if ("property_field_too_large".equals(tag)) {
                value = PROPERTY_FIELD_TOO_LARGE;
            } else if ("does_not_fit_template".equals(tag)) {
                value = DOES_NOT_FIT_TEMPLATE;
            } else if ("duplicate_property_groups".equals(tag)) {
                value = DUPLICATE_PROPERTY_GROUPS;
            } else if ("property_group_already_exists".equals(tag)) {
                value = PROPERTY_GROUP_ALREADY_EXISTS;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEMPLATE_NOT_FOUND,
        RESTRICTED_CONTENT,
        OTHER,
        PATH,
        UNSUPPORTED_FOLDER,
        PROPERTY_FIELD_TOO_LARGE,
        DOES_NOT_FIT_TEMPLATE,
        DUPLICATE_PROPERTY_GROUPS,
        PROPERTY_GROUP_ALREADY_EXISTS;

    }
}

