/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Matches
extends SystemFunction {
    private RegularExpression regexp;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = this.simplifyArguments(staticContext);
        if (this.regexp == null && !(expression instanceof Value)) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2, staticContext);
            }
            catch (StaticError staticError) {
                staticError.setLocator(this);
                throw staticError;
            }
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        RegularExpression regularExpression;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            atomicValue = StringValue.EMPTY_STRING;
        }
        if ((regularExpression = this.regexp) == null) {
            Serializable serializable;
            CharSequence charSequence;
            AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            if (this.argument.length == 2) {
                charSequence = "";
            } else {
                serializable = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
                if (serializable == null) {
                    return null;
                }
                charSequence = ((AtomicValue)serializable).getStringValueCS();
            }
            try {
                serializable = xPathContext.getConfiguration().getPlatform();
                regularExpression = serializable.compileRegularExpression(atomicValue2.getStringValueCS(), true, charSequence);
            }
            catch (XPathException xPathException) {
                DynamicError dynamicError = new DynamicError(xPathException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
        }
        return BooleanValue.get(regularExpression.containsMatch(atomicValue.getStringValueCS()));
    }

    public static RegularExpression tryToCompile(Expression[] expressionArray, int n, int n2, StaticContext staticContext) throws XPathException {
        if (n > expressionArray.length - 1) {
            return null;
        }
        CharSequence charSequence = null;
        if (expressionArray.length - 1 < n2) {
            charSequence = "";
        } else if (expressionArray[n2] instanceof StringValue) {
            charSequence = ((StringValue)expressionArray[n2]).getStringValueCS();
        }
        if (expressionArray[n] instanceof StringValue && charSequence != null) {
            try {
                Platform platform = staticContext.getConfiguration().getPlatform();
                CharSequence charSequence2 = ((StringValue)expressionArray[n]).getStringValueCS();
                RegularExpression regularExpression = platform.compileRegularExpression(charSequence2, true, charSequence);
                return regularExpression;
            }
            catch (XPathException xPathException) {
                StaticError staticError = new StaticError(xPathException.getMessage());
                staticError.setErrorCode("FORX0002");
                throw staticError;
            }
        }
        return null;
    }
}

