/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.shell;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.shell.ActionShell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionShellDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionShell.class;
    private static final String[] FILEFORMATS = new String[]{BaseMessages.getString(PKG, (String)"ActionShell.Fileformat.Scripts", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionShell.Fileformat.All", (String[])new String[0])};
    private Text wName;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private TextVar wWorkDirectory;
    private Button wSetLogfile;
    private Label wlLogfile;
    private TextVar wLogfile;
    private Label wlLogExt;
    private TextVar wLogExt;
    private Label wlAddDate;
    private Button wAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private Label wlLoglevel;
    private CCombo wLoglevel;
    private Label wlPrevious;
    private Button wPrevious;
    private Label wlEveryRow;
    private Button wEveryRow;
    private Label wlFields;
    private TableView wFields;
    private ActionShell action;
    private boolean backupChanged;
    private boolean backupLogfile;
    private boolean backupDate;
    private boolean backupTime;
    private Label wlAppendLogfile;
    private Button wAppendLogfile;
    private Button wInsertScript;
    private Display display;
    private Label wlScript;
    private Text wScript;

    public ActionShellDialog(Shell parent, ActionShell action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
    }

    public IAction open() {
        this.display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.backupChanged = this.action.hasChanged();
        this.backupLogfile = this.action.setLogfile;
        this.backupDate = this.action.addDate;
        this.backupTime = this.action.addTime;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionShell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionShell.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.top = new FormAttachment(0, margin);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionShell.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Label wlInsertScript = new Label(wGeneralComp, 131072);
        wlInsertScript.setText(BaseMessages.getString(PKG, (String)"ActionShell.InsertScript.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInsertScript);
        FormData fdlInsertScript = new FormData();
        fdlInsertScript.left = new FormAttachment(0, 0);
        fdlInsertScript.top = new FormAttachment(0, margin);
        fdlInsertScript.right = new FormAttachment(middle, -margin);
        wlInsertScript.setLayoutData((Object)fdlInsertScript);
        this.wInsertScript = new Button(wGeneralComp, 32);
        this.wInsertScript.setToolTipText(BaseMessages.getString(PKG, (String)"ActionShell.InsertScript.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wInsertScript);
        FormData fdInsertScript = new FormData();
        fdInsertScript.left = new FormAttachment(middle, 0);
        fdInsertScript.top = new FormAttachment((Control)wlInsertScript, 0, 0x1000000);
        fdInsertScript.right = new FormAttachment(100, 0);
        this.wInsertScript.setLayoutData((Object)fdInsertScript);
        this.wInsertScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionShellDialog.this.activeInsertScript();
                ActionShellDialog.this.action.setChanged();
            }
        });
        this.wlFilename = new Label(wGeneralComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionShell.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wInsertScript, 2 * margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbFilename = new Button(wGeneralComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        fdbFilename.right = new FormAttachment(100, 0);
        this.wbFilename.setLayoutData((Object)fdbFilename);
        this.wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.sh;*.bat;*.BAT", "*;*.*"}, (String[])FILEFORMATS, (boolean)true));
        this.wFilename = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        fdFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlWorkDirectory = new Label(wGeneralComp, 131072);
        wlWorkDirectory.setText(BaseMessages.getString(PKG, (String)"ActionShell.WorkingDirectory.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWorkDirectory);
        FormData fdlWorkDirectory = new FormData();
        fdlWorkDirectory.left = new FormAttachment(0, 0);
        fdlWorkDirectory.top = new FormAttachment((Control)this.wFilename, 2 * margin);
        fdlWorkDirectory.right = new FormAttachment(middle, -margin);
        wlWorkDirectory.setLayoutData((Object)fdlWorkDirectory);
        this.wWorkDirectory = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wWorkDirectory);
        this.wWorkDirectory.addModifyListener(lsMod);
        FormData fdWorkDirectory = new FormData();
        fdWorkDirectory.left = new FormAttachment(middle, 0);
        fdWorkDirectory.right = new FormAttachment((Control)this.wbFilename, -margin);
        fdWorkDirectory.top = new FormAttachment((Control)wlWorkDirectory, 0, 0x1000000);
        this.wWorkDirectory.setLayoutData((Object)fdWorkDirectory);
        Group wLogging = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wLogging);
        wLogging.setText(BaseMessages.getString(PKG, (String)"ActionShell.LogSettings.Group.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wLogging.setLayout((Layout)groupLayout);
        Label wlSetLogfile = new Label((Composite)wLogging, 131072);
        wlSetLogfile.setText(BaseMessages.getString(PKG, (String)"ActionShell.Specify.Logfile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSetLogfile);
        FormData fdlSetLogfile = new FormData();
        fdlSetLogfile.left = new FormAttachment(0, 0);
        fdlSetLogfile.top = new FormAttachment(0, margin);
        fdlSetLogfile.right = new FormAttachment(middle, -margin);
        wlSetLogfile.setLayoutData((Object)fdlSetLogfile);
        this.wSetLogfile = new Button((Composite)wLogging, 32);
        PropsUi.setLook((Widget)this.wSetLogfile);
        FormData fdSetLogfile = new FormData();
        fdSetLogfile.left = new FormAttachment(middle, 0);
        fdSetLogfile.top = new FormAttachment((Control)wlSetLogfile, 0, 0x1000000);
        fdSetLogfile.right = new FormAttachment(100, 0);
        this.wSetLogfile.setLayoutData((Object)fdSetLogfile);
        this.wSetLogfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionShellDialog.this.action.setLogfile = !ActionShellDialog.this.action.setLogfile;
                ActionShellDialog.this.action.setChanged();
                ActionShellDialog.this.enableFields();
            }
        });
        this.wlAppendLogfile = new Label((Composite)wLogging, 131072);
        this.wlAppendLogfile.setText(BaseMessages.getString(PKG, (String)"ActionShell.Append.Logfile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAppendLogfile);
        FormData fdlAppendLogfile = new FormData();
        fdlAppendLogfile.left = new FormAttachment(0, 0);
        fdlAppendLogfile.top = new FormAttachment((Control)this.wSetLogfile, 2 * margin);
        fdlAppendLogfile.right = new FormAttachment(middle, -margin);
        this.wlAppendLogfile.setLayoutData((Object)fdlAppendLogfile);
        this.wAppendLogfile = new Button((Composite)wLogging, 32);
        this.wAppendLogfile.setToolTipText(BaseMessages.getString(PKG, (String)"ActionShell.Append.Logfile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAppendLogfile);
        FormData fdAppendLogfile = new FormData();
        fdAppendLogfile.left = new FormAttachment(middle, 0);
        fdAppendLogfile.top = new FormAttachment((Control)this.wlAppendLogfile, 0, 0x1000000);
        fdAppendLogfile.right = new FormAttachment(100, 0);
        this.wAppendLogfile.setLayoutData((Object)fdAppendLogfile);
        this.wAppendLogfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.wlLogfile = new Label((Composite)wLogging, 131072);
        this.wlLogfile.setText(BaseMessages.getString(PKG, (String)"ActionShell.NameOfLogfile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogfile);
        FormData fdlLogfile = new FormData();
        fdlLogfile.left = new FormAttachment(0, 0);
        fdlLogfile.top = new FormAttachment((Control)this.wAppendLogfile, 2 * margin);
        fdlLogfile.right = new FormAttachment(middle, -margin);
        this.wlLogfile.setLayoutData((Object)fdlLogfile);
        this.wLogfile = new TextVar(this.variables, (Composite)wLogging, 18436);
        this.wLogfile.setText("");
        PropsUi.setLook((Widget)this.wLogfile);
        FormData fdLogfile = new FormData();
        fdLogfile.left = new FormAttachment(middle, 0);
        fdLogfile.top = new FormAttachment((Control)this.wlLogfile, 0, 0x1000000);
        fdLogfile.right = new FormAttachment(100, 0);
        this.wLogfile.setLayoutData((Object)fdLogfile);
        this.wlLogExt = new Label((Composite)wLogging, 131072);
        this.wlLogExt.setText(BaseMessages.getString(PKG, (String)"ActionShell.LogfileExtension.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLogExt);
        FormData fdlLogExt = new FormData();
        fdlLogExt.left = new FormAttachment(0, 0);
        fdlLogExt.top = new FormAttachment((Control)this.wLogfile, 2 * margin);
        fdlLogExt.right = new FormAttachment(middle, -margin);
        this.wlLogExt.setLayoutData((Object)fdlLogExt);
        this.wLogExt = new TextVar(this.variables, (Composite)wLogging, 18436);
        this.wLogExt.setText("");
        PropsUi.setLook((Widget)this.wLogExt);
        FormData fdLogExt = new FormData();
        fdLogExt.left = new FormAttachment(middle, 0);
        fdLogExt.top = new FormAttachment((Control)this.wlLogExt, 0, 0x1000000);
        fdLogExt.right = new FormAttachment(100, 0);
        this.wLogExt.setLayoutData((Object)fdLogExt);
        this.wlAddDate = new Label((Composite)wLogging, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"ActionShell.Logfile.IncludeDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddDate);
        FormData fdlAddDate = new FormData();
        fdlAddDate.left = new FormAttachment(0, 0);
        fdlAddDate.top = new FormAttachment((Control)this.wLogExt, 2 * margin);
        fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)fdlAddDate);
        this.wAddDate = new Button((Composite)wLogging, 32);
        PropsUi.setLook((Widget)this.wAddDate);
        FormData fdAddDate = new FormData();
        fdAddDate.left = new FormAttachment(middle, 0);
        fdAddDate.top = new FormAttachment((Control)this.wlAddDate, 0, 0x1000000);
        fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionShellDialog.this.action.addDate = !ActionShellDialog.this.action.addDate;
                ActionShellDialog.this.action.setChanged();
            }
        });
        this.wlAddTime = new Label((Composite)wLogging, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"ActionShell.Logfile.IncludeTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddTime);
        FormData fdlAddTime = new FormData();
        fdlAddTime.left = new FormAttachment(0, 0);
        fdlAddTime.top = new FormAttachment((Control)this.wAddDate, 2 * margin);
        fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)fdlAddTime);
        this.wAddTime = new Button((Composite)wLogging, 32);
        PropsUi.setLook((Widget)this.wAddTime);
        FormData fdAddTime = new FormData();
        fdAddTime.left = new FormAttachment(middle, 0);
        fdAddTime.top = new FormAttachment((Control)this.wlAddTime, 0, 0x1000000);
        fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionShellDialog.this.action.addTime = !ActionShellDialog.this.action.addTime;
                ActionShellDialog.this.action.setChanged();
            }
        });
        this.wlLoglevel = new Label((Composite)wLogging, 131072);
        this.wlLoglevel.setText(BaseMessages.getString(PKG, (String)"ActionShell.Loglevel.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLoglevel);
        FormData fdlLoglevel = new FormData();
        fdlLoglevel.left = new FormAttachment(0, 0);
        fdlLoglevel.right = new FormAttachment(middle, -margin);
        fdlLoglevel.top = new FormAttachment((Control)this.wAddTime, 2 * margin);
        this.wlLoglevel.setLayoutData((Object)fdlLoglevel);
        this.wLoglevel = new CCombo((Composite)wLogging, 2060);
        this.wLoglevel.setItems(LogLevel.getLogLevelDescriptions());
        PropsUi.setLook((Widget)this.wLoglevel);
        FormData fdLoglevel = new FormData();
        fdLoglevel.left = new FormAttachment(middle, 0);
        fdLoglevel.top = new FormAttachment((Control)this.wlLoglevel, 0, 0x1000000);
        fdLoglevel.right = new FormAttachment(100, 0);
        this.wLoglevel.setLayoutData((Object)fdLoglevel);
        FormData fdLogging = new FormData();
        fdLogging.left = new FormAttachment(0, margin);
        fdLogging.top = new FormAttachment((Control)this.wWorkDirectory, margin);
        fdLogging.right = new FormAttachment(100, -margin);
        wLogging.setLayoutData((Object)fdLogging);
        this.wlPrevious = new Label(wGeneralComp, 131072);
        this.wlPrevious.setText(BaseMessages.getString(PKG, (String)"ActionShell.Previous.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPrevious);
        FormData fdlPrevious = new FormData();
        fdlPrevious.left = new FormAttachment(0, 0);
        fdlPrevious.top = new FormAttachment((Control)wLogging, margin * 3);
        fdlPrevious.right = new FormAttachment(middle, -margin);
        this.wlPrevious.setLayoutData((Object)fdlPrevious);
        this.wPrevious = new Button(wGeneralComp, 32);
        PropsUi.setLook((Widget)this.wPrevious);
        this.wPrevious.setSelection(this.action.argFromPrevious);
        this.wPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionShell.Previous.Tooltip", (String[])new String[0]));
        FormData fdPrevious = new FormData();
        fdPrevious.left = new FormAttachment(middle, 0);
        fdPrevious.top = new FormAttachment((Control)this.wlPrevious, 0, 0x1000000);
        fdPrevious.right = new FormAttachment(100, 0);
        this.wPrevious.setLayoutData((Object)fdPrevious);
        this.wPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionShellDialog.this.action.argFromPrevious = !ActionShellDialog.this.action.argFromPrevious;
                ActionShellDialog.this.action.setChanged();
                ActionShellDialog.this.wlFields.setEnabled(!ActionShellDialog.this.action.argFromPrevious);
                ActionShellDialog.this.wFields.setEnabled(!ActionShellDialog.this.action.argFromPrevious);
            }
        });
        this.wlEveryRow = new Label(wGeneralComp, 131072);
        this.wlEveryRow.setText(BaseMessages.getString(PKG, (String)"ActionShell.ExecForEveryInputRow.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlEveryRow);
        FormData fdlEveryRow = new FormData();
        fdlEveryRow.left = new FormAttachment(0, 0);
        fdlEveryRow.top = new FormAttachment((Control)this.wPrevious, 2 * margin);
        fdlEveryRow.right = new FormAttachment(middle, -margin);
        this.wlEveryRow.setLayoutData((Object)fdlEveryRow);
        this.wEveryRow = new Button(wGeneralComp, 32);
        PropsUi.setLook((Widget)this.wEveryRow);
        this.wEveryRow.setSelection(this.action.execPerRow);
        this.wEveryRow.setToolTipText(BaseMessages.getString(PKG, (String)"ActionShell.ExecForEveryInputRow.Tooltip", (String[])new String[0]));
        FormData fdEveryRow = new FormData();
        fdEveryRow.left = new FormAttachment(middle, 0);
        fdEveryRow.top = new FormAttachment((Control)this.wlEveryRow, 0, 0x1000000);
        fdEveryRow.right = new FormAttachment(100, 0);
        this.wEveryRow.setLayoutData((Object)fdEveryRow);
        this.wEveryRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionShellDialog.this.action.execPerRow = !ActionShellDialog.this.action.execPerRow;
                ActionShellDialog.this.action.setChanged();
            }
        });
        this.wlFields = new Label(wGeneralComp, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ActionShell.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wlEveryRow, 2 * margin);
        this.wlFields.setLayoutData((Object)fdlFields);
        boolean nrFieldsCols = true;
        int nrRows = this.action.arguments == null ? 1 : (this.action.arguments.isEmpty() ? 1 : this.action.arguments.size());
        ColumnInfo[] fieldColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionShell.Fields.Argument.Label", (String[])new String[0]), 1, false)};
        fieldColumns[0].setUsingVariables(true);
        this.wFields = new TableView(this.variables, wGeneralComp, 67586, fieldColumns, nrRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wlFields.setEnabled(!this.action.argFromPrevious);
        this.wFields.setEnabled(!this.action.argFromPrevious);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(500, -margin);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        CTabItem wScriptTab = new CTabItem(wTabFolder, 0);
        wScriptTab.setFont(GuiResource.getInstance().getFontDefault());
        wScriptTab.setText(BaseMessages.getString(PKG, (String)"ActionShell.Tab.Script.Label", (String[])new String[0]));
        FormLayout scriptLayout = new FormLayout();
        scriptLayout.marginWidth = 3;
        scriptLayout.marginHeight = 3;
        Composite wScriptComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wScriptComp);
        wScriptComp.setLayout((Layout)scriptLayout);
        this.wScript = new Text(wScriptComp, 19202);
        PropsUi.setLook((Widget)this.wScript);
        this.wScript.addModifyListener(lsMod);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment(0, margin);
        fdScript.top = new FormAttachment((Control)this.wlScript, margin);
        fdScript.right = new FormAttachment(100, 0);
        fdScript.bottom = new FormAttachment(100, -margin);
        this.wScript.setLayoutData((Object)fdScript);
        FormData fdScriptComp = new FormData();
        fdScriptComp.left = new FormAttachment(0, 0);
        fdScriptComp.top = new FormAttachment(0, 0);
        fdScriptComp.right = new FormAttachment(100, 0);
        fdScriptComp.bottom = new FormAttachment(100, 0);
        wScriptComp.setLayoutData((Object)wScriptComp);
        wScriptComp.layout();
        wScriptTab.setControl((Control)wScriptComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.enableFields();
        this.activeInsertScript();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void activeInsertScript() {
        this.wFilename.setEnabled(!this.wInsertScript.getSelection());
        this.wlFilename.setEnabled(!this.wInsertScript.getSelection());
        this.wbFilename.setEnabled(!this.wInsertScript.getSelection());
        this.wScript.setEnabled(this.wInsertScript.getSelection());
        if (this.wInsertScript.getSelection()) {
            this.wFields.clearAll(false);
            this.wFields.setEnabled(false);
            this.wlFields.setEnabled(false);
            this.wPrevious.setSelection(false);
            this.wPrevious.setEnabled(false);
            this.wlPrevious.setEnabled(false);
            this.wEveryRow.setSelection(false);
            this.wEveryRow.setEnabled(false);
            this.wlEveryRow.setEnabled(false);
        } else {
            this.wFields.setEnabled(true);
            this.wlFields.setEnabled(true);
            this.wPrevious.setEnabled(true);
            this.wlPrevious.setEnabled(true);
            this.wEveryRow.setEnabled(true);
            this.wlEveryRow.setEnabled(true);
        }
    }

    public void enableFields() {
        this.wlLogfile.setEnabled(this.action.setLogfile);
        this.wLogfile.setEnabled(this.action.setLogfile);
        this.wlLogExt.setEnabled(this.action.setLogfile);
        this.wLogExt.setEnabled(this.action.setLogfile);
        this.wlAddDate.setEnabled(this.action.setLogfile);
        this.wAddDate.setEnabled(this.action.setLogfile);
        this.wlAddTime.setEnabled(this.action.setLogfile);
        this.wAddTime.setEnabled(this.action.setLogfile);
        this.wlLoglevel.setEnabled(this.action.setLogfile);
        this.wLoglevel.setEnabled(this.action.setLogfile);
        this.wlAppendLogfile.setEnabled(this.action.setLogfile);
        this.wAppendLogfile.setEnabled(this.action.setLogfile);
        if (this.action.setLogfile) {
            this.wLoglevel.setForeground(this.display.getSystemColor(2));
        } else {
            this.wLoglevel.setForeground(this.display.getSystemColor(15));
        }
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wFilename.setText(Const.nullToEmpty((String)this.action.getFilename()));
        this.wWorkDirectory.setText(Const.nullToEmpty((String)this.action.getWorkDirectory()));
        if (this.action.arguments != null) {
            for (int i = 0; i < this.action.arguments.size(); ++i) {
                TableItem ti = this.wFields.table.getItem(i);
                if (this.action.arguments.get(i) == null) continue;
                ti.setText(1, this.action.arguments.get(i));
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wPrevious.setSelection(this.action.argFromPrevious);
        this.wEveryRow.setSelection(this.action.execPerRow);
        this.wSetLogfile.setSelection(this.action.setLogfile);
        this.wLogfile.setText(Const.nullToEmpty((String)this.action.logfile));
        this.wLogExt.setText(Const.nullToEmpty((String)this.action.logext));
        this.wAddDate.setSelection(this.action.addDate);
        this.wAddTime.setSelection(this.action.addTime);
        this.wAppendLogfile.setSelection(this.action.setAppendLogfile);
        if (this.action.logFileLevel != null) {
            this.wLoglevel.setText(this.action.getLogFileLevel());
        }
        this.wInsertScript.setSelection(this.action.insertScript);
        this.wScript.setText(Const.nullToEmpty((String)this.action.getScript()));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.backupChanged);
        this.action.setLogfile = this.backupLogfile;
        this.action.addDate = this.backupDate;
        this.action.addTime = this.backupTime;
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setFilename(this.wFilename.getText());
        this.action.setName(this.wName.getText());
        this.action.setWorkDirectory(this.wWorkDirectory.getText());
        this.action.arguments = new ArrayList<String>();
        for (int i = 0; i < this.wFields.nrNonEmpty(); ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            this.action.arguments.add(arg);
        }
        this.action.logfile = this.wLogfile.getText();
        this.action.logext = this.wLogExt.getText();
        this.action.logFileLevel = this.wLoglevel.getSelectionIndex() >= 0 ? this.wLoglevel.getText() : "Basic";
        this.action.setAppendLogfile = this.wAppendLogfile.getSelection();
        this.action.setScript(this.wScript.getText());
        this.action.insertScript = this.wInsertScript.getSelection();
        this.dispose();
    }
}

