/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.PartialResultSet;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.cloud.bigtable.data.v2.stub.sql.ProtoRowsMergingStateMachine;
import com.google.cloud.bigtable.gaxx.reframing.Reframer;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Queue;

@InternalApi
public final class SqlRowMerger
implements Reframer<SqlRow, ExecuteQueryResponse> {
    private final Queue<SqlRow> queue = new ArrayDeque<SqlRow>();
    private ProtoRowsMergingStateMachine stateMachine;
    private State currentState = State.AWAITING_METADATA;

    @Override
    public void push(ExecuteQueryResponse response) {
        switch (this.currentState) {
            case AWAITING_METADATA: {
                Preconditions.checkState((boolean)response.hasMetadata(), (String)"Expected metadata response, but received: %s", (Object)response.getResponseCase().name());
                ResultSetMetadata responseMetadata = ProtoResultSetMetadata.fromProto(response.getMetadata());
                this.stateMachine = new ProtoRowsMergingStateMachine(responseMetadata);
                this.currentState = State.PROCESSING_DATA;
                break;
            }
            case PROCESSING_DATA: {
                Preconditions.checkState((boolean)response.hasResults(), (String)"Expected results response, but received: %s", (Object)response.getResponseCase().name());
                PartialResultSet results = response.getResults();
                this.processProtoRows(results);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown State: " + this.currentState.name());
            }
        }
    }

    private void processProtoRows(PartialResultSet results) {
        this.stateMachine.addPartialResultSet(results);
        if (this.stateMachine.hasCompleteBatch()) {
            this.stateMachine.populateQueue(this.queue);
        }
    }

    @Override
    public boolean hasFullFrame() {
        return !this.queue.isEmpty();
    }

    @Override
    public boolean hasPartialFrame() {
        switch (this.currentState) {
            case AWAITING_METADATA: {
                return false;
            }
            case PROCESSING_DATA: {
                return this.hasFullFrame() || this.stateMachine.isBatchInProgress();
            }
        }
        throw new IllegalStateException("Unknown State: " + this.currentState.name());
    }

    @Override
    public SqlRow pop() {
        return (SqlRow)Preconditions.checkNotNull((Object)this.queue.poll(), (Object)"SqlRowMerger.pop() called when there are no complete rows.");
    }

    static enum State {
        AWAITING_METADATA,
        PROCESSING_DATA;

    }
}

