/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import java.io.IOException;
import java.io.Serializable;

class IFSDirectoryFilter
implements IFSFileFilter,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private int include_;
    private IFSFileFilter otherFilter_;

    public IFSDirectoryFilter(int include, IFSFileFilter otherFilter) {
        this.include_ = include;
        this.otherFilter_ = otherFilter;
    }

    @Override
    public boolean accept(IFSFile file) {
        boolean accept = true;
        try {
            switch (this.include_) {
                case 0: {
                    accept = !file.isDirectory();
                    break;
                }
                case 1: {
                    accept = file.isDirectory();
                    break;
                }
                default: {
                    accept = true;
                    break;
                }
            }
        }
        catch (IOException e) {
            accept = false;
        }
        if (accept && this.otherFilter_ != null) {
            accept = this.otherFilter_.accept(file);
        }
        return accept;
    }

    public int getInclude() {
        return this.include_;
    }

    public IFSFileFilter getOtherFilter() {
        return this.otherFilter_;
    }

    public void setInclude(int include) {
        this.include_ = include;
    }

    public void setOtherFilter(IFSFileFilter otherFilter) {
        this.otherFilter_ = otherFilter;
    }
}

