/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NetServerConnection;
import com.ibm.as400.access.NetServerFileShare;
import com.ibm.as400.access.NetServerPrintShare;
import com.ibm.as400.access.NetServerSession;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.IntegerValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramAttributeSetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.RJobList;
import com.ibm.as400.resource.RUser;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;

public class NetServer
extends ChangeableResource {
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.access.MRI2");
    private static final String ICON_BASE_NAME_ = "NetServer";
    private static final String PRESENTATION_KEY_ = "NETSERVER";
    private static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "NETSERVER");
    private static ProgramMap getterMap_ = new ProgramMap();
    private static ProgramMap setterMap_ = new ProgramMap();
    private static final String OLST0201_ = "qzlsolst_zlsl0201";
    private static BooleanValueMap BV_MAP_0_1_ = new BooleanValueMap("0", "1");
    private static BooleanValueMap BV_MAP_0_1_INT_ = new BooleanValueMap(0, 1);
    private static BooleanValueMap BV_MAP_NO_YES_ = new BooleanValueMap("*NO", "*YES");
    private static BooleanValueMap BV_MAP_NO_ERR_YES_ = new BooleanValueMap(new String[]{"*NO", "*ERR"}, new String[]{"*YES"});
    private static IntegerValueMap INTV_MAP_ = new IntegerValueMap();
    public static final String ALLOW_SYSTEM_NAME = "ALLOW_SYSTEM_NAME";
    public static final String ALLOW_SYSTEM_NAME_PENDING = "ALLOW_SYSTEM_NAME_PENDING";
    public static final String AUTHENTICATION_METHOD = "AUTHENTICATION_METHOD";
    public static final String AUTHENTICATION_METHOD_PENDING = "AUTHENTICATION_METHOD_PENDING";
    public static final String AUTOSTART = "AUTOSTART";
    public static final String BROWSING_INTERVAL = "BROWSING_INTERVAL";
    public static final String BROWSING_INTERVAL_PENDING = "BROWSING_INTERVAL_PENDING";
    public static final String CCSID = "CCSID";
    public static final String CCSID_PENDING = "CCSID_PENDING";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String DESCRIPTION_PENDING = "DESCRIPTION_PENDING";
    public static final String DOMAIN = "DOMAIN";
    public static final String DOMAIN_PENDING = "DOMAIN_PENDING";
    static final String GUEST_SUPPORT = "GUEST_SUPPORT";
    static final String GUEST_SUPPORT_PENDING = "GUEST_SUPPORT_PENDING";
    public static final String GUEST_USER_PROFILE = "GUEST_USER_PROFILE";
    public static final String GUEST_USER_PROFILE_PENDING = "GUEST_USER_PROFILE_PENDING";
    public static final String IDLE_TIMEOUT = "IDLE_TIMEOUT";
    public static final String IDLE_TIMEOUT_PENDING = "IDLE_TIMEOUT_PENDING";
    public static final String LOGON_SUPPORT = "LOGON_SUPPORT";
    public static final String LOGON_SUPPORT_PENDING = "LOGON_SUPPORT_PENDING";
    public static final String NAME = "NAME";
    public static final String NAME_PENDING = "NAME_PENDING";
    static final String OPPORTUNISTIC_LOCK_TIMEOUT = "OPPORTUNISTIC_LOCK_TIMEOUT";
    static final String OPPORTUNISTIC_LOCK_TIMEOUT_PENDING = "OPPORTUNISTIC_LOCK_TIMEOUT_PENDING";
    public static final String WINS_ENABLEMENT = "WINS_ENABLEMENT";
    public static final String WINS_ENABLEMENT_PENDING = "WINS_ENABLEMENT_PENDING";
    public static final String WINS_PRIMARY_ADDRESS = "WINS_PRIMARY_ADDRESS";
    public static final String WINS_PRIMARY_ADDRESS_PENDING = "WINS_PRIMARY_ADDRESS_PENDING";
    public static final String WINS_SCOPE_ID = "WINS_SCOPE_ID";
    public static final String WINS_SCOPE_ID_PENDING = "WINS_SCOPE_ID_PENDING";
    public static final String WINS_SECONDARY_ADDRESS = "WINS_SECONDARY_ADDRESS";
    public static final String WINS_SECONDARY_ADDRESS_PENDING = "WINS_SECONDARY_ADDRESS_PENDING";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.access.NetServer";
    private static ProgramCallDocument staticDocument_;
    private ProgramCallDocument document_;
    private ProgramAttributeGetter attributeGetter_;
    private ProgramAttributeSetter attributeSetter_;

    public NetServer() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
        Presentation presentation = this.getPresentation();
        presentation.setName(ICON_BASE_NAME_);
        presentation.setFullName(ICON_BASE_NAME_);
    }

    public NetServer(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    static void callListProgram(ProgramCallDocument document, String programName, boolean recordsAreFixedLength) throws ResourceException {
        try {
            if (!document.callProgram(programName)) {
                throw new ResourceException(document.getMessageList(programName));
            }
            String informationCompleteIndicator = (String)document.getValue(programName + ".listInformation.informationCompleteIndicator");
            if (!informationCompleteIndicator.equals("C")) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Returned information incomplete on first API call.");
                }
                int totalRecords = document.getIntValue(programName + ".listInformation.totalRecords");
                int recordsReturned = document.getIntValue(programName + ".listInformation.recordsReturned");
                int recordLength = document.getIntValue(programName + ".listInformation.recordLength");
                if (recordLength == 0) {
                    if (recordsAreFixedLength) {
                        Trace.log(2, "System reported recordLength=0 for fixed-length format.");
                    }
                    recordLength = 1188;
                }
                document.setIntValue(programName + ".lengthOfReceiverVariable", totalRecords * recordLength);
                if (!document.callProgram(programName)) {
                    throw new ResourceException(document.getMessageList(programName));
                }
                informationCompleteIndicator = (String)document.getValue(programName + ".listInformation.informationCompleteIndicator");
                if (!informationCompleteIndicator.equals("C")) {
                    document.setIntValue(programName + ".lengthOfReceiverVariable", (totalRecords + 10) * recordLength);
                    if (!document.callProgram(programName)) {
                        throw new ResourceException(document.getMessageList(programName));
                    }
                }
            }
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when calling API.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    @Override
    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values) throws ResourceException {
        super.commitAttributeChanges(attributeIDs, values);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeSetter_.setValues(attributeIDs, values);
    }

    static Object computeResourceKey(AS400 system) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NetServer.class);
        buffer.append(':');
        buffer.append(system.getSystemName());
        return buffer.toString();
    }

    public void end() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(this.getSystem());
            if (!document.callProgram("qzlsends")) {
                throw new ResourceException(document.getMessageList("qzlsends"));
            }
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when ending the NetServer.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        super.establishConnection();
        AS400 system = this.getSystem();
        String userId = system.getUserId();
        if (Trace.isTraceWarningOn()) {
            NetServer.verifyAuthority(system, userId);
        }
        this.document_ = (ProgramCallDocument)staticDocument_.clone();
        this.document_.setSystem(system);
        this.attributeGetter_ = new ProgramAttributeGetter(system, this.document_, getterMap_);
        this.attributeSetter_ = new ProgramAttributeSetter(system, this.document_, setterMap_);
        this.attributeSetter_.initializeAttributeValues(this.attributeGetter_);
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (this.getSystem() == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.getResourceKey() == null) {
            this.setResourceKey(NetServer.computeResourceKey(this.getSystem()));
        }
        super.freezeProperties();
    }

    static ResourceMetaData[] getAttributeMetaDataStatic() {
        return attributes_.getMetaData();
    }

    @Override
    public Object getAttributeUnchangedValue(Object attributeID) throws ResourceException {
        Object value = super.getAttributeUnchangedValue(attributeID);
        if (value == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            value = this.attributeGetter_.getValue(attributeID);
        }
        return value;
    }

    public boolean isStarted() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        RJobList jobList = new RJobList(this.getSystem());
        jobList.setSelectionValue("JOB_NAME", "QZLSSERVER");
        jobList.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
        jobList.open();
        jobList.waitForComplete();
        boolean foundActiveJob = jobList.getListLength() > 0L;
        jobList.close();
        return foundActiveJob;
    }

    private boolean isQserverStarted() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        boolean foundActiveJob = false;
        RJobList jobList = new RJobList(this.getSystem());
        jobList.setSelectionValue("JOB_NAME", "QSERVER");
        jobList.setSelectionValue("USER_NAME", "QSYS");
        jobList.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
        jobList.open();
        jobList.waitForComplete();
        foundActiveJob = jobList.getListLength() > 0L;
        return foundActiveJob;
    }

    public ResourceList listFileShares() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerFileShare.list(this.getSystem());
    }

    public ResourceList listFileShares(String shareName) throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerFileShare.list(this.getSystem(), shareName);
    }

    public ResourceList listPrintShares() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerPrintShare.list(this.getSystem());
    }

    public ResourceList listPrintShares(String shareName) throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerPrintShare.list(this.getSystem(), shareName);
    }

    public ResourceList listSessionConnections() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerConnection.list(this.getSystem(), 1);
    }

    public ResourceList listSessions() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerSession.list(this.getSystem());
    }

    public ResourceList listShareConnections() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerConnection.list(this.getSystem(), 0);
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if (Trace.isTraceWarningOn()) {
            NetServer.verifyAuthority(this.getSystem(), this.getSystem().getUserId());
        }
        this.attributeGetter_.clearBuffer();
        this.attributeSetter_.initializeAttributeValues(this.attributeGetter_);
        super.refreshAttributeValues();
    }

    public void start() throws ResourceException {
        this.start(false);
    }

    public void start(boolean reset) throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if (this.isStarted()) {
            return;
        }
        if (!this.isQserverStarted()) {
            CommandCall cmd = new CommandCall(this.getSystem(), "STRSBS SBSD(QSERVER)");
            boolean started = false;
            try {
                started = cmd.run();
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
            if (!started) {
                Trace.log(2, "Error when starting QSERVER subsystem.");
                throw new ResourceException(cmd.getMessageList());
            }
        }
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(this.getSystem());
            document.setValue("qzlsstrs.resetQualifier", reset ? "1" : "0");
            if (!document.callProgram("qzlsstrs")) {
                throw new ResourceException(document.getMessageList("qzlsstrs"));
            }
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when starting the NetServer.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    static void verifyAuthority(AS400 system, String userId) throws ResourceException {
        RUser user = new RUser(system, userId);
        String[] authorities = (String[])user.getAttributeValue("SPECIAL_AUTHORITIES");
        boolean foundRequiredAuth = false;
        for (int i = 0; i < authorities.length && !foundRequiredAuth; ++i) {
            if (!authorities[i].equals("*IOSYSCFG")) continue;
            foundRequiredAuth = true;
        }
        if (!foundRequiredAuth) {
            Trace.log(4, "User " + userId + " does not have *IOSYSCFG authority.");
        }
    }

    static {
        attributes_.add((Object)ALLOW_SYSTEM_NAME, Boolean.class, true);
        getterMap_.add((Object)ALLOW_SYSTEM_NAME, OLST0201_, "receiverVariable.allowSystemName", BV_MAP_0_1_);
        attributes_.add(ALLOW_SYSTEM_NAME_PENDING, Boolean.class);
        getterMap_.add((Object)ALLOW_SYSTEM_NAME_PENDING, OLST0201_, "receiverVariable.allowSystemNameP", BV_MAP_0_1_);
        setterMap_.add((Object)ALLOW_SYSTEM_NAME_PENDING, "qzlschsn", "allowSystemNameP", BV_MAP_0_1_);
        attributes_.add((Object)AUTHENTICATION_METHOD, Integer.class, true);
        getterMap_.add((Object)AUTHENTICATION_METHOD, OLST0201_, "receiverVariable.authenticationMethod", INTV_MAP_);
        attributes_.add(AUTHENTICATION_METHOD_PENDING, Integer.class);
        getterMap_.add((Object)AUTHENTICATION_METHOD_PENDING, OLST0201_, "receiverVariable.authenticationMethodP", INTV_MAP_);
        setterMap_.add((Object)AUTHENTICATION_METHOD_PENDING, "qzlschsi", "requestVariable.authenticationMethodP", INTV_MAP_);
        attributes_.add(AUTOSTART, Boolean.class);
        getterMap_.add((Object)AUTOSTART, "qtocauto_rtv", "autostart", BV_MAP_NO_ERR_YES_);
        setterMap_.add((Object)AUTOSTART, "qtocauto_chg", "autostart", BV_MAP_NO_YES_);
        attributes_.add((Object)BROWSING_INTERVAL, Integer.class, true);
        getterMap_.add(BROWSING_INTERVAL, OLST0201_, "receiverVariable.browsingInterval");
        attributes_.add(BROWSING_INTERVAL_PENDING, Integer.class);
        getterMap_.add(BROWSING_INTERVAL_PENDING, OLST0201_, "receiverVariable.browsingIntervalP");
        setterMap_.add(BROWSING_INTERVAL_PENDING, "qzlschsi", "requestVariable.browsingIntervalP");
        attributes_.add((Object)CCSID, Integer.class, true);
        getterMap_.add(CCSID, OLST0201_, "receiverVariable.ccsid");
        attributes_.add(CCSID_PENDING, Integer.class);
        getterMap_.add(CCSID_PENDING, OLST0201_, "receiverVariable.ccsidP");
        setterMap_.add(CCSID_PENDING, "qzlschsi", "requestVariable.ccsidP");
        attributes_.add((Object)DESCRIPTION, String.class, true);
        getterMap_.add(DESCRIPTION, OLST0201_, "receiverVariable.description");
        attributes_.add(DESCRIPTION_PENDING, String.class);
        getterMap_.add(DESCRIPTION_PENDING, OLST0201_, "receiverVariable.descriptionP");
        setterMap_.add(DESCRIPTION_PENDING, "qzlschsn", "descriptionP");
        attributes_.add((Object)DOMAIN, String.class, true);
        getterMap_.add(DOMAIN, OLST0201_, "receiverVariable.domainName");
        attributes_.add(DOMAIN_PENDING, String.class);
        getterMap_.add(DOMAIN_PENDING, OLST0201_, "receiverVariable.domainNameP");
        setterMap_.add(DOMAIN_PENDING, "qzlschsn", "domainNameP");
        attributes_.add((Object)GUEST_SUPPORT, Boolean.class, true);
        getterMap_.add((Object)GUEST_SUPPORT, OLST0201_, "receiverVariable.guestSupport", BV_MAP_0_1_INT_);
        attributes_.add((Object)GUEST_SUPPORT_PENDING, Boolean.class, true);
        getterMap_.add((Object)GUEST_SUPPORT_PENDING, OLST0201_, "receiverVariable.guestSupportP", BV_MAP_0_1_INT_);
        attributes_.add((Object)GUEST_USER_PROFILE, String.class, true);
        getterMap_.add(GUEST_USER_PROFILE, OLST0201_, "receiverVariable.guestUserProfile");
        attributes_.add(GUEST_USER_PROFILE_PENDING, String.class);
        getterMap_.add(GUEST_USER_PROFILE_PENDING, OLST0201_, "receiverVariable.guestUserProfileP");
        setterMap_.add(GUEST_USER_PROFILE_PENDING, "qzlschsg", "guestUserProfileP");
        attributes_.add((Object)IDLE_TIMEOUT, Integer.class, true);
        getterMap_.add(IDLE_TIMEOUT, OLST0201_, "receiverVariable.idleTimeOut");
        attributes_.add(IDLE_TIMEOUT_PENDING, Integer.class);
        getterMap_.add(IDLE_TIMEOUT_PENDING, OLST0201_, "receiverVariable.idleTimeOutP");
        setterMap_.add(IDLE_TIMEOUT_PENDING, "qzlschsi", "requestVariable.idleTimeOutP");
        attributes_.add((Object)LOGON_SUPPORT, Boolean.class, true);
        getterMap_.add((Object)LOGON_SUPPORT, OLST0201_, "receiverVariable.serverRole", BV_MAP_0_1_INT_);
        attributes_.add(LOGON_SUPPORT_PENDING, Boolean.class);
        getterMap_.add((Object)LOGON_SUPPORT_PENDING, OLST0201_, "receiverVariable.serverRoleP", BV_MAP_0_1_INT_);
        setterMap_.add((Object)LOGON_SUPPORT_PENDING, "qzlschsi", "requestVariable.serverRoleP", BV_MAP_0_1_INT_);
        attributes_.add((Object)NAME, String.class, true);
        getterMap_.add(NAME, OLST0201_, "receiverVariable.serverName");
        attributes_.add(NAME_PENDING, String.class);
        getterMap_.add(NAME_PENDING, OLST0201_, "receiverVariable.serverNameP");
        setterMap_.add(NAME_PENDING, "qzlschsn", "serverNameP");
        attributes_.add((Object)OPPORTUNISTIC_LOCK_TIMEOUT, Integer.class, true);
        getterMap_.add(OPPORTUNISTIC_LOCK_TIMEOUT, OLST0201_, "receiverVariable.oppLockTimeOut");
        attributes_.add(OPPORTUNISTIC_LOCK_TIMEOUT_PENDING, Integer.class);
        getterMap_.add(OPPORTUNISTIC_LOCK_TIMEOUT_PENDING, OLST0201_, "receiverVariable.oppLockTimeOutP");
        setterMap_.add(OPPORTUNISTIC_LOCK_TIMEOUT_PENDING, "qzlschsi", "requestVariable.oppLockTimeOutP");
        attributes_.add((Object)WINS_ENABLEMENT, Boolean.class, true);
        getterMap_.add((Object)WINS_ENABLEMENT, OLST0201_, "receiverVariable.winsEnablement", BV_MAP_0_1_INT_);
        attributes_.add(WINS_ENABLEMENT_PENDING, Boolean.class);
        getterMap_.add((Object)WINS_ENABLEMENT_PENDING, OLST0201_, "receiverVariable.winsEnablementP", BV_MAP_0_1_INT_);
        setterMap_.add((Object)WINS_ENABLEMENT_PENDING, "qzlschsi", "requestVariable.winsEnablementP", BV_MAP_0_1_);
        attributes_.add((Object)WINS_PRIMARY_ADDRESS, String.class, true);
        getterMap_.add(WINS_PRIMARY_ADDRESS, OLST0201_, "receiverVariable.winsPrimaryAddress");
        attributes_.add(WINS_PRIMARY_ADDRESS_PENDING, String.class);
        getterMap_.add(WINS_PRIMARY_ADDRESS_PENDING, OLST0201_, "receiverVariable.winsPrimaryAddressP");
        setterMap_.add(WINS_PRIMARY_ADDRESS_PENDING, "qzlschsi", "requestVariable.winsPrimaryAddressP");
        attributes_.add((Object)WINS_SCOPE_ID, String.class, true);
        getterMap_.add(WINS_SCOPE_ID, OLST0201_, "receiverVariable.scopeId");
        attributes_.add(WINS_SCOPE_ID_PENDING, String.class);
        getterMap_.add(WINS_SCOPE_ID_PENDING, OLST0201_, "receiverVariable.scopeIdP");
        setterMap_.add(WINS_SCOPE_ID_PENDING, "qzlschsi", "requestVariable.scopeIdP");
        attributes_.add((Object)WINS_SECONDARY_ADDRESS, String.class, true);
        getterMap_.add(WINS_SECONDARY_ADDRESS, OLST0201_, "receiverVariable.winsSecondaryAddress");
        attributes_.add(WINS_SECONDARY_ADDRESS_PENDING, String.class);
        getterMap_.add(WINS_SECONDARY_ADDRESS_PENDING, OLST0201_, "receiverVariable.winsSecondaryAddressP");
        setterMap_.add(WINS_SECONDARY_ADDRESS_PENDING, "qzlschsi", "requestVariable.winsSecondaryAddressP");
        staticDocument_ = null;
        try {
            staticDocument_ = new ProgramCallDocument();
            staticDocument_.setDocument(DOCUMENT_NAME_);
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when instantiating ProgramCallDocument.", (Throwable)e);
        }
    }
}

