/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ServerStartupException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.UnknownHostException;

public class KeyedFile
extends AS400File
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    protected static final int[] TYPE_TABLE = new int[]{11, 13, 12, 9, 10};

    public KeyedFile() {
    }

    public KeyedFile(AS400 system, String name) {
        super(system, name);
    }

    public void setLongRecordNumber(boolean v) {
        this.longRecordNumber = v;
    }

    public void deleteRecord(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        this.impl_.doIt("positionCursorToKey", new Class[]{Object[].class, Integer.TYPE}, new Object[]{key, TYPE_TABLE[0]});
        this.deleteCurrentRecord();
    }

    public void deleteRecord(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorToKeyLong", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{key, TYPE_TABLE[0], numberOfKeyFields});
        } else {
            this.impl_.doIt("positionCursorToKey", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{key, TYPE_TABLE[0], numberOfKeyFields});
        }
        this.deleteCurrentRecord();
    }

    public void positionCursor(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(key, 0);
    }

    public void positionCursor(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(key, 0, numberOfKeyFields);
    }

    public void positionCursor(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (searchType < 0 || searchType > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorLong", new Class[]{Object[].class, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType]});
        } else {
            this.impl_.doIt("positionCursor", new Class[]{Object[].class, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType]});
        }
    }

    public void positionCursor(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (searchType < 0 || searchType > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorLong", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType], numberOfKeyFields});
        } else {
            this.impl_.doIt("positionCursor", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType], numberOfKeyFields});
        }
    }

    public void positionCursorAfter(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorAfterLong", new Class[]{Object[].class}, new Object[]{key});
        } else {
            this.impl_.doIt("positionCursorAfter", new Class[]{Object[].class}, new Object[]{key});
        }
    }

    public void positionCursorAfter(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorAfterLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields});
        } else {
            this.impl_.doIt("positionCursorAfter", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields});
        }
    }

    public void positionCursorBefore(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorBeforeLong", new Class[]{Object[].class}, new Object[]{key});
        } else {
            this.impl_.doIt("positionCursorBefore", new Class[]{Object[].class}, new Object[]{key});
        }
    }

    public void positionCursorBefore(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorBeforeLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields});
        } else {
            this.impl_.doIt("positionCursorBefore", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields});
        }
    }

    public Record read(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        return this.read(key, 0);
    }

    public Record read(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        return this.read(key, 0, numberOfKeyFields);
    }

    public Record read(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (searchType < 0 || searchType > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readLong", new Class[]{Object[].class, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType]}));
        }
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[]{Object[].class, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType]}));
    }

    public Record read(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (searchType < 0 || searchType > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readLong", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType], numberOfKeyFields}));
        }
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{key, TYPE_TABLE[searchType], numberOfKeyFields}));
    }

    public Record readAfter(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readAfterLong", new Class[]{Object[].class}, new Object[]{key}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readAfter", new Class[]{Object[].class}, new Object[]{key}));
    }

    public Record readAfter(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readAfterLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readAfter", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
    }

    @Override
    public Record[] readAll() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, InterruptedException, IOException, ServerStartupException, UnknownHostException {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        this.chooseImpl();
        this.recordFormat_.initializeTextObjects(this.system_);
        int bf = 2048 / (this.recordFormat_.getNewRecord().getRecordLength() + 16);
        if (bf <= 1) {
            bf = 100;
        }
        Record[] recs = null;
        recs = this.longRecordNumber ? this.impl_.doItRecordArray("readAllLong", new Class[]{String.class, Integer.TYPE}, new Object[]{"key", bf}) : this.impl_.doItRecordArray("readAll", new Class[]{String.class, Integer.TYPE}, new Object[]{"key", bf});
        if (recs != null) {
            for (int i = 0; i < recs.length; ++i) {
                recs[i] = this.fillInRecord(recs[i]);
            }
        }
        return recs;
    }

    public Record readBefore(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readBeforeLong", new Class[]{Object[].class}, new Object[]{key}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readBefore", new Class[]{Object[].class}, new Object[]{key}));
    }

    public Record readBefore(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readBeforeLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readBefore", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
    }

    public Record readNextEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readNextEqualLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("readNextEqual", new Class[0], new Object[0]));
    }

    public Record readNextEqual(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readNextEqualLong", new Class[]{Object[].class}, new Object[]{key}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readNextEqual", new Class[]{Object[].class}, new Object[]{key}));
    }

    public Record readNextEqual(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readNextEqualLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readNextEqual", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public Record readPreviousEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readPreviousEqualLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("readPreviousEqual", new Class[0], new Object[0]));
    }

    public Record readPreviousEqual(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(key);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readPreviousEqualLong", new Class[]{Object[].class}, new Object[]{key}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readPreviousEqual", new Class[]{Object[].class}, new Object[]{key}));
    }

    public Record readPreviousEqual(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(key, numberOfKeyFields);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readPreviousEqualLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readPreviousEqual", new Class[]{byte[].class, Integer.TYPE}, new Object[]{key, numberOfKeyFields}));
    }

    public void update(Object[] key, Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(key);
        this.update(record);
    }

    public void update(byte[] key, Record record, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(key, numberOfKeyFields);
        this.update(record);
    }

    public void update(Object[] key, Record record, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(key, searchType);
        this.update(record);
    }

    public void update(byte[] key, Record record, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(key, searchType, numberOfKeyFields);
        this.update(record);
    }

    private void checkParameter(Object[] key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.length == 0) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        if (key.length > this.recordFormat_.getNumberOfKeyFields()) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        for (int i = 0; i < key.length; ++i) {
            if (key[i] != null) continue;
            throw new ExtendedIllegalArgumentException("key", 2);
        }
        this.checkOpen();
    }

    private void checkParameters(byte[] key, int numberOfKeyFields) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.length == 0) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        if (numberOfKeyFields < 1 || numberOfKeyFields > this.recordFormat_.getNumberOfKeyFields()) {
            throw new ExtendedIllegalArgumentException("numberOfKeyFields", 2);
        }
        this.checkOpen();
    }
}

