/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.numberrange;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeRule;

public class NumberRangeSet {
    public static final String MULTI_VALUE_SEPARATOR = ",";
    private List<NumberRangeRule> rules;
    private String fallBackValue;

    public NumberRangeSet(List<NumberRangeRule> rules, String fallBackValue) {
        this.rules = rules;
        this.fallBackValue = fallBackValue;
    }

    protected String evaluateDouble(double value) {
        StringBuilder result = new StringBuilder();
        for (NumberRangeRule rule : this.rules) {
            String ruleResult = rule.evaluate(value);
            if (ruleResult == null) continue;
            if (result.length() > 0) {
                result.append(NumberRangeSet.getMultiValueSeparator());
            }
            result.append(ruleResult);
        }
        return result.toString();
    }

    public static String getMultiValueSeparator() {
        return MULTI_VALUE_SEPARATOR;
    }

    public String evaluate(Double value) throws HopException {
        String result;
        if (value != null && !"".equals(result = this.evaluateDouble(value))) {
            return result;
        }
        return this.fallBackValue;
    }
}

