/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.snowflake.bulkloader;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.snowflake.bulkloader.SnowflakeBulkLoader;
import org.apache.hop.pipeline.transforms.snowflake.bulkloader.SnowflakeBulkLoaderData;
import org.apache.hop.pipeline.transforms.snowflake.bulkloader.SnowflakeBulkLoaderField;

@Transform(id="SnowflakeBulkLoader", image="snowflakebulkloader.svg", name="i18n::SnowflakeBulkLoader.Name", description="i18n::SnowflakeBulkLoader.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Bulk", documentationUrl="/pipeline/transforms/snowflakebulkloader.html", keywords={"i18n::SnowflakeBulkLoader.Keyword"}, classLoaderGroup="snowflake", isIncludeJdbcDrivers=true, actionTransformTypes={ActionTransformType.RDBMS, ActionTransformType.OUTPUT})
public class SnowflakeBulkLoaderMeta
extends BaseTransformMeta<SnowflakeBulkLoader, SnowflakeBulkLoaderData> {
    private static final Class<?> PKG = SnowflakeBulkLoaderMeta.class;
    protected static final String DEBUG_MODE_VAR = "${SNOWFLAKE_DEBUG_MODE}";
    public static final String CSV_DELIMITER = ",";
    public static final String CSV_RECORD_DELIMITER = "\n";
    public static final String CSV_ESCAPE_CHAR = "\\";
    public static final String ENCLOSURE = "\"";
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    public static final String TIMESTAMP_FORMAT_STRING = "YYYY-MM-DD HH24:MI:SS.FF3";
    public static final String[] LOCATION_TYPE_CODES = new String[]{"user", "table", "internal_stage"};
    public static final int LOCATION_TYPE_USER = 0;
    public static final int LOCATION_TYPE_TABLE = 1;
    public static final int LOCATION_TYPE_INTERNAL_STAGE = 2;
    public static final String[] ON_ERROR_CODES = new String[]{"continue", "skip_file", "skip_file_percent", "abort"};
    public static final int ON_ERROR_CONTINUE = 0;
    public static final int ON_ERROR_SKIP_FILE = 1;
    public static final int ON_ERROR_SKIP_FILE_PERCENT = 2;
    public static final int ON_ERROR_ABORT = 3;
    public static final String[] DATA_TYPE_CODES = new String[]{"csv", "json"};
    public static final int DATA_TYPE_CSV = 0;
    public static final int DATA_TYPE_JSON = 1;
    private String fileDate;
    @HopMetadataProperty(key="connection", injectionKeyDescription="", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    @HopMetadataProperty(key="target_schema", injectionKeyDescription="", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SCHEMA)
    private String targetSchema;
    @HopMetadataProperty(key="target_table", injectionKeyDescription="", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TABLE)
    private String targetTable;
    @HopMetadataProperty(key="location_type", injectionKeyDescription="")
    private String locationType;
    @HopMetadataProperty(key="stage_name", injectionKeyDescription="")
    private String stageName;
    @HopMetadataProperty(key="work_directory", injectionKeyDescription="")
    private String workDirectory;
    @HopMetadataProperty(key="on_error", injectionKeyDescription="")
    private String onError;
    @HopMetadataProperty(key="error_limit", injectionKeyDescription="")
    private String errorLimit;
    @HopMetadataProperty(key="split_size", injectionKeyDescription="")
    private String splitSize;
    @HopMetadataProperty(key="remove_files", injectionKeyDescription="")
    private boolean removeFiles;
    @HopMetadataProperty(key="output_target_transform", injectionKeyDescription="")
    private String outputTargetTransform;
    @HopMetadataProperty(key="data_type", injectionKeyDescription="")
    private String dataType;
    @HopMetadataProperty(key="trim_whitespace", injectionKeyDescription="")
    private boolean trimWhitespace;
    @HopMetadataProperty(key="null_if", injectionKeyDescription="")
    private String nullIf;
    @HopMetadataProperty(key="error_column_mismatch", injectionKeyDescription="")
    private boolean errorColumnMismatch;
    @HopMetadataProperty(key="strip_null", injectionKeyDescription="")
    private boolean stripNull;
    @HopMetadataProperty(key="ignore_utf8", injectionKeyDescription="")
    private boolean ignoreUtf8;
    @HopMetadataProperty(key="allow_duplicate_elements", injectionKeyDescription="")
    private boolean allowDuplicateElements;
    @HopMetadataProperty(key="enable_octal", injectionKeyDescription="")
    private boolean enableOctal;
    @HopMetadataProperty(key="specify_fields", injectionKeyDescription="")
    private boolean specifyFields;
    @HopMetadataProperty(key="JSON_FIELD", injectionKeyDescription="")
    private String jsonField;
    @HopMetadataProperty(groupKey="fields", key="field", injectionKey="FIELD", injectionGroupKey="FIELDS", injectionKeyDescription="", injectionGroupDescription="")
    private List<SnowflakeBulkLoaderField> snowflakeBulkLoaderFields = new ArrayList<SnowflakeBulkLoaderField>();

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public void setLocationType(String locationType) throws HopException {
        for (String LOCATION_TYPE_CODE : LOCATION_TYPE_CODES) {
            if (!LOCATION_TYPE_CODE.equals(locationType)) continue;
            this.locationType = locationType;
            return;
        }
        throw new HopException("Invalid location type " + locationType);
    }

    public int getLocationTypeId() {
        for (int i = 0; i < LOCATION_TYPE_CODES.length; ++i) {
            if (!LOCATION_TYPE_CODES[i].equals(this.locationType)) continue;
            return i;
        }
        return -1;
    }

    public void setLocationTypeById(int locationTypeId) {
        this.locationType = LOCATION_TYPE_CODES[locationTypeId];
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) throws HopException {
        for (String ON_ERROR_CODE : ON_ERROR_CODES) {
            if (!ON_ERROR_CODE.equals(onError)) continue;
            this.onError = onError;
            return;
        }
        throw new HopException("Invalid on error code " + onError);
    }

    public int getOnErrorId() {
        for (int i = 0; i < ON_ERROR_CODES.length; ++i) {
            if (!ON_ERROR_CODES[i].equals(this.onError)) continue;
            return i;
        }
        return -1;
    }

    public void setOnErrorById(int onErrorId) {
        this.onError = ON_ERROR_CODES[onErrorId];
    }

    public String getErrorLimit() {
        return this.errorLimit;
    }

    public void setErrorLimit(String errorLimit) {
        this.errorLimit = errorLimit;
    }

    public String getSplitSize() {
        return this.splitSize;
    }

    public void setSplitSize(String splitSize) {
        this.splitSize = splitSize;
    }

    public boolean isRemoveFiles() {
        return this.removeFiles;
    }

    public void setRemoveFiles(boolean removeFiles) {
        this.removeFiles = removeFiles;
    }

    public String getOutputTargetTransform() {
        return this.outputTargetTransform;
    }

    public void setOutputTargetTransform(String outputTargetTransform) {
        this.outputTargetTransform = outputTargetTransform;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) throws HopException {
        for (String DATA_TYPE_CODE : DATA_TYPE_CODES) {
            if (!DATA_TYPE_CODE.equals(dataType)) continue;
            this.dataType = dataType;
            return;
        }
        throw new HopException("Invalid data type " + dataType);
    }

    public int getDataTypeId() {
        for (int i = 0; i < DATA_TYPE_CODES.length; ++i) {
            if (!DATA_TYPE_CODES[i].equals(this.dataType)) continue;
            return i;
        }
        return -1;
    }

    public void setDataTypeById(int dataTypeId) {
        this.dataType = DATA_TYPE_CODES[dataTypeId];
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public String getNullIf() {
        return this.nullIf;
    }

    public void setNullIf(String nullIf) {
        this.nullIf = nullIf;
    }

    public boolean isErrorColumnMismatch() {
        return this.errorColumnMismatch;
    }

    public void setErrorColumnMismatch(boolean errorColumnMismatch) {
        this.errorColumnMismatch = errorColumnMismatch;
    }

    public boolean isStripNull() {
        return this.stripNull;
    }

    public void setStripNull(boolean stripNull) {
        this.stripNull = stripNull;
    }

    public boolean isIgnoreUtf8() {
        return this.ignoreUtf8;
    }

    public void setIgnoreUtf8(boolean ignoreUtf8) {
        this.ignoreUtf8 = ignoreUtf8;
    }

    public boolean isAllowDuplicateElements() {
        return this.allowDuplicateElements;
    }

    public void setAllowDuplicateElements(boolean allowDuplicateElements) {
        this.allowDuplicateElements = allowDuplicateElements;
    }

    public boolean isEnableOctal() {
        return this.enableOctal;
    }

    public void setEnableOctal(boolean enableOctal) {
        this.enableOctal = enableOctal;
    }

    public boolean isSpecifyFields() {
        return this.specifyFields;
    }

    public void setSpecifyFields(boolean specifyFields) {
        this.specifyFields = specifyFields;
    }

    public String getJsonField() {
        return this.jsonField;
    }

    public void setJsonField(String jsonField) {
        this.jsonField = jsonField;
    }

    public List<SnowflakeBulkLoaderField> getSnowflakeBulkLoaderFields() {
        return this.snowflakeBulkLoaderFields;
    }

    public void setSnowflakeBulkLoaderFields(List<SnowflakeBulkLoaderField> snowflakeBulkLoaderFields) {
        this.snowflakeBulkLoaderFields = snowflakeBulkLoaderFields;
    }

    public String getFileDate() {
        return this.fileDate;
    }

    public Object clone() {
        return super.clone();
    }

    public void setDefault() {
        this.locationType = LOCATION_TYPE_CODES[0];
        this.workDirectory = "${java.io.tmpdir}";
        this.onError = ON_ERROR_CODES[3];
        this.removeFiles = true;
        this.dataType = DATA_TYPE_CODES[0];
        this.trimWhitespace = false;
        this.errorColumnMismatch = true;
        this.stripNull = false;
        this.ignoreUtf8 = false;
        this.allowDuplicateElements = false;
        this.enableOctal = false;
        this.splitSize = "20000";
        this.specifyFields = false;
    }

    public String buildFilename(IVariables variables, int transformNumber, String partNumber, int splitNumber) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String realWorkDirectory = variables.resolve(this.workDirectory);
        String extension = ".gz";
        StringBuilder returnValue = new StringBuilder(realWorkDirectory);
        if (!realWorkDirectory.endsWith("/") && !realWorkDirectory.endsWith(CSV_ESCAPE_CHAR)) {
            returnValue.append(Const.FILE_SEPARATOR);
        }
        returnValue.append(this.targetTable).append("_");
        if (this.fileDate == null) {
            Date now = new Date();
            daf.applyPattern("yyyyMMdd_HHmmss");
            this.fileDate = daf.format(now);
        }
        returnValue.append(this.fileDate).append("_");
        returnValue.append(transformNumber).append("_");
        returnValue.append(partNumber).append("_");
        returnValue.append(splitNumber);
        returnValue.append(extension);
        return returnValue.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoadMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (SnowflakeBulkLoaderField snowflakeBulkLoaderField : this.snowflakeBulkLoaderFields) {
                int idx = prev.indexOfValue(snowflakeBulkLoaderField.getStreamField());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + snowflakeBulkLoaderField.getStreamField() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SnowflakeBulkLoadMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoadMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoadMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoadMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        for (SnowflakeBulkLoaderField snowflakeBulkLoaderField : this.snowflakeBulkLoaderFields) {
            try {
                snowflakeBulkLoaderField.validate();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoadMeta.CheckResult.MappingValid", (String[])new String[]{snowflakeBulkLoaderField.getStreamField()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException ex) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoadMeta.CheckResult.MappingNotValid", (String[])new String[]{snowflakeBulkLoaderField.getStreamField()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.targetTable);
        String realSchemaName = variables.resolve(this.targetSchema);
        if (this.connection == null) throw new HopException(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        Database db = new Database(loggingObject, variables, databaseMeta);
        try {
            db.connect();
            if (StringUtils.isEmpty((String)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFields(schemaTable);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public ITransformData getTransformData() {
        return new SnowflakeBulkLoaderData();
    }

    public String getStage(IVariables variables) {
        if (this.locationType.equals(LOCATION_TYPE_CODES[0])) {
            return "@~/" + variables.resolve(this.targetTable);
        }
        if (this.locationType.equals(LOCATION_TYPE_CODES[1])) {
            if (!StringUtils.isEmpty((String)variables.resolve(this.targetSchema))) {
                return "@" + variables.resolve(this.targetSchema) + ".%" + variables.resolve(this.targetTable);
            }
            return "@%" + variables.resolve(this.targetTable);
        }
        if (this.locationType.equals(LOCATION_TYPE_CODES[2])) {
            if (!StringUtils.isEmpty((String)variables.resolve(this.targetSchema))) {
                return "@" + variables.resolve(this.targetSchema) + "." + variables.resolve(this.stageName);
            }
            return "@" + variables.resolve(this.stageName);
        }
        return null;
    }

    public String getCopyStatement(IVariables variables, List<String> filenames) throws HopFileException {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("COPY INTO ");
        if (!StringUtils.isEmpty((String)variables.resolve(this.targetSchema))) {
            returnValue.append(variables.resolve(this.targetSchema)).append(".");
        }
        returnValue.append(variables.resolve(this.targetTable)).append(" ");
        returnValue.append("FROM ").append(this.getStage(variables)).append("/ ");
        returnValue.append("FILES = (");
        boolean first = true;
        for (String filename : filenames) {
            String shortFile = HopVfs.getFileObject((String)filename, (IVariables)variables).getName().getBaseName();
            if (first) {
                returnValue.append("'");
                first = false;
            } else {
                returnValue.append(",'");
            }
            returnValue.append(shortFile).append("' ");
        }
        returnValue.append(") ");
        returnValue.append("FILE_FORMAT = ( TYPE = ");
        if (this.dataType.equals(DATA_TYPE_CODES[0])) {
            returnValue.append("'CSV' FIELD_DELIMITER = ',' RECORD_DELIMITER = '\\n' ESCAPE = '\\\\' ");
            returnValue.append("ESCAPE_UNENCLOSED_FIELD = '\\\\' FIELD_OPTIONALLY_ENCLOSED_BY='\"' ");
            returnValue.append("SKIP_HEADER = 0 DATE_FORMAT = '").append(DATE_FORMAT_STRING).append("' ");
            returnValue.append("TIMESTAMP_FORMAT = '").append(TIMESTAMP_FORMAT_STRING).append("' ");
            returnValue.append("TRIM_SPACE = ").append(this.trimWhitespace).append(" ");
            if (!StringUtils.isEmpty((String)this.nullIf)) {
                returnValue.append("NULL_IF = (");
                String[] nullIfStrings = variables.resolve(this.nullIf).split(CSV_DELIMITER);
                boolean firstNullIf = true;
                for (String nullIfString : nullIfStrings) {
                    nullIfString = nullIfString.replaceAll("'", "''");
                    if (firstNullIf) {
                        firstNullIf = false;
                        returnValue.append("'");
                    } else {
                        returnValue.append(", '");
                    }
                    returnValue.append(nullIfString).append("'");
                }
                returnValue.append(" ) ");
            }
            returnValue.append("ERROR_ON_COLUMN_COUNT_MISMATCH = ").append(this.errorColumnMismatch).append(" ");
            returnValue.append("COMPRESSION = 'GZIP' ");
        } else if (this.dataType.equals(DATA_TYPE_CODES[1])) {
            returnValue.append("'JSON' COMPRESSION = 'GZIP' STRIP_OUTER_ARRAY = FALSE ");
            returnValue.append("ENABLE_OCTAL = ").append(this.enableOctal).append(" ");
            returnValue.append("ALLOW_DUPLICATE = ").append(this.allowDuplicateElements).append(" ");
            returnValue.append("STRIP_NULL_VALUES = ").append(this.stripNull).append(" ");
            returnValue.append("IGNORE_UTF8_ERRORS = ").append(this.ignoreUtf8).append(" ");
        }
        returnValue.append(") ");
        returnValue.append("ON_ERROR = ");
        if (this.onError.equals(ON_ERROR_CODES[3])) {
            returnValue.append("'ABORT_STATEMENT' ");
        } else if (this.onError.equals(ON_ERROR_CODES[0])) {
            returnValue.append("'CONTINUE' ");
        } else if (this.onError.equals(ON_ERROR_CODES[1]) || this.onError.equals(ON_ERROR_CODES[2])) {
            if (Const.toDouble((String)variables.resolve(this.errorLimit), (double)0.0) <= 0.0) {
                returnValue.append("'SKIP_FILE' ");
            } else {
                returnValue.append("'SKIP_FILE_").append(Const.toInt((String)variables.resolve(this.errorLimit), (int)0));
            }
            if (this.onError.equals(ON_ERROR_CODES[2])) {
                returnValue.append("%' ");
            } else {
                returnValue.append("' ");
            }
        }
        if (!Boolean.getBoolean(variables.resolve(DEBUG_MODE_VAR))) {
            returnValue.append("PURGE = ").append(this.removeFiles).append(" ");
        }
        returnValue.append(";");
        return returnValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        DatabaseMeta databaseMeta = pipelineMeta.findDatabase(this.connection, variables);
        SqlStatement retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
        if (databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Utils.isEmpty((CharSequence)this.targetTable)) {
                    Database db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.targetSchema, this.targetTable);
                        String crTable = db.getDDL(schemaTable, prev, null, false, null);
                        if (crTable == null || crTable.length() == 0) {
                            crTable = null;
                        }
                        retval.setSql(crTable);
                    }
                    catch (HopDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
        return retval;
    }
}

