/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforcedelete;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforcedelete.SalesforceDelete;
import org.apache.hop.pipeline.transforms.salesforcedelete.SalesforceDeleteData;
import org.w3c.dom.Node;

@Transform(id="SalesforceDelete", name="i18n::SalesforceDelete.TypeLongDesc.SalesforceDelete", description="i18n::SalesforceDelete.TypeTooltipDesc.SalesforceDelete", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", image="SFD.svg", keywords={"i18n::SalesforceDeleteMeta.keyword"}, documentationUrl="/pipeline/transforms/salesforcedelete.html")
public class SalesforceDeleteMeta
extends SalesforceTransformMeta<SalesforceDelete, SalesforceDeleteData> {
    private static final Class<?> PKG = SalesforceDeleteMeta.class;
    private String deleteField;
    private String batchSize;
    private boolean rollbackAllChangesOnError;

    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public int getBatchSizeInt() {
        return Const.toInt((String)this.batchSize, (int)10);
    }

    @Override
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        this.readData(transformNode);
    }

    @Override
    public Object clone() {
        SalesforceDeleteMeta retval = (SalesforceDeleteMeta)((Object)super.clone());
        return retval;
    }

    @Override
    public String getXml() {
        StringBuilder retval = new StringBuilder(super.getXml());
        retval.append("    " + XmlHandler.addTagValue((String)"DeleteField", (String)this.getDeleteField()));
        retval.append("    " + XmlHandler.addTagValue((String)"batchSize", (String)this.getBatchSize()));
        retval.append("    " + XmlHandler.addTagValue((String)"rollbackAllChangesOnError", (boolean)this.isRollbackAllChangesOnError()));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.setDeleteField(XmlHandler.getTagValue((Node)transformNode, (String)"DeleteField"));
            this.setBatchSize(XmlHandler.getTagValue((Node)transformNode, (String)"batchSize"));
            this.setRollbackAllChangesOnError("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rollbackAllChangesOnError")));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setModule("Account");
        this.setDeleteField(null);
        this.setBatchSize("10");
        this.setRollbackAllChangesOnError(false);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    @Override
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        super.check(remarks, pipelineMeta, transformMeta, prev, input, output, info, variables, metadataProvider);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceDeleteMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

