/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data.transfer.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.transfer.HCatWriter;
import org.apache.hive.hcatalog.data.transfer.WriteEntity;
import org.apache.hive.hcatalog.data.transfer.WriterContext;
import org.apache.hive.hcatalog.data.transfer.impl.WriterContextImpl;
import org.apache.hive.hcatalog.data.transfer.state.StateProvider;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;

public class HCatOutputFormatWriter
extends HCatWriter {
    public HCatOutputFormatWriter(WriteEntity we, Map<String, String> config) {
        super(we, config);
    }

    public HCatOutputFormatWriter(WriterContext cntxt, StateProvider sp) {
        super(((WriterContextImpl)cntxt).getConf(), sp);
    }

    @Override
    public WriterContext prepareWrite() throws HCatException {
        Job job;
        OutputJobInfo jobInfo = OutputJobInfo.create(this.we.getDbName(), this.we.getTableName(), this.we.getPartitionKVs());
        try {
            job = new Job(this.conf);
            HCatOutputFormat.setOutput(job, jobInfo);
            HCatOutputFormat.setSchema(job, HCatOutputFormat.getTableSchema(job.getConfiguration()));
            HCatOutputFormat outFormat = new HCatOutputFormat();
            outFormat.checkOutputSpecs((JobContext)job);
            outFormat.getOutputCommitter(ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptContext(job.getConfiguration(), ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptID())).setupJob((JobContext)job);
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        WriterContextImpl cntxt = new WriterContextImpl();
        cntxt.setConf(job.getConfiguration());
        return cntxt;
    }

    @Override
    public void write(Iterator<HCatRecord> recordItr) throws HCatException {
        int id = this.sp.getId();
        this.setVarsInConf(id);
        HCatOutputFormat outFormat = new HCatOutputFormat();
        TaskAttemptContext cntxt = ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptContext(this.conf, new TaskAttemptID(ShimLoader.getHadoopShims().getHCatShim().createTaskID(), id));
        OutputCommitter committer = null;
        try {
            committer = outFormat.getOutputCommitter(cntxt);
            committer.setupTask(cntxt);
            RecordWriter<WritableComparable<?>, HCatRecord> writer = outFormat.getRecordWriter(cntxt);
            while (recordItr.hasNext()) {
                HCatRecord rec = recordItr.next();
                writer.write(null, (Object)rec);
            }
            writer.close(cntxt);
            if (committer.needsTaskCommit(cntxt)) {
                committer.commitTask(cntxt);
            }
        }
        catch (IOException e) {
            if (null != committer) {
                try {
                    committer.abortTask(cntxt);
                }
                catch (IOException e1) {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, (Throwable)e1);
                }
            }
            throw new HCatException("Failed while writing", (Throwable)e);
        }
        catch (InterruptedException e) {
            if (null != committer) {
                try {
                    committer.abortTask(cntxt);
                }
                catch (IOException e1) {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, (Throwable)e1);
                }
            }
            throw new HCatException("Failed while writing", (Throwable)e);
        }
    }

    @Override
    public void commit(WriterContext context) throws HCatException {
        WriterContextImpl cntxtImpl = (WriterContextImpl)context;
        try {
            new HCatOutputFormat().getOutputCommitter(ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptContext(cntxtImpl.getConf(), ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptID())).commitJob(ShimLoader.getHadoopShims().getHCatShim().createJobContext(cntxtImpl.getConf(), null));
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
    }

    @Override
    public void abort(WriterContext context) throws HCatException {
        WriterContextImpl cntxtImpl = (WriterContextImpl)context;
        try {
            new HCatOutputFormat().getOutputCommitter(ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptContext(cntxtImpl.getConf(), ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptID())).abortJob(ShimLoader.getHadoopShims().getHCatShim().createJobContext(cntxtImpl.getConf(), null), JobStatus.State.FAILED);
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
    }

    private void setVarsInConf(int id) {
        this.conf.setInt("mapred.task.partition", id);
        this.conf.set("mapred.task.id", "attempt__0000_r_000000_" + id);
    }
}

