/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatAuthUtil;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;
import org.apache.hive.hcatalog.common.HCatUtil;

final class CreateTableHook
extends HCatSemanticAnalyzerBase {
    private String tableName;

    CreateTableHook() {
    }

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        Hive db;
        try {
            db = context.getHive();
        }
        catch (HiveException e) {
            throw new SemanticException("Couldn't get Hive DB instance in semantic analysis phase.", (Throwable)e);
        }
        int numCh = ast.getChildCount();
        this.tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)((ASTNode)ast.getChild(0)));
        boolean likeTable = false;
        StorageFormat format = new StorageFormat(context.getConf());
        block11: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            if (format.fillStorageFormat(child)) {
                if (!StringUtils.isNotEmpty((String)format.getStorageHandler())) continue;
                return ast;
            }
            switch (child.getToken().getType()) {
                case 954: {
                    throw new SemanticException("Operation not supported. Create table as Select is not a valid operation.");
                }
                case 723: {
                    continue block11;
                }
                case 885: {
                    likeTable = true;
                    continue block11;
                }
                case 856: {
                    try {
                        List tables = db.getTablesByPattern(this.tableName);
                        if (tables == null || tables.size() <= 0) continue block11;
                        return ast;
                    }
                    catch (HiveException e) {
                        throw new SemanticException((Throwable)e);
                    }
                }
                case 1045: {
                    List partCols = BaseSemanticAnalyzer.getColumns((ASTNode)child, (boolean)false, (Configuration)context.getConf());
                    for (FieldSchema fs : partCols) {
                        if (fs.getType().equalsIgnoreCase("string")) continue;
                        throw new SemanticException("Operation not supported. HCatalog only supports partition columns of type string. For column: " + fs.getName() + " Found type: " + fs.getType());
                    }
                    continue block11;
                }
            }
        }
        if (!(likeTable || format.getInputFormat() != null && format.getOutputFormat() != null)) {
            throw new SemanticException("STORED AS specification is either incomplete or incorrect.");
        }
        return ast;
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        String storageHandler;
        if (rootTasks.size() == 0) {
            return;
        }
        CreateTableDesc desc = ((DDLWork)((DDLTask)rootTasks.get(rootTasks.size() - 1)).getWork()).getCreateTblDesc();
        if (desc == null) {
            return;
        }
        HashMap tblProps = desc.getTblProps();
        if (tblProps == null) {
            tblProps = new HashMap();
        }
        if (!StringUtils.isEmpty((String)(storageHandler = desc.getStorageHandler()))) {
            try {
                HiveStorageHandler hiveStorageHandler = HCatUtil.getStorageHandler(context.getConf(), desc.getStorageHandler(), desc.getSerName(), desc.getInputFormat(), desc.getOutputFormat());
            }
            catch (IOException e) {
                throw new SemanticException((Throwable)e);
            }
        }
        if (desc != null) {
            try {
                Table table = context.getHive().newTable(desc.getTableName());
                if (desc.getLocation() != null) {
                    table.setDataLocation(new Path(desc.getLocation()));
                }
                if (desc.getStorageHandler() != null) {
                    table.setProperty("storage_handler", desc.getStorageHandler());
                }
                for (Map.Entry prop : tblProps.entrySet()) {
                    table.setProperty((String)prop.getKey(), (String)prop.getValue());
                }
                for (Map.Entry prop : desc.getSerdeProps().entrySet()) {
                    table.setSerdeParam((String)prop.getKey(), (String)prop.getValue());
                }
                if (HCatAuthUtil.isAuthorizationEnabled(context.getConf())) {
                    this.authorize(table, Privilege.CREATE);
                }
            }
            catch (HiveException ex) {
                throw new SemanticException((Throwable)ex);
            }
        }
        desc.setTblProps(tblProps);
        context.getConf().set("hcat.create.tbl.name", this.tableName);
    }
}

