/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hop.core.Const;
import org.apache.hop.core.compress.CompressionOutputStream;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.util.Utils;

public class ZipCompressionOutputStream
extends CompressionOutputStream {
    public ZipCompressionOutputStream(OutputStream out, ICompressionProvider provider) {
        super(ZipCompressionOutputStream.getDelegate(out), provider);
    }

    protected static ZipOutputStream getDelegate(OutputStream out) {
        ZipOutputStream zipOutputStream;
        ZipOutputStream delegate = out instanceof ZipOutputStream ? (zipOutputStream = (ZipOutputStream)out) : new ZipOutputStream(out);
        return delegate;
    }

    @Override
    public void close() throws IOException {
        ZipOutputStream zos = (ZipOutputStream)this.delegate;
        zos.flush();
        zos.closeEntry();
        zos.finish();
        zos.close();
    }

    @Override
    public void addEntry(String filename, String extension) throws IOException {
        int index = filename.lastIndexOf(Const.FILE_SEPARATOR);
        Object entryPath = index != -1 ? filename.substring(index + 1) : filename;
        index = ((String)entryPath).toLowerCase().lastIndexOf(".zip");
        if (index != -1) {
            entryPath = ((String)entryPath).substring(0, index) + ((String)entryPath).substring(index + ".zip".length());
        }
        if (!Utils.isEmpty((CharSequence)extension)) {
            entryPath = (String)entryPath + "." + extension;
        }
        ZipEntry zipentry = new ZipEntry((String)entryPath);
        zipentry.setComment("Compressed by Hop");
        ((ZipOutputStream)this.delegate).putNextEntry(zipentry);
    }
}

