/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;

public class HttpPipelineCallState {
    private static final ClientLogger LOGGER = new ClientLogger(HttpPipelineCallState.class);
    private final HttpPipeline pipeline;
    private final HttpPipelineCallContext callContext;
    private int currentPolicyIndex;

    public HttpPipelineCallState(HttpPipeline pipeline, HttpPipelineCallContext callContext) {
        this.pipeline = pipeline;
        this.callContext = callContext;
        this.currentPolicyIndex = -1;
    }

    public HttpPipelinePolicy getNextPolicy() {
        int size = this.pipeline.getPolicyCount();
        ++this.currentPolicyIndex;
        if (this.currentPolicyIndex > size) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("There is no more policies to execute."));
        }
        if (this.currentPolicyIndex == size) {
            return null;
        }
        return this.pipeline.getPolicy(this.currentPolicyIndex);
    }

    public HttpPipeline getPipeline() {
        return this.pipeline;
    }

    public HttpPipelinePolicy getCurrentPolicy() {
        return this.pipeline.getPolicy(this.currentPolicyIndex);
    }

    public HttpPipelineCallContext getCallContext() {
        return this.callContext;
    }

    public HttpPipelineCallState clone() {
        HttpPipelineCallState cloned = new HttpPipelineCallState(this.pipeline, this.callContext);
        cloned.currentPolicyIndex = this.currentPolicyIndex;
        return cloned;
    }
}

