/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.OperatorIDPair;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputOutputFormatContainer;
import org.apache.flink.runtime.jobgraph.InputOutputFormatVertex;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalPipelinedRegion;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalTopology;
import org.apache.flink.runtime.jobgraph.topology.LogicalVertex;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroupImpl;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.config.memory.ManagedMemoryUtils;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.checkpoint.WithMasterCheckpointHook;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.graph.FunctionMasterCheckpointHookFactory;
import org.apache.flink.streaming.api.graph.NonChainedOutput;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphHasher;
import org.apache.flink.streaming.api.graph.StreamGraphHasherV2;
import org.apache.flink.streaming.api.graph.StreamGraphUserHashHasher;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.SourceOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.UdfStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.streaming.runtime.partitioner.CustomPartitionerWrapper;
import org.apache.flink.streaming.runtime.partitioner.ForwardForConsecutiveHashPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardForUnspecifiedPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RescalePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.StreamIterationHead;
import org.apache.flink.streaming.runtime.tasks.StreamIterationTail;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamingJobGraphGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingJobGraphGenerator.class);
    private final ClassLoader userClassloader;
    private final StreamGraph streamGraph;
    private final Map<Integer, JobVertex> jobVertices;
    private final JobGraph jobGraph;
    private final Collection<Integer> builtVertices;
    private final List<StreamEdge> physicalEdgesInOrder;
    private final Map<Integer, Map<Integer, StreamConfig>> chainedConfigs;
    private final Map<Integer, StreamConfig> vertexConfigs;
    private final Map<Integer, String> chainedNames;
    private final Map<Integer, ResourceSpec> chainedMinResources;
    private final Map<Integer, ResourceSpec> chainedPreferredResources;
    private final Map<Integer, InputOutputFormatContainer> chainedInputOutputFormats;
    private final StreamGraphHasher defaultStreamGraphHasher;
    private final List<StreamGraphHasher> legacyStreamGraphHashers;
    private boolean hasHybridResultPartition = false;
    private final Executor serializationExecutor;
    private final Map<JobVertexID, List<CompletableFuture<SerializedValue<OperatorCoordinator.Provider>>>> coordinatorSerializationFuturesPerJobVertex = new HashMap<JobVertexID, List<CompletableFuture<SerializedValue<OperatorCoordinator.Provider>>>>();
    private final Map<Integer, Map<StreamEdge, NonChainedOutput>> opIntermediateOutputs;

    @VisibleForTesting
    public static JobGraph createJobGraph(StreamGraph streamGraph) {
        return new StreamingJobGraphGenerator(Thread.currentThread().getContextClassLoader(), streamGraph, null, Runnable::run).createJobGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobGraph createJobGraph(ClassLoader userClassLoader, StreamGraph streamGraph, @Nullable JobID jobID) {
        ExecutorService serializationExecutor = Executors.newFixedThreadPool(Math.max(1, Math.min(Hardware.getNumberCPUCores(), streamGraph.getExecutionConfig().getParallelism())), (ThreadFactory)new ExecutorThreadFactory("flink-operator-serialization-io"));
        try {
            JobGraph jobGraph = new StreamingJobGraphGenerator(userClassLoader, streamGraph, jobID, serializationExecutor).createJobGraph();
            return jobGraph;
        }
        finally {
            serializationExecutor.shutdown();
        }
    }

    private StreamingJobGraphGenerator(ClassLoader userClassloader, StreamGraph streamGraph, @Nullable JobID jobID, Executor serializationExecutor) {
        this.userClassloader = userClassloader;
        this.streamGraph = streamGraph;
        this.defaultStreamGraphHasher = new StreamGraphHasherV2();
        this.legacyStreamGraphHashers = Arrays.asList(new StreamGraphUserHashHasher());
        this.jobVertices = new HashMap<Integer, JobVertex>();
        this.builtVertices = new HashSet<Integer>();
        this.chainedConfigs = new HashMap<Integer, Map<Integer, StreamConfig>>();
        this.vertexConfigs = new HashMap<Integer, StreamConfig>();
        this.chainedNames = new HashMap<Integer, String>();
        this.chainedMinResources = new HashMap<Integer, ResourceSpec>();
        this.chainedPreferredResources = new HashMap<Integer, ResourceSpec>();
        this.chainedInputOutputFormats = new HashMap<Integer, InputOutputFormatContainer>();
        this.physicalEdgesInOrder = new ArrayList<StreamEdge>();
        this.serializationExecutor = (Executor)Preconditions.checkNotNull((Object)serializationExecutor);
        this.opIntermediateOutputs = new HashMap<Integer, Map<StreamEdge, NonChainedOutput>>();
        this.jobGraph = new JobGraph(jobID, streamGraph.getJobName());
    }

    private JobGraph createJobGraph() {
        this.preValidate();
        this.jobGraph.setJobType(this.streamGraph.getJobType());
        this.jobGraph.enableApproximateLocalRecovery(this.streamGraph.getCheckpointConfig().isApproximateLocalRecoveryEnabled());
        Map<Integer, byte[]> hashes = this.defaultStreamGraphHasher.traverseStreamGraphAndGenerateHashes(this.streamGraph);
        ArrayList<Map<Integer, byte[]>> legacyHashes = new ArrayList<Map<Integer, byte[]>>(this.legacyStreamGraphHashers.size());
        for (StreamGraphHasher streamGraphHasher : this.legacyStreamGraphHashers) {
            legacyHashes.add(streamGraphHasher.traverseStreamGraphAndGenerateHashes(this.streamGraph));
        }
        this.setChaining(hashes, legacyHashes);
        this.setPhysicalEdges();
        this.markContainsSourcesOrSinks();
        this.setSlotSharingAndCoLocation();
        StreamingJobGraphGenerator.setManagedMemoryFraction(Collections.unmodifiableMap(this.jobVertices), Collections.unmodifiableMap(this.vertexConfigs), Collections.unmodifiableMap(this.chainedConfigs), id -> this.streamGraph.getStreamNode((Integer)id).getManagedMemoryOperatorScopeUseCaseWeights(), id -> this.streamGraph.getStreamNode((Integer)id).getManagedMemorySlotScopeUseCases());
        this.configureCheckpointing();
        this.jobGraph.setSavepointRestoreSettings(this.streamGraph.getSavepointRestoreSettings());
        Map distributedCacheEntries = JobGraphUtils.prepareUserArtifactEntries(this.streamGraph.getUserArtifacts().stream().collect(Collectors.toMap(e -> (String)e.f0, e -> (DistributedCache.DistributedCacheEntry)e.f1)), (JobID)this.jobGraph.getJobID());
        for (Map.Entry entry : distributedCacheEntries.entrySet()) {
            this.jobGraph.addUserArtifact((String)entry.getKey(), (DistributedCache.DistributedCacheEntry)entry.getValue());
        }
        try {
            this.jobGraph.setExecutionConfig(this.streamGraph.getExecutionConfig());
        }
        catch (IOException iOException) {
            throw new IllegalConfigurationException("Could not serialize the ExecutionConfig.This indicates that non-serializable types (like custom serializers) were registered");
        }
        this.jobGraph.setChangelogStateBackendEnabled(this.streamGraph.isChangelogStateBackendEnabled());
        this.addVertexIndexPrefixInVertexName();
        this.setVertexDescription();
        try {
            FutureUtils.combineAll((Collection)this.vertexConfigs.values().stream().map(config -> config.triggerSerializationAndReturnFuture(this.serializationExecutor)).collect(Collectors.toList())).get();
            this.waitForSerializationFuturesAndUpdateJobVertices();
        }
        catch (Exception exception) {
            throw new FlinkRuntimeException("Error in serialization.", (Throwable)exception);
        }
        if (!this.streamGraph.getJobStatusHooks().isEmpty()) {
            this.jobGraph.setJobStatusHooks(this.streamGraph.getJobStatusHooks());
        }
        return this.jobGraph;
    }

    private void waitForSerializationFuturesAndUpdateJobVertices() throws ExecutionException, InterruptedException {
        for (Map.Entry<JobVertexID, List<CompletableFuture<SerializedValue<OperatorCoordinator.Provider>>>> futuresPerJobVertex : this.coordinatorSerializationFuturesPerJobVertex.entrySet()) {
            JobVertexID jobVertexId = futuresPerJobVertex.getKey();
            JobVertex jobVertex = this.jobGraph.findVertexByID(jobVertexId);
            Preconditions.checkState((jobVertex != null ? 1 : 0) != 0, (String)"OperatorCoordinator providers were registered for JobVertexID '%s' but no corresponding JobVertex can be found.", (Object[])new Object[]{jobVertexId});
            ((Collection)FutureUtils.combineAll((Collection)futuresPerJobVertex.getValue()).get()).forEach(arg_0 -> ((JobVertex)jobVertex).addOperatorCoordinator(arg_0));
        }
    }

    private void addVertexIndexPrefixInVertexName() {
        if (!this.streamGraph.isVertexNameIncludeIndexPrefix()) {
            return;
        }
        AtomicInteger vertexIndexId = new AtomicInteger(0);
        this.jobGraph.getVerticesSortedTopologicallyFromSources().forEach(vertex -> vertex.setName(String.format("[vertex-%d]%s", vertexIndexId.getAndIncrement(), vertex.getName())));
    }

    private void setVertexDescription() {
        for (Map.Entry<Integer, JobVertex> headOpAndJobVertex : this.jobVertices.entrySet()) {
            Integer headOpId = headOpAndJobVertex.getKey();
            JobVertex vertex = headOpAndJobVertex.getValue();
            StringBuilder builder = new StringBuilder();
            switch (this.streamGraph.getVertexDescriptionMode()) {
                case CASCADING: {
                    this.buildCascadingDescription(builder, headOpId, headOpId);
                    break;
                }
                case TREE: {
                    this.buildTreeDescription(builder, headOpId, headOpId, "", true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Description mode %s not supported", this.streamGraph.getVertexDescriptionMode()));
                }
            }
            vertex.setOperatorPrettyName(builder.toString());
        }
    }

    private void buildCascadingDescription(StringBuilder builder, int headOpId, int currentOpId) {
        boolean multiOutput;
        StreamNode node = this.streamGraph.getStreamNode(currentOpId);
        builder.append(this.getDescriptionWithChainedSourcesInfo(node));
        LinkedList<Integer> chainedOutput = this.getChainedOutputNodes(headOpId, node);
        if (chainedOutput.isEmpty()) {
            return;
        }
        builder.append(" -> ");
        boolean bl = multiOutput = chainedOutput.size() > 1;
        if (multiOutput) {
            builder.append("(");
        }
        while (true) {
            Integer outputId = chainedOutput.pollFirst();
            this.buildCascadingDescription(builder, headOpId, outputId);
            if (chainedOutput.isEmpty()) break;
            builder.append(" , ");
        }
        if (multiOutput) {
            builder.append(")");
        }
    }

    private LinkedList<Integer> getChainedOutputNodes(int headOpId, StreamNode node) {
        LinkedList<Integer> chainedOutput = new LinkedList<Integer>();
        if (this.chainedConfigs.containsKey(headOpId)) {
            for (StreamEdge edge : node.getOutEdges()) {
                int targetId = edge.getTargetId();
                if (!this.chainedConfigs.get(headOpId).containsKey(targetId)) continue;
                chainedOutput.add(targetId);
            }
        }
        return chainedOutput;
    }

    private void buildTreeDescription(StringBuilder builder, int headOpId, int currentOpId, String prefix, boolean isLast) {
        String currentNodePrefix = "";
        String childPrefix = "";
        if (currentOpId != headOpId) {
            if (isLast) {
                currentNodePrefix = prefix + "+- ";
                childPrefix = prefix + "   ";
            } else {
                currentNodePrefix = prefix + ":- ";
                childPrefix = prefix + ":  ";
            }
        }
        StreamNode node = this.streamGraph.getStreamNode(currentOpId);
        builder.append(currentNodePrefix);
        builder.append(this.getDescriptionWithChainedSourcesInfo(node));
        builder.append("\n");
        LinkedList<Integer> chainedOutput = this.getChainedOutputNodes(headOpId, node);
        while (!chainedOutput.isEmpty()) {
            Integer outputId = chainedOutput.pollFirst();
            this.buildTreeDescription(builder, headOpId, outputId, childPrefix, chainedOutput.isEmpty());
        }
    }

    private String getDescriptionWithChainedSourcesInfo(StreamNode node) {
        List chainedSources = !this.chainedConfigs.containsKey(node.getId()) ? Collections.emptyList() : node.getInEdges().stream().map(StreamEdge::getSourceId).filter(id -> this.streamGraph.getSourceIDs().contains(id) && this.chainedConfigs.get(node.getId()).containsKey(id)).map(this.streamGraph::getStreamNode).collect(Collectors.toList());
        return chainedSources.isEmpty() ? node.getOperatorDescription() : String.format("%s [%s]", node.getOperatorDescription(), chainedSources.stream().map(StreamNode::getOperatorDescription).collect(Collectors.joining(", ")));
    }

    private void preValidate() {
        CheckpointConfig checkpointConfig = this.streamGraph.getCheckpointConfig();
        if (checkpointConfig.isCheckpointingEnabled()) {
            if (this.streamGraph.isIterative() && !checkpointConfig.isForceCheckpointing()) {
                throw new UnsupportedOperationException("Checkpointing is currently not supported by default for iterative jobs, as we cannot guarantee exactly once semantics. State checkpoints happen normally, but records in-transit during the snapshot will be lost upon failure. \nThe user can force enable state checkpoints with the reduced guarantees by calling: env.enableCheckpointing(interval,true)");
            }
            if (this.streamGraph.isIterative() && checkpointConfig.isUnalignedCheckpointsEnabled() && !checkpointConfig.isForceUnalignedCheckpoints()) {
                throw new UnsupportedOperationException("Unaligned Checkpoints are currently not supported for iterative jobs, as rescaling would require alignment (in addition to the reduced checkpointing guarantees).\nThe user can force Unaligned Checkpoints by using 'execution.checkpointing.unaligned.forced'");
            }
            if (checkpointConfig.isUnalignedCheckpointsEnabled() && !checkpointConfig.isForceUnalignedCheckpoints() && this.streamGraph.getStreamNodes().stream().anyMatch(this::hasCustomPartitioner)) {
                throw new UnsupportedOperationException("Unaligned checkpoints are currently not supported for custom partitioners, as rescaling is not guaranteed to work correctly.\nThe user can force Unaligned Checkpoints by using 'execution.checkpointing.unaligned.forced'");
            }
            for (StreamNode node : this.streamGraph.getStreamNodes()) {
                Class<StreamOperator> operatorClass;
                StreamOperatorFactory<?> operatorFactory = node.getOperatorFactory();
                if (operatorFactory == null || !InputSelectable.class.isAssignableFrom(operatorClass = operatorFactory.getStreamOperatorClass(this.userClassloader))) continue;
                throw new UnsupportedOperationException("Checkpointing is currently not supported for operators that implement InputSelectable:" + operatorClass.getName());
            }
        }
        if (checkpointConfig.isUnalignedCheckpointsEnabled() && this.getCheckpointingMode(checkpointConfig) != CheckpointingMode.EXACTLY_ONCE) {
            LOG.warn("Unaligned checkpoints can only be used with checkpointing mode EXACTLY_ONCE");
            checkpointConfig.enableUnalignedCheckpoints(false);
        }
    }

    private boolean hasCustomPartitioner(StreamNode node) {
        return node.getOutEdges().stream().anyMatch(edge -> edge.getPartitioner() instanceof CustomPartitionerWrapper);
    }

    private void setPhysicalEdges() {
        HashMap<Integer, List> physicalInEdgesInOrder = new HashMap<Integer, List>();
        for (StreamEdge streamEdge : this.physicalEdgesInOrder) {
            int target = streamEdge.getTargetId();
            List inEdges = physicalInEdgesInOrder.computeIfAbsent(target, k -> new ArrayList());
            inEdges.add(streamEdge);
        }
        for (Map.Entry entry : physicalInEdgesInOrder.entrySet()) {
            int vertex = (Integer)entry.getKey();
            List edgeList = (List)entry.getValue();
            this.vertexConfigs.get(vertex).setInPhysicalEdges(edgeList);
        }
    }

    private Map<Integer, OperatorChainInfo> buildChainedInputsAndGetHeadInputs(Map<Integer, byte[]> hashes, List<Map<Integer, byte[]>> legacyHashes) {
        HashMap<Integer, ChainedSourceInfo> chainedSources = new HashMap<Integer, ChainedSourceInfo>();
        HashMap<Integer, OperatorChainInfo> chainEntryPoints = new HashMap<Integer, OperatorChainInfo>();
        for (Integer sourceNodeId : this.streamGraph.getSourceIDs()) {
            StreamEdge sourceOutEdge;
            StreamNode target;
            ChainingStrategy targetChainingStrategy;
            StreamNode sourceNode = this.streamGraph.getStreamNode(sourceNodeId);
            if (sourceNode.getOperatorFactory() instanceof SourceOperatorFactory && sourceNode.getOutEdges().size() == 1 && (targetChainingStrategy = (target = this.streamGraph.getStreamNode((sourceOutEdge = sourceNode.getOutEdges().get(0)).getTargetId())).getOperatorFactory().getChainingStrategy()) == ChainingStrategy.HEAD_WITH_SOURCES && StreamingJobGraphGenerator.isChainableInput(sourceOutEdge, this.streamGraph)) {
                OperatorID opId = new OperatorID(hashes.get(sourceNodeId));
                StreamConfig.SourceInputConfig inputConfig = new StreamConfig.SourceInputConfig(sourceOutEdge);
                StreamConfig operatorConfig = new StreamConfig(new Configuration());
                this.setVertexConfig(sourceNodeId, operatorConfig, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
                operatorConfig.setChainIndex(0);
                operatorConfig.setOperatorID(opId);
                operatorConfig.setOperatorName(sourceNode.getOperatorName());
                chainedSources.put(sourceNodeId, new ChainedSourceInfo(operatorConfig, inputConfig));
                SourceOperatorFactory sourceOpFact = (SourceOperatorFactory)sourceNode.getOperatorFactory();
                OperatorCoordinator.Provider coord = sourceOpFact.getCoordinatorProvider(sourceNode.getOperatorName(), opId);
                OperatorChainInfo chainInfo = chainEntryPoints.computeIfAbsent(sourceOutEdge.getTargetId(), k -> new OperatorChainInfo(sourceOutEdge.getTargetId(), hashes, legacyHashes, chainedSources, this.streamGraph));
                chainInfo.addCoordinatorProvider(coord);
                continue;
            }
            chainEntryPoints.put(sourceNodeId, new OperatorChainInfo(sourceNodeId, hashes, legacyHashes, chainedSources, this.streamGraph));
        }
        return chainEntryPoints;
    }

    private void setChaining(Map<Integer, byte[]> hashes, List<Map<Integer, byte[]>> legacyHashes) {
        Map<Integer, OperatorChainInfo> chainEntryPoints = this.buildChainedInputsAndGetHeadInputs(hashes, legacyHashes);
        Collection initialEntryPoints = chainEntryPoints.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
        for (OperatorChainInfo info : initialEntryPoints) {
            this.createChain(info.getStartNodeId(), 1, info, chainEntryPoints);
        }
    }

    private List<StreamEdge> createChain(Integer currentNodeId, int chainIndex, OperatorChainInfo chainInfo, Map<Integer, OperatorChainInfo> chainEntryPoints) {
        Integer startNodeId = chainInfo.getStartNodeId();
        if (!this.builtVertices.contains(startNodeId)) {
            ArrayList<StreamEdge> transitiveOutEdges = new ArrayList<StreamEdge>();
            ArrayList<StreamEdge> chainableOutputs = new ArrayList<StreamEdge>();
            ArrayList<StreamEdge> nonChainableOutputs = new ArrayList<StreamEdge>();
            StreamNode currentNode = this.streamGraph.getStreamNode(currentNodeId);
            for (StreamEdge outEdge : currentNode.getOutEdges()) {
                if (StreamingJobGraphGenerator.isChainable(outEdge, this.streamGraph)) {
                    chainableOutputs.add(outEdge);
                    continue;
                }
                nonChainableOutputs.add(outEdge);
            }
            for (StreamEdge chainable : chainableOutputs) {
                transitiveOutEdges.addAll(this.createChain(chainable.getTargetId(), chainIndex + 1, chainInfo, chainEntryPoints));
            }
            for (StreamEdge nonChainable : nonChainableOutputs) {
                transitiveOutEdges.add(nonChainable);
                this.createChain(nonChainable.getTargetId(), 1, chainEntryPoints.computeIfAbsent(nonChainable.getTargetId(), k -> chainInfo.newChain(nonChainable.getTargetId())), chainEntryPoints);
            }
            this.chainedNames.put(currentNodeId, this.createChainedName(currentNodeId, chainableOutputs, Optional.ofNullable(chainEntryPoints.get(currentNodeId))));
            this.chainedMinResources.put(currentNodeId, this.createChainedMinResources(currentNodeId, chainableOutputs));
            this.chainedPreferredResources.put(currentNodeId, this.createChainedPreferredResources(currentNodeId, chainableOutputs));
            OperatorID currentOperatorId = chainInfo.addNodeToChain(currentNodeId, this.streamGraph.getStreamNode(currentNodeId).getOperatorName());
            if (currentNode.getInputFormat() != null) {
                this.getOrCreateFormatContainer(startNodeId).addInputFormat(currentOperatorId, currentNode.getInputFormat());
            }
            if (currentNode.getOutputFormat() != null) {
                this.getOrCreateFormatContainer(startNodeId).addOutputFormat(currentOperatorId, currentNode.getOutputFormat());
            }
            StreamConfig config = currentNodeId.equals(startNodeId) ? this.createJobVertex(startNodeId, chainInfo) : new StreamConfig(new Configuration());
            this.setVertexConfig(currentNodeId, config, chainableOutputs, nonChainableOutputs, chainInfo.getChainedSources());
            if (currentNodeId.equals(startNodeId)) {
                config.setChainStart();
                config.setChainIndex(chainIndex);
                config.setOperatorName(this.streamGraph.getStreamNode(currentNodeId).getOperatorName());
                LinkedHashSet<NonChainedOutput> transitiveOutputs = new LinkedHashSet<NonChainedOutput>();
                for (StreamEdge edge : transitiveOutEdges) {
                    NonChainedOutput output = this.opIntermediateOutputs.get(edge.getSourceId()).get(edge);
                    transitiveOutputs.add(output);
                    this.connect(startNodeId, edge, output);
                }
                config.setVertexNonChainedOutputs(new ArrayList<NonChainedOutput>(transitiveOutputs));
                config.setTransitiveChainedTaskConfigs(this.chainedConfigs.get(startNodeId));
            } else {
                this.chainedConfigs.computeIfAbsent(startNodeId, k -> new HashMap());
                config.setChainIndex(chainIndex);
                StreamNode node = this.streamGraph.getStreamNode(currentNodeId);
                config.setOperatorName(node.getOperatorName());
                this.chainedConfigs.get(startNodeId).put(currentNodeId, config);
            }
            config.setOperatorID(currentOperatorId);
            if (chainableOutputs.isEmpty()) {
                config.setChainEnd();
            }
            return transitiveOutEdges;
        }
        return new ArrayList<StreamEdge>();
    }

    private InputOutputFormatContainer getOrCreateFormatContainer(Integer startNodeId) {
        return this.chainedInputOutputFormats.computeIfAbsent(startNodeId, k -> new InputOutputFormatContainer(Thread.currentThread().getContextClassLoader()));
    }

    private String createChainedName(Integer vertexID, List<StreamEdge> chainedOutputs, Optional<OperatorChainInfo> operatorChainInfo) {
        String operatorName = StreamingJobGraphGenerator.nameWithChainedSourcesInfo(this.streamGraph.getStreamNode(vertexID).getOperatorName(), operatorChainInfo.map(chain -> chain.getChainedSources().values()).orElse(Collections.emptyList()));
        if (chainedOutputs.size() > 1) {
            ArrayList<String> outputChainedNames = new ArrayList<String>();
            for (StreamEdge chainable : chainedOutputs) {
                outputChainedNames.add(this.chainedNames.get(chainable.getTargetId()));
            }
            return operatorName + " -> (" + StringUtils.join(outputChainedNames, (String)", ") + ")";
        }
        if (chainedOutputs.size() == 1) {
            return operatorName + " -> " + this.chainedNames.get(chainedOutputs.get(0).getTargetId());
        }
        return operatorName;
    }

    private ResourceSpec createChainedMinResources(Integer vertexID, List<StreamEdge> chainedOutputs) {
        ResourceSpec minResources = this.streamGraph.getStreamNode(vertexID).getMinResources();
        for (StreamEdge chainable : chainedOutputs) {
            minResources = minResources.merge(this.chainedMinResources.get(chainable.getTargetId()));
        }
        return minResources;
    }

    private ResourceSpec createChainedPreferredResources(Integer vertexID, List<StreamEdge> chainedOutputs) {
        ResourceSpec preferredResources = this.streamGraph.getStreamNode(vertexID).getPreferredResources();
        for (StreamEdge chainable : chainedOutputs) {
            preferredResources = preferredResources.merge(this.chainedPreferredResources.get(chainable.getTargetId()));
        }
        return preferredResources;
    }

    private StreamConfig createJobVertex(Integer streamNodeId, OperatorChainInfo chainInfo) {
        InputOutputFormatVertex jobVertex;
        StreamNode streamNode = this.streamGraph.getStreamNode(streamNodeId);
        byte[] hash = chainInfo.getHash(streamNodeId);
        if (hash == null) {
            throw new IllegalStateException("Cannot find node hash. Did you generate them before calling this method?");
        }
        JobVertexID jobVertexId = new JobVertexID(hash);
        List chainedOperators = chainInfo.getChainedOperatorHashes(streamNodeId);
        ArrayList<OperatorIDPair> operatorIDPairs = new ArrayList<OperatorIDPair>();
        if (chainedOperators != null) {
            for (Object chainedOperator : chainedOperators) {
                OperatorID userDefinedOperatorID = ((Tuple2)chainedOperator).f1 == null ? null : new OperatorID((byte[])((Tuple2)chainedOperator).f1);
                operatorIDPairs.add(OperatorIDPair.of((OperatorID)new OperatorID((byte[])((Tuple2)chainedOperator).f0), (OperatorID)userDefinedOperatorID));
            }
        }
        if (this.chainedInputOutputFormats.containsKey(streamNodeId)) {
            jobVertex = new InputOutputFormatVertex(this.chainedNames.get(streamNodeId), jobVertexId, operatorIDPairs);
            this.chainedInputOutputFormats.get(streamNodeId).write(new TaskConfig(jobVertex.getConfiguration()));
        } else {
            jobVertex = new JobVertex(this.chainedNames.get(streamNodeId), jobVertexId, operatorIDPairs);
        }
        if (streamNode.getConsumeClusterDatasetId() != null) {
            jobVertex.addIntermediateDataSetIdToConsume(streamNode.getConsumeClusterDatasetId());
        }
        ArrayList<CompletableFuture<SerializedValue>> serializationFutures = new ArrayList<CompletableFuture<SerializedValue>>();
        for (OperatorCoordinator.Provider coordinatorProvider : chainInfo.getCoordinatorProviders()) {
            serializationFutures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    return new SerializedValue((Object)coordinatorProvider);
                }
                catch (IOException e) {
                    throw new FlinkRuntimeException(String.format("Coordinator Provider for node %s is not serializable.", this.chainedNames.get(streamNodeId)), (Throwable)e);
                }
            }, this.serializationExecutor));
        }
        if (!serializationFutures.isEmpty()) {
            this.coordinatorSerializationFuturesPerJobVertex.put(jobVertexId, serializationFutures);
        }
        jobVertex.setResources(this.chainedMinResources.get(streamNodeId), this.chainedPreferredResources.get(streamNodeId));
        jobVertex.setInvokableClass(streamNode.getJobVertexClass());
        int parallelism = streamNode.getParallelism();
        if (parallelism > 0) {
            jobVertex.setParallelism(parallelism);
        } else {
            parallelism = jobVertex.getParallelism();
        }
        jobVertex.setMaxParallelism(streamNode.getMaxParallelism());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parallelism set: {} for {}", (Object)parallelism, (Object)streamNodeId);
        }
        this.jobVertices.put(streamNodeId, (JobVertex)jobVertex);
        this.builtVertices.add(streamNodeId);
        this.jobGraph.addVertex((JobVertex)jobVertex);
        return new StreamConfig(jobVertex.getConfiguration());
    }

    private void setVertexConfig(Integer vertexID, StreamConfig config, List<StreamEdge> chainableOutputs, List<StreamEdge> nonChainableOutputs, Map<Integer, ChainedSourceInfo> chainedSources) {
        this.tryConvertPartitionerForDynamicGraph(chainableOutputs, nonChainableOutputs);
        StreamNode vertex = this.streamGraph.getStreamNode(vertexID);
        config.setVertexID(vertexID);
        List<StreamEdge> inEdges = vertex.getInEdges();
        TypeSerializer<?>[] inputSerializers = vertex.getTypeSerializersIn();
        StreamConfig.InputConfig[] inputConfigs = new StreamConfig.InputConfig[inputSerializers.length];
        int inputGateCount = 0;
        for (StreamEdge inEdge : inEdges) {
            int inputIndex;
            ChainedSourceInfo chainedSource = chainedSources.get(inEdge.getSourceId());
            int n = inputIndex = inEdge.getTypeNumber() == 0 ? 0 : inEdge.getTypeNumber() - 1;
            if (chainedSource != null) {
                if (inputConfigs[inputIndex] != null) {
                    throw new IllegalStateException("Trying to union a chained source with another input.");
                }
                inputConfigs[inputIndex] = chainedSource.getInputConfig();
                this.chainedConfigs.computeIfAbsent(vertexID, key -> new HashMap()).put(inEdge.getSourceId(), chainedSource.getOperatorConfig());
                continue;
            }
            if (inputConfigs[inputIndex] != null) continue;
            StreamConfig.InputRequirement inputRequirement = vertex.getInputRequirements().getOrDefault(inputIndex, StreamConfig.InputRequirement.PASS_THROUGH);
            inputConfigs[inputIndex] = new StreamConfig.NetworkInputConfig(inputSerializers[inputIndex], inputGateCount++, inputRequirement);
        }
        if (vertex.getConsumeClusterDatasetId() != null) {
            config.setNumberOfNetworkInputs(1);
            inputConfigs[0] = new StreamConfig.NetworkInputConfig(inputSerializers[0], 0);
        }
        config.setInputs(inputConfigs);
        config.setTypeSerializerOut(vertex.getTypeSerializerOut());
        for (StreamEdge edge : chainableOutputs) {
            if (edge.getOutputTag() == null) continue;
            config.setTypeSerializerSideOut(edge.getOutputTag(), edge.getOutputTag().getTypeInfo().createSerializer(this.streamGraph.getExecutionConfig()));
        }
        for (StreamEdge edge : nonChainableOutputs) {
            if (edge.getOutputTag() == null) continue;
            config.setTypeSerializerSideOut(edge.getOutputTag(), edge.getOutputTag().getTypeInfo().createSerializer(this.streamGraph.getExecutionConfig()));
        }
        config.setStreamOperatorFactory(vertex.getOperatorFactory());
        List<NonChainedOutput> deduplicatedOutputs = this.mayReuseNonChainedOutputs(vertexID, nonChainableOutputs);
        config.setNumberOfOutputs(deduplicatedOutputs.size());
        config.setOperatorNonChainedOutputs(deduplicatedOutputs);
        config.setChainedOutputs(chainableOutputs);
        config.setTimeCharacteristic(this.streamGraph.getTimeCharacteristic());
        CheckpointConfig checkpointCfg = this.streamGraph.getCheckpointConfig();
        config.setStateBackend(this.streamGraph.getStateBackend());
        config.setCheckpointStorage(this.streamGraph.getCheckpointStorage());
        config.setSavepointDir(this.streamGraph.getSavepointDirectory());
        config.setGraphContainingLoops(this.streamGraph.isIterative());
        config.setTimerServiceProvider(this.streamGraph.getTimerServiceProvider());
        config.setCheckpointingEnabled(checkpointCfg.isCheckpointingEnabled());
        config.getConfiguration().set(ExecutionCheckpointingOptions.ENABLE_CHECKPOINTS_AFTER_TASKS_FINISH, (Object)this.streamGraph.isEnableCheckpointsAfterTasksFinish());
        config.setCheckpointMode(this.getCheckpointingMode(checkpointCfg));
        config.setUnalignedCheckpointsEnabled(checkpointCfg.isUnalignedCheckpointsEnabled());
        config.setAlignedCheckpointTimeout(checkpointCfg.getAlignedCheckpointTimeout());
        for (int i = 0; i < vertex.getStatePartitioners().length; ++i) {
            config.setStatePartitioner(i, vertex.getStatePartitioners()[i]);
        }
        config.setStateKeySerializer(vertex.getStateKeySerializer());
        Class<? extends TaskInvokable> vertexClass = vertex.getJobVertexClass();
        if (vertexClass.equals(StreamIterationHead.class) || vertexClass.equals(StreamIterationTail.class)) {
            config.setIterationId(this.streamGraph.getBrokerID(vertexID));
            config.setIterationWaitTime(this.streamGraph.getLoopTimeout(vertexID));
        }
        this.vertexConfigs.put(vertexID, config);
    }

    private List<NonChainedOutput> mayReuseNonChainedOutputs(int vertexId, List<StreamEdge> consumerEdges) {
        if (consumerEdges.isEmpty()) {
            return new ArrayList<NonChainedOutput>();
        }
        ArrayList<NonChainedOutput> outputs = new ArrayList<NonChainedOutput>(consumerEdges.size());
        Map outputsConsumedByEdge = this.opIntermediateOutputs.computeIfAbsent(vertexId, ignored -> new HashMap());
        for (StreamEdge consumerEdge : consumerEdges) {
            Preconditions.checkState((vertexId == consumerEdge.getSourceId() ? 1 : 0) != 0, (Object)"Vertex id must be the same.");
            int consumerParallelism = this.streamGraph.getStreamNode(consumerEdge.getTargetId()).getParallelism();
            int consumerMaxParallelism = this.streamGraph.getStreamNode(consumerEdge.getTargetId()).getMaxParallelism();
            StreamPartitioner<?> partitioner = consumerEdge.getPartitioner();
            ResultPartitionType partitionType = this.getResultPartitionType(consumerEdge);
            IntermediateDataSetID dataSetId = new IntermediateDataSetID();
            boolean isPersistentDataSet = this.isPersistentIntermediateDataset(partitionType, consumerEdge);
            if (isPersistentDataSet) {
                partitionType = ResultPartitionType.BLOCKING_PERSISTENT;
                dataSetId = consumerEdge.getIntermediateDatasetIdToProduce();
            }
            NonChainedOutput output = new NonChainedOutput(consumerEdge.supportsUnalignedCheckpoints(), consumerEdge.getSourceId(), consumerParallelism, consumerMaxParallelism, consumerEdge.getBufferTimeout(), isPersistentDataSet, dataSetId, consumerEdge.getOutputTag(), partitioner, partitionType);
            if (!partitionType.isReconsumable()) {
                outputs.add(output);
                outputsConsumedByEdge.put(consumerEdge, output);
                continue;
            }
            NonChainedOutput reusableOutput = null;
            for (NonChainedOutput outputCandidate : outputsConsumedByEdge.values()) {
                if (!outputCandidate.getPartitionType().isReconsumable() || consumerParallelism != outputCandidate.getConsumerParallelism() || consumerMaxParallelism != outputCandidate.getConsumerMaxParallelism() || outputCandidate.getPartitionType() != partitionType || !Objects.equals(outputCandidate.getPersistentDataSetId(), consumerEdge.getIntermediateDatasetIdToProduce()) || !Objects.equals(outputCandidate.getOutputTag(), consumerEdge.getOutputTag()) || !Objects.equals(partitioner, outputCandidate.getPartitioner())) continue;
                reusableOutput = outputCandidate;
                outputsConsumedByEdge.put(consumerEdge, reusableOutput);
                break;
            }
            if (reusableOutput != null) continue;
            outputs.add(output);
            outputsConsumedByEdge.put(consumerEdge, output);
        }
        return outputs;
    }

    private void tryConvertPartitionerForDynamicGraph(List<StreamEdge> chainableOutputs, List<StreamEdge> nonChainableOutputs) {
        StreamPartitioner<?> partitioner;
        for (StreamEdge edge : chainableOutputs) {
            partitioner = edge.getPartitioner();
            if (!(partitioner instanceof ForwardForConsecutiveHashPartitioner) && !(partitioner instanceof ForwardForUnspecifiedPartitioner)) continue;
            Preconditions.checkState((boolean)this.streamGraph.getExecutionConfig().isDynamicGraph(), (Object)String.format("%s should only be used in dynamic graph.", partitioner.getClass().getSimpleName()));
            edge.setPartitioner(new ForwardPartitioner());
        }
        for (StreamEdge edge : nonChainableOutputs) {
            partitioner = edge.getPartitioner();
            if (partitioner instanceof ForwardForConsecutiveHashPartitioner) {
                Preconditions.checkState((boolean)this.streamGraph.getExecutionConfig().isDynamicGraph(), (Object)"ForwardForConsecutiveHashPartitioner should only be used in dynamic graph.");
                edge.setPartitioner(((ForwardForConsecutiveHashPartitioner)partitioner).getHashPartitioner());
                continue;
            }
            if (!(partitioner instanceof ForwardForUnspecifiedPartitioner)) continue;
            Preconditions.checkState((boolean)this.streamGraph.getExecutionConfig().isDynamicGraph(), (Object)"ForwardForUnspecifiedPartitioner should only be used in dynamic graph.");
            edge.setPartitioner(new RescalePartitioner());
        }
    }

    private CheckpointingMode getCheckpointingMode(CheckpointConfig checkpointConfig) {
        CheckpointingMode checkpointingMode = checkpointConfig.getCheckpointingMode();
        Preconditions.checkArgument((checkpointingMode == CheckpointingMode.EXACTLY_ONCE || checkpointingMode == CheckpointingMode.AT_LEAST_ONCE ? 1 : 0) != 0, (Object)"Unexpected checkpointing mode.");
        if (checkpointConfig.isCheckpointingEnabled()) {
            return checkpointingMode;
        }
        return CheckpointingMode.AT_LEAST_ONCE;
    }

    private void connect(Integer headOfChain, StreamEdge edge, NonChainedOutput output) {
        this.physicalEdgesInOrder.add(edge);
        Integer downStreamVertexID = edge.getTargetId();
        JobVertex headVertex = this.jobVertices.get(headOfChain);
        JobVertex downStreamVertex = this.jobVertices.get(downStreamVertexID);
        StreamConfig downStreamConfig = new StreamConfig(downStreamVertex.getConfiguration());
        downStreamConfig.setNumberOfNetworkInputs(downStreamConfig.getNumberOfNetworkInputs() + 1);
        StreamPartitioner<?> partitioner = output.getPartitioner();
        ResultPartitionType resultPartitionType = output.getPartitionType();
        if (resultPartitionType == ResultPartitionType.HYBRID_FULL || resultPartitionType == ResultPartitionType.HYBRID_SELECTIVE) {
            this.hasHybridResultPartition = true;
        }
        this.checkBufferTimeout(resultPartitionType, edge);
        JobEdge jobEdge = partitioner.isPointwise() ? downStreamVertex.connectNewDataSetAsInput(headVertex, DistributionPattern.POINTWISE, resultPartitionType, this.opIntermediateOutputs.get(edge.getSourceId()).get(edge).getDataSetId(), partitioner.isBroadcast()) : downStreamVertex.connectNewDataSetAsInput(headVertex, DistributionPattern.ALL_TO_ALL, resultPartitionType, this.opIntermediateOutputs.get(edge.getSourceId()).get(edge).getDataSetId(), partitioner.isBroadcast());
        jobEdge.setShipStrategyName(partitioner.toString());
        jobEdge.setForward(partitioner instanceof ForwardPartitioner);
        jobEdge.setDownstreamSubtaskStateMapper(partitioner.getDownstreamSubtaskStateMapper());
        jobEdge.setUpstreamSubtaskStateMapper(partitioner.getUpstreamSubtaskStateMapper());
        if (LOG.isDebugEnabled()) {
            LOG.debug("CONNECTED: {} - {} -> {}", new Object[]{partitioner.getClass().getSimpleName(), headOfChain, downStreamVertexID});
        }
    }

    private boolean isPersistentIntermediateDataset(ResultPartitionType resultPartitionType, StreamEdge edge) {
        return resultPartitionType.isBlockingOrBlockingPersistentResultPartition() && edge.getIntermediateDatasetIdToProduce() != null;
    }

    private void checkBufferTimeout(ResultPartitionType type, StreamEdge edge) {
        long bufferTimeout = edge.getBufferTimeout();
        if (!type.canBePipelinedConsumed() && bufferTimeout != -1L) {
            throw new UnsupportedOperationException("only canBePipelinedConsumed partition support buffer timeout " + bufferTimeout + " for src operator in edge " + edge + ". \nPlease either disable buffer timeout (via -1) or use the canBePipelinedConsumed partition.");
        }
    }

    private ResultPartitionType getResultPartitionType(StreamEdge edge) {
        switch (edge.getExchangeMode()) {
            case PIPELINED: {
                return ResultPartitionType.PIPELINED_BOUNDED;
            }
            case BATCH: {
                return ResultPartitionType.BLOCKING;
            }
            case HYBRID_FULL: {
                return ResultPartitionType.HYBRID_FULL;
            }
            case HYBRID_SELECTIVE: {
                return ResultPartitionType.HYBRID_SELECTIVE;
            }
            case UNDEFINED: {
                return this.determineUndefinedResultPartitionType(edge.getPartitioner());
            }
        }
        throw new UnsupportedOperationException("Data exchange mode " + (Object)((Object)edge.getExchangeMode()) + " is not supported yet.");
    }

    private ResultPartitionType determineUndefinedResultPartitionType(StreamPartitioner<?> partitioner) {
        switch (this.streamGraph.getGlobalStreamExchangeMode()) {
            case ALL_EDGES_BLOCKING: {
                return ResultPartitionType.BLOCKING;
            }
            case FORWARD_EDGES_PIPELINED: {
                if (partitioner instanceof ForwardPartitioner) {
                    return ResultPartitionType.PIPELINED_BOUNDED;
                }
                return ResultPartitionType.BLOCKING;
            }
            case POINTWISE_EDGES_PIPELINED: {
                if (partitioner.isPointwise()) {
                    return ResultPartitionType.PIPELINED_BOUNDED;
                }
                return ResultPartitionType.BLOCKING;
            }
            case ALL_EDGES_PIPELINED: {
                return ResultPartitionType.PIPELINED_BOUNDED;
            }
            case ALL_EDGES_PIPELINED_APPROXIMATE: {
                return ResultPartitionType.PIPELINED_APPROXIMATE;
            }
            case ALL_EDGES_HYBRID_FULL: {
                return ResultPartitionType.HYBRID_FULL;
            }
            case ALL_EDGES_HYBRID_SELECTIVE: {
                return ResultPartitionType.HYBRID_SELECTIVE;
            }
        }
        throw new RuntimeException("Unrecognized global data exchange mode " + (Object)((Object)this.streamGraph.getGlobalStreamExchangeMode()));
    }

    public static boolean isChainable(StreamEdge edge, StreamGraph streamGraph) {
        StreamNode downStreamVertex = streamGraph.getTargetVertex(edge);
        return downStreamVertex.getInEdges().size() == 1 && StreamingJobGraphGenerator.isChainableInput(edge, streamGraph);
    }

    private static boolean isChainableInput(StreamEdge edge, StreamGraph streamGraph) {
        StreamNode downStreamVertex;
        StreamNode upStreamVertex = streamGraph.getSourceVertex(edge);
        if (!(upStreamVertex.isSameSlotSharingGroup(downStreamVertex = streamGraph.getTargetVertex(edge)) && StreamingJobGraphGenerator.areOperatorsChainable(upStreamVertex, downStreamVertex, streamGraph) && StreamingJobGraphGenerator.arePartitionerAndExchangeModeChainable(edge.getPartitioner(), edge.getExchangeMode(), streamGraph.getExecutionConfig().isDynamicGraph()) && upStreamVertex.getParallelism() == downStreamVertex.getParallelism() && streamGraph.isChainingEnabled())) {
            return false;
        }
        for (StreamEdge inEdge : downStreamVertex.getInEdges()) {
            if (inEdge == edge || inEdge.getTypeNumber() != edge.getTypeNumber()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean arePartitionerAndExchangeModeChainable(StreamPartitioner<?> partitioner, StreamExchangeMode exchangeMode, boolean isDynamicGraph) {
        if (partitioner instanceof ForwardForConsecutiveHashPartitioner) {
            Preconditions.checkState((boolean)isDynamicGraph);
            return true;
        }
        return partitioner instanceof ForwardPartitioner && exchangeMode != StreamExchangeMode.BATCH;
    }

    @VisibleForTesting
    static boolean areOperatorsChainable(StreamNode upStreamVertex, StreamNode downStreamVertex, StreamGraph streamGraph) {
        boolean isChainable;
        StreamOperatorFactory<?> upStreamOperator = upStreamVertex.getOperatorFactory();
        StreamOperatorFactory<?> downStreamOperator = downStreamVertex.getOperatorFactory();
        if (downStreamOperator == null || upStreamOperator == null) {
            return false;
        }
        if (downStreamOperator instanceof YieldingOperatorFactory && StreamingJobGraphGenerator.getHeadOperator(upStreamVertex, streamGraph).isLegacySource()) {
            return false;
        }
        switch (upStreamOperator.getChainingStrategy()) {
            case NEVER: {
                isChainable = false;
                break;
            }
            case ALWAYS: 
            case HEAD: 
            case HEAD_WITH_SOURCES: {
                isChainable = true;
                break;
            }
            default: {
                throw new RuntimeException("Unknown chaining strategy: " + (Object)((Object)upStreamOperator.getChainingStrategy()));
            }
        }
        switch (downStreamOperator.getChainingStrategy()) {
            case NEVER: 
            case HEAD: {
                isChainable = false;
                break;
            }
            case ALWAYS: {
                break;
            }
            case HEAD_WITH_SOURCES: {
                isChainable &= upStreamOperator instanceof SourceOperatorFactory;
                break;
            }
            default: {
                throw new RuntimeException("Unknown chaining strategy: " + (Object)((Object)downStreamOperator.getChainingStrategy()));
            }
        }
        return isChainable;
    }

    private static StreamOperatorFactory<?> getHeadOperator(StreamNode upStreamVertex, StreamGraph streamGraph) {
        if (upStreamVertex.getInEdges().size() == 1 && StreamingJobGraphGenerator.isChainable(upStreamVertex.getInEdges().get(0), streamGraph)) {
            return StreamingJobGraphGenerator.getHeadOperator(streamGraph.getSourceVertex(upStreamVertex.getInEdges().get(0)), streamGraph);
        }
        return upStreamVertex.getOperatorFactory();
    }

    private void markContainsSourcesOrSinks() {
        for (Map.Entry<Integer, JobVertex> entry : this.jobVertices.entrySet()) {
            JobVertex jobVertex = entry.getValue();
            HashSet<Integer> vertexOperators = new HashSet<Integer>();
            vertexOperators.add(entry.getKey());
            if (this.chainedConfigs.containsKey(entry.getKey())) {
                vertexOperators.addAll(this.chainedConfigs.get(entry.getKey()).keySet());
            }
            Iterator iterator = vertexOperators.iterator();
            while (iterator.hasNext()) {
                int nodeId = (Integer)iterator.next();
                if (this.streamGraph.getSourceIDs().contains(nodeId)) {
                    jobVertex.markContainsSources();
                }
                if (!this.streamGraph.getSinkIDs().contains(nodeId) && !this.streamGraph.getExpandedSinkIds().contains(nodeId)) continue;
                jobVertex.markContainsSinks();
            }
        }
    }

    private void setSlotSharingAndCoLocation() {
        this.setSlotSharing();
        this.setCoLocation();
    }

    private void setSlotSharing() {
        HashMap<String, SlotSharingGroup> specifiedSlotSharingGroups = new HashMap<String, SlotSharingGroup>();
        Map<JobVertexID, SlotSharingGroup> vertexRegionSlotSharingGroups = this.buildVertexRegionSlotSharingGroups();
        for (Map.Entry<Integer, JobVertex> entry : this.jobVertices.entrySet()) {
            SlotSharingGroup effectiveSlotSharingGroup;
            JobVertex vertex = entry.getValue();
            String slotSharingGroupKey = this.streamGraph.getStreamNode(entry.getKey()).getSlotSharingGroup();
            Preconditions.checkNotNull((Object)slotSharingGroupKey, (String)"StreamNode slot sharing group must not be null");
            if (slotSharingGroupKey.equals("default")) {
                effectiveSlotSharingGroup = (SlotSharingGroup)Preconditions.checkNotNull((Object)vertexRegionSlotSharingGroups.get(vertex.getID()));
            } else {
                Preconditions.checkState((!this.hasHybridResultPartition ? 1 : 0) != 0, (Object)"hybrid shuffle mode currently does not support setting non-default slot sharing group.");
                effectiveSlotSharingGroup = specifiedSlotSharingGroups.computeIfAbsent(slotSharingGroupKey, k -> {
                    SlotSharingGroup ssg = new SlotSharingGroup();
                    this.streamGraph.getSlotSharingGroupResource((String)k).ifPresent(arg_0 -> ((SlotSharingGroup)ssg).setResourceProfile(arg_0));
                    return ssg;
                });
            }
            vertex.setSlotSharingGroup(effectiveSlotSharingGroup);
        }
    }

    private Map<JobVertexID, SlotSharingGroup> buildVertexRegionSlotSharingGroups() {
        HashMap<JobVertexID, SlotSharingGroup> vertexRegionSlotSharingGroups = new HashMap<JobVertexID, SlotSharingGroup>();
        SlotSharingGroup defaultSlotSharingGroup = new SlotSharingGroup();
        this.streamGraph.getSlotSharingGroupResource("default").ifPresent(arg_0 -> ((SlotSharingGroup)defaultSlotSharingGroup).setResourceProfile(arg_0));
        boolean allRegionsInSameSlotSharingGroup = this.streamGraph.isAllVerticesInSameSlotSharingGroupByDefault();
        Iterable regions = DefaultLogicalTopology.fromJobGraph((JobGraph)this.jobGraph).getAllPipelinedRegions();
        for (DefaultLogicalPipelinedRegion region : regions) {
            SlotSharingGroup regionSlotSharingGroup;
            if (allRegionsInSameSlotSharingGroup) {
                regionSlotSharingGroup = defaultSlotSharingGroup;
            } else {
                regionSlotSharingGroup = new SlotSharingGroup();
                this.streamGraph.getSlotSharingGroupResource("default").ifPresent(arg_0 -> ((SlotSharingGroup)regionSlotSharingGroup).setResourceProfile(arg_0));
            }
            for (LogicalVertex vertex : region.getVertices()) {
                vertexRegionSlotSharingGroups.put((JobVertexID)vertex.getId(), regionSlotSharingGroup);
            }
        }
        return vertexRegionSlotSharingGroups;
    }

    private void setCoLocation() {
        HashMap<String, Tuple2> coLocationGroups = new HashMap<String, Tuple2>();
        for (Map.Entry<Integer, JobVertex> entry : this.jobVertices.entrySet()) {
            StreamNode node = this.streamGraph.getStreamNode(entry.getKey());
            JobVertex vertex = entry.getValue();
            SlotSharingGroup sharingGroup = vertex.getSlotSharingGroup();
            String coLocationGroupKey = node.getCoLocationGroup();
            if (coLocationGroupKey == null) continue;
            if (sharingGroup == null) {
                throw new IllegalStateException("Cannot use a co-location constraint without a slot sharing group");
            }
            Tuple2 constraint = coLocationGroups.computeIfAbsent(coLocationGroupKey, k -> new Tuple2((Object)sharingGroup, (Object)new CoLocationGroupImpl(new JobVertex[0])));
            if (constraint.f0 != sharingGroup) {
                throw new IllegalStateException("Cannot co-locate operators from different slot sharing groups");
            }
            vertex.updateCoLocationGroup((CoLocationGroupImpl)constraint.f1);
            ((CoLocationGroupImpl)constraint.f1).addVertex(vertex);
        }
    }

    private static void setManagedMemoryFraction(Map<Integer, JobVertex> jobVertices, Map<Integer, StreamConfig> operatorConfigs, Map<Integer, Map<Integer, StreamConfig>> vertexChainedConfigs, Function<Integer, Map<ManagedMemoryUseCase, Integer>> operatorScopeManagedMemoryUseCaseWeightsRetriever, Function<Integer, Set<ManagedMemoryUseCase>> slotScopeManagedMemoryUseCasesRetriever) {
        Set<SlotSharingGroup> slotSharingGroups = Collections.newSetFromMap(new IdentityHashMap());
        HashMap<JobVertexID, Integer> vertexHeadOperators = new HashMap<JobVertexID, Integer>();
        HashMap<JobVertexID, Set<Integer>> vertexOperators = new HashMap<JobVertexID, Set<Integer>>();
        for (Map.Entry<Integer, JobVertex> entry : jobVertices.entrySet()) {
            int headOperatorId = entry.getKey();
            JobVertex jobVertex = entry.getValue();
            SlotSharingGroup jobVertexSlotSharingGroup = jobVertex.getSlotSharingGroup();
            Preconditions.checkState((jobVertexSlotSharingGroup != null ? 1 : 0) != 0, (Object)"JobVertex slot sharing group must not be null");
            slotSharingGroups.add(jobVertexSlotSharingGroup);
            vertexHeadOperators.put(jobVertex.getID(), headOperatorId);
            HashSet<Integer> operatorIds = new HashSet<Integer>();
            operatorIds.add(headOperatorId);
            operatorIds.addAll(vertexChainedConfigs.getOrDefault(headOperatorId, Collections.emptyMap()).keySet());
            vertexOperators.put(jobVertex.getID(), operatorIds);
        }
        for (SlotSharingGroup slotSharingGroup : slotSharingGroups) {
            StreamingJobGraphGenerator.setManagedMemoryFractionForSlotSharingGroup(slotSharingGroup, vertexHeadOperators, vertexOperators, operatorConfigs, vertexChainedConfigs, operatorScopeManagedMemoryUseCaseWeightsRetriever, slotScopeManagedMemoryUseCasesRetriever);
        }
    }

    private static void setManagedMemoryFractionForSlotSharingGroup(SlotSharingGroup slotSharingGroup, Map<JobVertexID, Integer> vertexHeadOperators, Map<JobVertexID, Set<Integer>> vertexOperators, Map<Integer, StreamConfig> operatorConfigs, Map<Integer, Map<Integer, StreamConfig>> vertexChainedConfigs, Function<Integer, Map<ManagedMemoryUseCase, Integer>> operatorScopeManagedMemoryUseCaseWeightsRetriever, Function<Integer, Set<ManagedMemoryUseCase>> slotScopeManagedMemoryUseCasesRetriever) {
        Set groupOperatorIds = slotSharingGroup.getJobVertexIds().stream().flatMap(vid -> ((Set)vertexOperators.get(vid)).stream()).collect(Collectors.toSet());
        Map<ManagedMemoryUseCase, Integer> groupOperatorScopeUseCaseWeights = groupOperatorIds.stream().flatMap(oid -> ((Map)operatorScopeManagedMemoryUseCaseWeightsRetriever.apply((Integer)oid)).entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingInt(Map.Entry::getValue)));
        Set<ManagedMemoryUseCase> groupSlotScopeUseCases = groupOperatorIds.stream().flatMap(oid -> ((Set)slotScopeManagedMemoryUseCasesRetriever.apply((Integer)oid)).stream()).collect(Collectors.toSet());
        for (JobVertexID jobVertexID : slotSharingGroup.getJobVertexIds()) {
            for (int operatorNodeId : vertexOperators.get(jobVertexID)) {
                StreamConfig operatorConfig = operatorConfigs.get(operatorNodeId);
                Map<ManagedMemoryUseCase, Integer> operatorScopeUseCaseWeights = operatorScopeManagedMemoryUseCaseWeightsRetriever.apply(operatorNodeId);
                Set<ManagedMemoryUseCase> slotScopeUseCases = slotScopeManagedMemoryUseCasesRetriever.apply(operatorNodeId);
                StreamingJobGraphGenerator.setManagedMemoryFractionForOperator(operatorScopeUseCaseWeights, slotScopeUseCases, groupOperatorScopeUseCaseWeights, groupSlotScopeUseCases, operatorConfig);
            }
            int headOperatorNodeId = vertexHeadOperators.get(jobVertexID);
            StreamConfig vertexConfig = operatorConfigs.get(headOperatorNodeId);
            vertexConfig.setTransitiveChainedTaskConfigs(vertexChainedConfigs.get(headOperatorNodeId));
        }
    }

    private static void setManagedMemoryFractionForOperator(Map<ManagedMemoryUseCase, Integer> operatorScopeUseCaseWeights, Set<ManagedMemoryUseCase> slotScopeUseCases, Map<ManagedMemoryUseCase, Integer> groupManagedMemoryWeights, Set<ManagedMemoryUseCase> groupSlotScopeUseCases, StreamConfig operatorConfig) {
        for (Map.Entry<ManagedMemoryUseCase, Integer> entry : groupManagedMemoryWeights.entrySet()) {
            ManagedMemoryUseCase useCase = entry.getKey();
            int groupWeight = entry.getValue();
            int operatorWeight = operatorScopeUseCaseWeights.getOrDefault(useCase, 0);
            operatorConfig.setManagedMemoryFractionOperatorOfUseCase(useCase, operatorWeight > 0 ? ManagedMemoryUtils.getFractionRoundedDown((long)operatorWeight, (long)groupWeight) : 0.0);
        }
        Iterator<Map.Entry<ManagedMemoryUseCase, Integer>> iterator = groupSlotScopeUseCases.iterator();
        while (iterator.hasNext()) {
            ManagedMemoryUseCase useCase;
            operatorConfig.setManagedMemoryFractionOperatorOfUseCase(useCase, slotScopeUseCases.contains(useCase = (ManagedMemoryUseCase)iterator.next()) ? 1.0 : 0.0);
        }
    }

    private void configureCheckpointing() {
        SerializedValue serializedCheckpointStorage;
        SerializedValue serializedStateBackend;
        SerializedValue serializedHooks;
        CheckpointRetentionPolicy retentionAfterTermination;
        CheckpointConfig cfg = this.streamGraph.getCheckpointConfig();
        long interval = cfg.getCheckpointInterval();
        if (interval < 10L) {
            interval = Long.MAX_VALUE;
        }
        if (cfg.isExternalizedCheckpointsEnabled()) {
            CheckpointConfig.ExternalizedCheckpointCleanup cleanup = cfg.getExternalizedCheckpointCleanup();
            if (cleanup == null) {
                throw new IllegalStateException("Externalized checkpoints enabled, but no cleanup mode configured.");
            }
            retentionAfterTermination = cleanup.deleteOnCancellation() ? CheckpointRetentionPolicy.RETAIN_ON_FAILURE : CheckpointRetentionPolicy.RETAIN_ON_CANCELLATION;
        } else {
            retentionAfterTermination = CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION;
        }
        ArrayList<FunctionMasterCheckpointHookFactory> hooks = new ArrayList<FunctionMasterCheckpointHookFactory>();
        for (StreamNode node : this.streamGraph.getStreamNodes()) {
            org.apache.flink.api.common.functions.Function f;
            if (!(node.getOperatorFactory() instanceof UdfStreamOperatorFactory) || !((f = ((UdfStreamOperatorFactory)node.getOperatorFactory()).getUserFunction()) instanceof WithMasterCheckpointHook)) continue;
            hooks.add(new FunctionMasterCheckpointHookFactory((WithMasterCheckpointHook)f));
        }
        if (hooks.isEmpty()) {
            serializedHooks = null;
        } else {
            try {
                MasterTriggerRestoreHook.Factory[] asArray = hooks.toArray(new MasterTriggerRestoreHook.Factory[hooks.size()]);
                serializedHooks = new SerializedValue((Object)asArray);
            }
            catch (IOException e) {
                throw new FlinkRuntimeException("Trigger/restore hook is not serializable", (Throwable)e);
            }
        }
        if (this.streamGraph.getStateBackend() == null) {
            serializedStateBackend = null;
        } else {
            try {
                serializedStateBackend = new SerializedValue((Object)this.streamGraph.getStateBackend());
            }
            catch (IOException e) {
                throw new FlinkRuntimeException("State backend is not serializable", (Throwable)e);
            }
        }
        if (this.streamGraph.getCheckpointStorage() == null) {
            serializedCheckpointStorage = null;
        } else {
            try {
                serializedCheckpointStorage = new SerializedValue((Object)this.streamGraph.getCheckpointStorage());
            }
            catch (IOException e) {
                throw new FlinkRuntimeException("Checkpoint storage is not serializable", (Throwable)e);
            }
        }
        JobCheckpointingSettings settings = new JobCheckpointingSettings(CheckpointCoordinatorConfiguration.builder().setCheckpointInterval(interval).setCheckpointTimeout(cfg.getCheckpointTimeout()).setMinPauseBetweenCheckpoints(cfg.getMinPauseBetweenCheckpoints()).setMaxConcurrentCheckpoints(cfg.getMaxConcurrentCheckpoints()).setCheckpointRetentionPolicy(retentionAfterTermination).setExactlyOnce(this.getCheckpointingMode(cfg) == CheckpointingMode.EXACTLY_ONCE).setTolerableCheckpointFailureNumber(cfg.getTolerableCheckpointFailureNumber()).setUnalignedCheckpointsEnabled(cfg.isUnalignedCheckpointsEnabled()).setCheckpointIdOfIgnoredInFlightData(cfg.getCheckpointIdOfIgnoredInFlightData()).setAlignedCheckpointTimeout(cfg.getAlignedCheckpointTimeout().toMillis()).setEnableCheckpointsAfterTasksFinish(this.streamGraph.isEnableCheckpointsAfterTasksFinish()).build(), serializedStateBackend, this.streamGraph.isChangelogStateBackendEnabled(), serializedCheckpointStorage, serializedHooks);
        this.jobGraph.setSnapshotSettings(settings);
    }

    private static String nameWithChainedSourcesInfo(String operatorName, Collection<ChainedSourceInfo> chainedSourceInfos) {
        return chainedSourceInfos.isEmpty() ? operatorName : String.format("%s [%s]", operatorName, chainedSourceInfos.stream().map(chainedSourceInfo -> chainedSourceInfo.getOperatorConfig().getOperatorName()).collect(Collectors.joining(", ")));
    }

    private static final class ChainedSourceInfo {
        private final StreamConfig operatorConfig;
        private final StreamConfig.SourceInputConfig inputConfig;

        ChainedSourceInfo(StreamConfig operatorConfig, StreamConfig.SourceInputConfig inputConfig) {
            this.operatorConfig = operatorConfig;
            this.inputConfig = inputConfig;
        }

        public StreamConfig getOperatorConfig() {
            return this.operatorConfig;
        }

        public StreamConfig.SourceInputConfig getInputConfig() {
            return this.inputConfig;
        }
    }

    private static class OperatorChainInfo {
        private final Integer startNodeId;
        private final Map<Integer, byte[]> hashes;
        private final List<Map<Integer, byte[]>> legacyHashes;
        private final Map<Integer, List<Tuple2<byte[], byte[]>>> chainedOperatorHashes;
        private final Map<Integer, ChainedSourceInfo> chainedSources;
        private final List<OperatorCoordinator.Provider> coordinatorProviders;
        private final StreamGraph streamGraph;

        private OperatorChainInfo(int startNodeId, Map<Integer, byte[]> hashes, List<Map<Integer, byte[]>> legacyHashes, Map<Integer, ChainedSourceInfo> chainedSources, StreamGraph streamGraph) {
            this.startNodeId = startNodeId;
            this.hashes = hashes;
            this.legacyHashes = legacyHashes;
            this.chainedOperatorHashes = new HashMap<Integer, List<Tuple2<byte[], byte[]>>>();
            this.coordinatorProviders = new ArrayList<OperatorCoordinator.Provider>();
            this.chainedSources = chainedSources;
            this.streamGraph = streamGraph;
        }

        byte[] getHash(Integer streamNodeId) {
            return this.hashes.get(streamNodeId);
        }

        private Integer getStartNodeId() {
            return this.startNodeId;
        }

        private List<Tuple2<byte[], byte[]>> getChainedOperatorHashes(int startNodeId) {
            return this.chainedOperatorHashes.get(startNodeId);
        }

        void addCoordinatorProvider(OperatorCoordinator.Provider coordinator) {
            this.coordinatorProviders.add(coordinator);
        }

        private List<OperatorCoordinator.Provider> getCoordinatorProviders() {
            return this.coordinatorProviders;
        }

        Map<Integer, ChainedSourceInfo> getChainedSources() {
            return this.chainedSources;
        }

        private OperatorID addNodeToChain(int currentNodeId, String operatorName) {
            List operatorHashes = this.chainedOperatorHashes.computeIfAbsent(this.startNodeId, k -> new ArrayList());
            byte[] primaryHashBytes = this.hashes.get(currentNodeId);
            for (Map<Integer, byte[]> legacyHash : this.legacyHashes) {
                operatorHashes.add(new Tuple2((Object)primaryHashBytes, (Object)legacyHash.get(currentNodeId)));
            }
            this.streamGraph.getStreamNode(currentNodeId).getCoordinatorProvider(operatorName, new OperatorID(this.getHash(currentNodeId))).map(this.coordinatorProviders::add);
            return new OperatorID(primaryHashBytes);
        }

        private OperatorChainInfo newChain(Integer startNodeId) {
            return new OperatorChainInfo(startNodeId, this.hashes, this.legacyHashes, this.chainedSources, this.streamGraph);
        }
    }
}

