/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GrpcRequestTracingInfo;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.gson.Gson;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.net.SocketAddress;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class GoogleCloudStorageGrpcTracingInterceptor
implements ClientInterceptor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GrpcRequestTracingInfo requestInfo;

    GoogleCloudStorageGrpcTracingInterceptor(GrpcRequestTracingInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return channel.newCall(methodDescriptor, callOptions.withStreamTracerFactory(this.getFactory()));
    }

    private ClientStreamTracer.Factory getFactory() {
        return new ClientStreamTracer.Factory(){

            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                return new GRPCClientStreamTracer(info, headers, GoogleCloudStorageGrpcTracingInterceptor.this.requestInfo);
            }
        };
    }

    private static class GRPCClientStreamTracer
    extends ClientStreamTracer {
        private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneOffset.UTC);
        private final ClientStreamTracer.StreamInfo streamInfo;
        private final Gson gson = new Gson();
        private final String initiatingThreadName = Thread.currentThread().getName();
        private final GrpcRequestTracingInfo requestInfo;
        private final Stopwatch stopwatch = Stopwatch.createUnstarted();
        private SocketAddress remoteAddress;

        public GRPCClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers, GrpcRequestTracingInfo requestInfo) {
            this.streamInfo = info;
            this.requestInfo = requestInfo;
        }

        public void streamCreated(Attributes transportAttrs, Metadata headers) {
            this.remoteAddress = (SocketAddress)transportAttrs.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo("streamCreated").put((Object)"transportattrs", (Object)transportAttrs).put((Object)"headers", (Object)(headers == null ? "null" : headers.toString())).put((Object)"streamInfo", (Object)(this.streamInfo == null ? "null" : this.streamInfo.toString())).build()));
            this.stopwatch.start();
            super.streamCreated(transportAttrs, headers);
        }

        private String toJson(ImmutableMap<String, Object> eventDetails) {
            return this.gson.toJson(eventDetails);
        }

        private ImmutableMap.Builder<String, Object> getRequestTrackingInfo(String message) {
            return new ImmutableMap.Builder().put((Object)"initiatingthreadname", (Object)this.initiatingThreadName).put((Object)"remoteaddress", (Object)this.remoteAddress).put((Object)"elapsedmillis", (Object)this.stopwatch.elapsed().toMillis()).put((Object)"requestinfo", (Object)this.requestInfo).put((Object)"eventtime", (Object)dateTimeFormatter.format(Instant.now())).put((Object)"details", (Object)message);
        }

        public void inboundTrailers(Metadata trailers) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo("inboundTrailers()").put((Object)"trailers", (Object)(trailers == null ? "null" : trailers.toString())).build()));
        }

        public void streamClosed(Status status) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo("streamcloses()").put((Object)"status", (Object)status).build()));
        }

        public void outboundMessage(int seqNo) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo("outboundMessage()").put((Object)"seqno", (Object)seqNo).build()));
        }

        public void inboundMessage(int seqNo) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo("inboundMessage()").put((Object)"seqno", (Object)seqNo).build()));
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo("outboundMessageSent()").put((Object)"seqno", (Object)seqNo).put((Object)"optionalWireSize", (Object)optionalWireSize).put((Object)"optionalUncompressedSize", (Object)optionalUncompressedSize).build()));
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson((ImmutableMap<String, Object>)this.getRequestTrackingInfo("inboundMessageRead()").put((Object)"seqno", (Object)seqNo).put((Object)"optionalWireSize", (Object)optionalWireSize).put((Object)"optionalUncompressedSize", (Object)optionalUncompressedSize).build()));
        }
    }
}

