/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class CreateFolderBatchArg {
    @Nonnull
    protected final List<String> paths;
    protected final boolean autorename;
    protected final boolean forceAsync;

    public CreateFolderBatchArg(@Nonnull List<String> paths, boolean autorename, boolean forceAsync) {
        if (paths == null) {
            throw new IllegalArgumentException("Required value for 'paths' is null");
        }
        if (paths.size() > 10000) {
            throw new IllegalArgumentException("List 'paths' has more than 10000 items");
        }
        for (String x : paths) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'paths' is null");
            }
            if (Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'paths' does not match pattern");
        }
        this.paths = paths;
        this.autorename = autorename;
        this.forceAsync = forceAsync;
    }

    public CreateFolderBatchArg(@Nonnull List<String> paths) {
        this(paths, false, false);
    }

    @Nonnull
    public List<String> getPaths() {
        return this.paths;
    }

    public boolean getAutorename() {
        return this.autorename;
    }

    public boolean getForceAsync() {
        return this.forceAsync;
    }

    public static Builder newBuilder(List<String> paths) {
        return new Builder(paths);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.paths, this.autorename, this.forceAsync});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            CreateFolderBatchArg other = (CreateFolderBatchArg)obj;
            return (this.paths == other.paths || this.paths.equals(other.paths)) && this.autorename == other.autorename && this.forceAsync == other.forceAsync;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<CreateFolderBatchArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(CreateFolderBatchArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("paths");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.paths, g);
            g.writeFieldName("autorename");
            StoneSerializers.boolean_().serialize((Boolean)value.autorename, g);
            g.writeFieldName("force_async");
            StoneSerializers.boolean_().serialize((Boolean)value.forceAsync, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public CreateFolderBatchArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_forceAsync;
            Boolean f_autorename;
            List<String> f_paths;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_paths = null;
                f_autorename = false;
                f_forceAsync = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("paths".equals(field)) {
                        f_paths = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("autorename".equals(field)) {
                        f_autorename = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("force_async".equals(field)) {
                        f_forceAsync = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_paths == null) {
                    throw new JsonParseException(p, "Required field \"paths\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            CreateFolderBatchArg value = new CreateFolderBatchArg(f_paths, f_autorename, f_forceAsync);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final List<String> paths;
        protected boolean autorename;
        protected boolean forceAsync;

        protected Builder(List<String> paths) {
            if (paths == null) {
                throw new IllegalArgumentException("Required value for 'paths' is null");
            }
            if (paths.size() > 10000) {
                throw new IllegalArgumentException("List 'paths' has more than 10000 items");
            }
            for (String x : paths) {
                if (x == null) {
                    throw new IllegalArgumentException("An item in list 'paths' is null");
                }
                if (Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)", x)) continue;
                throw new IllegalArgumentException("Stringan item in list 'paths' does not match pattern");
            }
            this.paths = paths;
            this.autorename = false;
            this.forceAsync = false;
        }

        public Builder withAutorename(Boolean autorename) {
            this.autorename = autorename != null ? autorename : false;
            return this;
        }

        public Builder withForceAsync(Boolean forceAsync) {
            this.forceAsync = forceAsync != null ? forceAsync : false;
            return this;
        }

        public CreateFolderBatchArg build() {
            return new CreateFolderBatchArg(this.paths, this.autorename, this.forceAsync);
        }
    }
}

