/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mailinput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mailinput.MailInput;
import org.apache.hop.pipeline.transforms.mailinput.MailInputData;
import org.apache.hop.pipeline.transforms.mailinput.MailInputField;
import org.apache.hop.workflow.actions.getpop.MailConnectionMeta;
import org.w3c.dom.Node;

@Transform(id="MailInput", image="mailinput.svg", name="i18n::MailInput.Name", description="i18n::MailInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::MailInputMeta.keyword"}, documentationUrl="/pipeline/transforms/emailinput.html")
public class MailInputMeta
extends BaseTransformMeta<MailInput, MailInputData> {
    private static final Class<?> PKG = MailInputMeta.class;
    private static final String CONST_SPACE = "      ";
    private static final String CONST_FIELD = "field";
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final int DEFAULT_BATCH_SIZE = 500;
    public int conditionReceivedDate;
    public int valueimaplist;
    private String servername;
    private String username;
    private String password;
    private boolean usessl;
    private boolean usexoauth2;
    private String sslport;
    private String firstmails;
    public int retrievemails;
    private boolean delete;
    private String protocol;
    private String imapfirstmails;
    private String imapfolder;
    private String senderSearch;
    private boolean notTermSenderSearch;
    private String recipientSearch;
    private String subjectSearch;
    private String receivedDate1;
    private String receivedDate2;
    private boolean notTermSubjectSearch;
    private boolean notTermRecipientSearch;
    private boolean notTermReceivedDateSearch;
    private boolean includesubfolders;
    private boolean useproxy;
    private String proxyusername;
    private String folderfield;
    private boolean usedynamicfolder;
    private String rowlimit;
    private MailInputField[] inputFields;
    private boolean useBatch;
    private String start;
    private String end;
    private Integer batchSize = 500;
    private boolean stopOnError;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrFields) {
        this.inputFields = new MailInputField[nrFields];
    }

    public Object clone() {
        MailInputMeta retval = (MailInputMeta)((Object)super.clone());
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (MailInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node transformNode) {
        this.servername = XmlHandler.getTagValue((Node)transformNode, (String)"servername");
        this.username = XmlHandler.getTagValue((Node)transformNode, (String)"username");
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"password"));
        this.usessl = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usessl"));
        this.usexoauth2 = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usexoauth2"));
        this.sslport = XmlHandler.getTagValue((Node)transformNode, (String)"sslport");
        this.retrievemails = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"retrievemails"), (int)-1);
        this.firstmails = XmlHandler.getTagValue((Node)transformNode, (String)"firstmails");
        this.delete = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"delete"));
        this.protocol = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"protocol"), (String)"POP3");
        this.valueimaplist = MailConnectionMeta.getValueImapListByCode((String)Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"valueimaplist"), (String)""));
        this.imapfirstmails = XmlHandler.getTagValue((Node)transformNode, (String)"imapfirstmails");
        this.imapfolder = XmlHandler.getTagValue((Node)transformNode, (String)"imapfolder");
        this.senderSearch = XmlHandler.getTagValue((Node)transformNode, (String)"sendersearch");
        this.notTermSenderSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"nottermsendersearch"));
        this.recipientSearch = XmlHandler.getTagValue((Node)transformNode, (String)"recipientsearch");
        this.notTermRecipientSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"notTermRecipientSearch"));
        this.subjectSearch = XmlHandler.getTagValue((Node)transformNode, (String)"subjectsearch");
        this.notTermSubjectSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"nottermsubjectsearch"));
        this.conditionReceivedDate = MailConnectionMeta.getConditionByCode((String)Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"conditionreceiveddate"), (String)""));
        this.notTermReceivedDateSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"nottermreceiveddatesearch"));
        this.receivedDate1 = XmlHandler.getTagValue((Node)transformNode, (String)"receivedDate1");
        this.receivedDate2 = XmlHandler.getTagValue((Node)transformNode, (String)"receivedDate2");
        this.includesubfolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includesubfolders"));
        this.usedynamicfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usedynamicfolder"));
        this.folderfield = XmlHandler.getTagValue((Node)transformNode, (String)"folderfield");
        this.proxyusername = XmlHandler.getTagValue((Node)transformNode, (String)"proxyusername");
        this.useproxy = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useproxy"));
        this.useBatch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useBatch"));
        try {
            this.batchSize = Integer.parseInt(XmlHandler.getTagValue((Node)transformNode, (String)"batchSize"));
        }
        catch (NumberFormatException e) {
            this.batchSize = 500;
        }
        this.start = XmlHandler.getTagValue((Node)transformNode, (String)"startMsg");
        this.end = XmlHandler.getTagValue((Node)transformNode, (String)"endMsg");
        this.stopOnError = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"stopOnError"));
        this.rowlimit = XmlHandler.getTagValue((Node)transformNode, (String)"rowlimit");
        Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
        int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
            this.inputFields[i] = new MailInputField();
            this.inputFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
            this.inputFields[i].setColumn(MailInputField.getColumnByCode(XmlHandler.getTagValue((Node)fnode, (String)"column")));
        }
    }

    public void setDefault() {
        this.servername = null;
        this.username = null;
        this.password = null;
        this.usessl = false;
        this.usexoauth2 = false;
        this.sslport = null;
        this.retrievemails = 0;
        this.firstmails = null;
        this.delete = false;
        this.protocol = "POP3";
        this.imapfirstmails = "0";
        this.valueimaplist = 0;
        this.imapfolder = null;
        this.senderSearch = null;
        this.notTermSenderSearch = false;
        this.notTermRecipientSearch = false;
        this.notTermSubjectSearch = false;
        this.receivedDate1 = null;
        this.receivedDate2 = null;
        this.notTermReceivedDateSearch = false;
        this.recipientSearch = null;
        this.subjectSearch = null;
        this.includesubfolders = false;
        this.useproxy = false;
        this.proxyusername = null;
        this.folderfield = null;
        this.usedynamicfolder = false;
        this.rowlimit = "0";
        this.batchSize = 500;
        this.useBatch = false;
        this.start = null;
        this.end = null;
        this.stopOnError = true;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new MailInputField(CONST_FIELD + (i + 1));
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        String tab = CONST_SPACE;
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"servername", (String)this.servername));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"username", (String)this.username));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"usessl", (boolean)this.usessl));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"usexoauth2", (boolean)this.usexoauth2));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"sslport", (String)this.sslport));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"retrievemails", (int)this.retrievemails));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"firstmails", (String)this.firstmails));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"delete", (boolean)this.delete));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"valueimaplist", (String)MailConnectionMeta.getValueImapListCode((int)this.valueimaplist)));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"imapfirstmails", (String)this.imapfirstmails));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"imapfolder", (String)this.imapfolder));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"sendersearch", (String)this.senderSearch));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"nottermsendersearch", (boolean)this.notTermSenderSearch));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"recipientsearch", (String)this.recipientSearch));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"notTermRecipientSearch", (boolean)this.notTermRecipientSearch));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"subjectsearch", (String)this.subjectSearch));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"nottermsubjectsearch", (boolean)this.notTermSubjectSearch));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"conditionreceiveddate", (String)MailConnectionMeta.getConditionDateCode((int)this.conditionReceivedDate)));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"nottermreceiveddatesearch", (boolean)this.notTermReceivedDateSearch));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"receiveddate1", (String)this.receivedDate1));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"receiveddate2", (String)this.receivedDate2));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"includesubfolders", (boolean)this.includesubfolders));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"useproxy", (boolean)this.useproxy));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"proxyusername", (String)this.proxyusername));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"usedynamicfolder", (boolean)this.usedynamicfolder));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"folderfield", (String)this.folderfield));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"rowlimit", (String)this.rowlimit));
        retval.append(tab).append(XmlHandler.addTagValue((String)"useBatch", (boolean)this.useBatch));
        retval.append(tab).append(XmlHandler.addTagValue((String)"batchSize", (int)this.batchSize));
        retval.append(tab).append(XmlHandler.addTagValue((String)"startMsg", (String)this.start));
        retval.append(tab).append(XmlHandler.addTagValue((String)"endMsg", (String)this.end));
        retval.append(tab).append(XmlHandler.addTagValue((String)"stopOnError", (boolean)this.stopOnError));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"column", (String)this.inputFields[i].getColumnCode()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MailInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MailInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getPort() {
        return this.sslport;
    }

    public void setPort(String sslport) {
        this.sslport = sslport;
    }

    public void setFirstMails(String firstmails) {
        this.firstmails = firstmails;
    }

    public String getFirstMails() {
        return this.firstmails;
    }

    public boolean isIncludeSubFolders() {
        return this.includesubfolders;
    }

    public void setIncludeSubFolders(boolean includesubfolders) {
        this.includesubfolders = includesubfolders;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public void setUseProxy(boolean useprox) {
        this.useproxy = useprox;
    }

    public void setProxyUsername(String username) {
        this.proxyusername = username;
    }

    public String getProxyUsername() {
        return this.proxyusername;
    }

    public boolean isDynamicFolder() {
        return this.usedynamicfolder;
    }

    public void setDynamicFolder(boolean usedynamicfolder) {
        this.usedynamicfolder = usedynamicfolder;
    }

    public void setRowLimit(String rowlimit) {
        this.rowlimit = rowlimit;
    }

    public String getRowLimit() {
        return this.rowlimit;
    }

    public void setFolderField(String folderfield) {
        this.folderfield = folderfield;
    }

    public String getFolderField() {
        return this.folderfield;
    }

    public void setFirstIMAPMails(String firstmails) {
        this.imapfirstmails = firstmails;
    }

    public String getFirstIMAPMails() {
        return this.imapfirstmails;
    }

    public void setSenderSearchTerm(String senderSearch) {
        this.senderSearch = senderSearch;
    }

    public String getSenderSearchTerm() {
        return this.senderSearch;
    }

    public void setNotTermSenderSearch(boolean notTermSenderSearch) {
        this.notTermSenderSearch = notTermSenderSearch;
    }

    public boolean isNotTermSenderSearch() {
        return this.notTermSenderSearch;
    }

    public void setNotTermSubjectSearch(boolean notTermSubjectSearch) {
        this.notTermSubjectSearch = notTermSubjectSearch;
    }

    public boolean isNotTermSubjectSearch() {
        return this.notTermSubjectSearch;
    }

    public void setNotTermReceivedDateSearch(boolean notTermReceivedDateSearch) {
        this.notTermReceivedDateSearch = notTermReceivedDateSearch;
    }

    public boolean isNotTermReceivedDateSearch() {
        return this.notTermReceivedDateSearch;
    }

    public void setNotTermRecipientSearch(boolean notTermRecipientSearch) {
        this.notTermRecipientSearch = notTermRecipientSearch;
    }

    public boolean isNotTermRecipientSearch() {
        return this.notTermRecipientSearch;
    }

    public void setRecipientSearch(String recipientSearch) {
        this.recipientSearch = recipientSearch;
    }

    public String getRecipientSearch() {
        return this.recipientSearch;
    }

    public void setSubjectSearch(String subjectSearch) {
        this.subjectSearch = subjectSearch;
    }

    public String getSubjectSearch() {
        return this.subjectSearch;
    }

    public String getReceivedDate1() {
        return this.receivedDate1;
    }

    public void setReceivedDate1(String inputDate) {
        this.receivedDate1 = inputDate;
    }

    public String getReceivedDate2() {
        return this.receivedDate2;
    }

    public void setReceivedDate2(String inputDate) {
        this.receivedDate2 = inputDate;
    }

    public void setConditionOnReceivedDate(int conditionReceivedDate) {
        this.conditionReceivedDate = conditionReceivedDate;
    }

    public int getConditionOnReceivedDate() {
        return this.conditionReceivedDate;
    }

    public void setServerName(String servername) {
        this.servername = servername;
    }

    public String getServerName() {
        return this.servername;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setRetrievemails(int nr) {
        this.retrievemails = nr;
    }

    public int getRetrievemails() {
        return this.retrievemails;
    }

    public int getValueImapList() {
        return this.valueimaplist;
    }

    public void setValueImapList(int value) {
        this.valueimaplist = value;
    }

    public MailInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(MailInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getIMAPFolder() {
        return this.imapfolder;
    }

    public void setIMAPFolder(String folder) {
        this.imapfolder = folder;
    }

    public void setUseSSL(boolean usessl) {
        this.usessl = usessl;
    }

    public boolean isUseSSL() {
        return this.usessl;
    }

    public void setUseXOAUTH2(boolean usexoauth2) {
        this.usexoauth2 = usexoauth2;
    }

    public boolean isUseXOAUTH2() {
        return this.usexoauth2;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.inputFields.length; ++i) {
            MailInputField field = this.inputFields[i];
            ValueMetaString v = new ValueMetaString(variables.resolve(field.getName()));
            switch (field.getColumn()) {
                case 0: 
                case 11: 
                case 17: {
                    v = new ValueMetaInteger(variables.resolve(field.getName()));
                    v.setLength(10, 0);
                    break;
                }
                case 7: 
                case 8: {
                    v = new ValueMetaDate(variables.resolve(field.getName()));
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    v = new ValueMetaBoolean(variables.resolve(field.getName()));
                    break;
                }
                default: {
                    v.setLength(250);
                    v.setPrecision(-1);
                }
            }
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public boolean useBatch() {
        return this.useBatch;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean breakOnError) {
        this.stopOnError = breakOnError;
    }

    public boolean isUseBatch() {
        return this.useBatch;
    }

    public void setUseBatch(boolean useBatch) {
        this.useBatch = useBatch;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    private static final class Tags {
        static final String USE_BATCH = "useBatch";
        static final String BATCH_SIZE = "batchSize";
        static final String START_MSG = "startMsg";
        static final String END_MSG = "endMsg";
        static final String STOP_ON_ERROR = "stopOnError";

        private Tags() {
        }
    }
}

