/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.Arrays;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.widget.IGetCaretPosition;
import org.apache.hop.ui.core.widget.IInsertText;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class VariableButtonListenerFactory {
    private static final Class<?> PKG = VariableButtonListenerFactory.class;

    public static final SelectionAdapter getSelectionAdapter(Composite composite, TextVar destination, IVariables variables) {
        return VariableButtonListenerFactory.getSelectionAdapter(composite, destination, null, null, variables);
    }

    public static final SelectionAdapter getSelectionAdapter(final Composite composite, final TextVar destination, final IGetCaretPosition getCaretPositionInterface, final IInsertText insertTextInterface, final IVariables variables) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String variableName;
                int position = 0;
                if (getCaretPositionInterface != null) {
                    position = getCaretPositionInterface.getCaretPosition();
                }
                if ((variableName = VariableButtonListenerFactory.getVariableName(composite.getShell(), variables)) != null) {
                    String var = "${" + variableName + "}";
                    if (insertTextInterface == null) {
                        destination.getTextWidget().insert(var);
                        e.doit = false;
                    } else {
                        insertTextInterface.insertText(var, position);
                    }
                }
            }
        };
    }

    public static final String getVariableName(Shell shell, IVariables variables) {
        Object[] keys = variables.getVariableNames();
        Arrays.sort(keys);
        int size = keys.length;
        String[] key = new String[size];
        String[] val = new String[size];
        String[] str = new String[size];
        for (int i = 0; i < keys.length; ++i) {
            key[i] = keys[i];
            val[i] = variables.getVariable(key[i]);
            str[i] = key[i] + "  [" + val[i] + "]";
        }
        EnterSelectionDialog esd = new EnterSelectionDialog(shell, str, BaseMessages.getString(PKG, (String)"System.Dialog.SelectEnvironmentVar.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.SelectEnvironmentVar.Message", (String[])new String[0]));
        esd.clearModal();
        if (esd.open() != null) {
            int nr = esd.getSelectionNr();
            return key[nr];
        }
        return null;
    }
}

