/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class TextComposite
extends Composite {
    private static final Class<?> PKG = StyledTextComp.class;

    public TextComposite(Composite parent, int style) {
        super(parent, style);
    }

    public abstract void addModifyListener(ModifyListener var1);

    public abstract void addLineStyleListener();

    public abstract void addLineStyleListener(List<String> var1);

    public void addLineStyleListener(String scriptEngine) {
        throw new UnsupportedOperationException("Cannot specify a script engine");
    }

    public abstract void addMenuDetectListener(MenuDetectListener var1);

    public abstract void setMenu(Menu var1);

    public abstract void cut();

    public abstract void copy();

    public abstract void paste();

    public abstract void selectAll();

    public abstract int getCaretPosition();

    public abstract void setCaretPosition(int var1);

    public abstract int getCharCount();

    public int getLineNumber() {
        String text = this.getText();
        if (StringUtils.isEmpty((String)text)) {
            return 1;
        }
        int rowNumber = 1;
        for (int textPosition = this.getCaretPosition(); textPosition > 0; --textPosition) {
            if (text.charAt(textPosition - 1) != '\n') continue;
            ++rowNumber;
        }
        return rowNumber;
    }

    public int getColumnNumber() {
        String text = this.getText();
        if (StringUtils.isEmpty((String)text)) {
            return 1;
        }
        int columnNumber = 1;
        int textPosition = this.getCaretPosition();
        while (textPosition > 0 && text.charAt(textPosition - 1) != '\n' && text.charAt(textPosition - 1) != '\r') {
            --textPosition;
            ++columnNumber;
        }
        return columnNumber;
    }

    public abstract String getText();

    public abstract void setText(String var1);

    public abstract int getSelectionCount();

    public abstract String getSelectionText();

    public abstract void insert(String var1);

    public abstract void setSelection(int var1);

    public abstract void setSelection(int var1, int var2);

    public abstract boolean isEditable();

    public abstract void setEditable(boolean var1);

    protected boolean checkPaste() {
        try {
            Clipboard clipboard = new Clipboard(this.getParent().getDisplay());
            String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            return text != null && text.length() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void undo() {
    }

    protected void redo() {
    }

    protected boolean isSupportUnoRedo() {
        return false;
    }

    protected void buildingStyledTextMenu(Menu popupMenu) {
        if (this.isSupportUnoRedo()) {
            MenuItem undoItem = new MenuItem(popupMenu, 8);
            undoItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Undo", (String[])new String[0])));
            undoItem.setImage(GuiResource.getInstance().getImage("ui/images/undo.svg", 16, 16));
            undoItem.addListener(13, event -> this.undo());
            MenuItem redoItem = new MenuItem(popupMenu, 8);
            redoItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Redo", (String[])new String[0])));
            redoItem.setImage(GuiResource.getInstance().getImage("ui/images/redo.svg", 16, 16));
            redoItem.addListener(13, event -> this.redo());
            new MenuItem(popupMenu, 2);
        }
        MenuItem cutItem = new MenuItem(popupMenu, 8);
        cutItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Cut", (String[])new String[0])));
        cutItem.setImage(GuiResource.getInstance().getImage("ui/images/cut.svg", 16, 16));
        cutItem.addListener(13, event -> this.cut());
        MenuItem copyItem = new MenuItem(popupMenu, 8);
        copyItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Copy", (String[])new String[0])));
        copyItem.setImage(GuiResource.getInstance().getImage("ui/images/copy.svg", 16, 16));
        copyItem.addListener(13, event -> this.copy());
        MenuItem pasteItem = new MenuItem(popupMenu, 8);
        pasteItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Paste", (String[])new String[0])));
        pasteItem.setImage(GuiResource.getInstance().getImage("ui/images/paste.svg", 16, 16));
        pasteItem.addListener(13, event -> this.paste());
        new MenuItem(popupMenu, 2);
        MenuItem selectAllItem = new MenuItem(popupMenu, 8);
        selectAllItem.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.SelectAll", (String[])new String[0])));
        selectAllItem.setImage(GuiResource.getInstance().getImage("ui/images/select-all.svg", 16, 16));
        selectAllItem.addListener(13, event -> this.selectAll());
        this.addListener(1, event -> {
            if (this.isSupportUnoRedo() && event.keyCode == 122 && (event.stateMask & SWT.MOD1) != 0 && (event.stateMask & SWT.MOD2) != 0) {
                this.redo();
            } else if (this.isSupportUnoRedo() && event.keyCode == 122 && (event.stateMask & SWT.MOD1) != 0) {
                this.undo();
            } else if (event.keyCode == 97 && (event.stateMask & SWT.MOD1) != 0) {
                this.selectAll();
            } else if (event.keyCode == 102 && (event.stateMask & SWT.MOD1) != 0 || event.keyCode != 104 || (event.stateMask & SWT.MOD1) != 0) {
                // empty if block
            }
        });
        this.addMenuDetectListener(event -> {
            pasteItem.setEnabled(this.checkPaste());
            if (this.getSelectionCount() > 0) {
                cutItem.setEnabled(true);
                copyItem.setEnabled(true);
            } else {
                cutItem.setEnabled(false);
                copyItem.setEnabled(false);
            }
        });
        this.setMenu(popupMenu);
    }
}

