/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.DisplayDataTranslation;
import org.apache.beam.sdk.util.construction.ExternalTranslation;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTransformTranslation {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PTransformTranslation.class);
    public static final @UnknownKeyFor @NonNull @Initialized String CREATE_TRANSFORM_URN = "beam:transform:create:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String PAR_DO_TRANSFORM_URN = "beam:transform:pardo:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String FLATTEN_TRANSFORM_URN = "beam:transform:flatten:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String GROUP_BY_KEY_TRANSFORM_URN = "beam:transform:group_by_key:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String IMPULSE_TRANSFORM_URN = "beam:transform:impulse:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String ASSIGN_WINDOWS_TRANSFORM_URN = "beam:transform:window_into:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String TEST_STREAM_TRANSFORM_URN = "beam:transform:teststream:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String MAP_WINDOWS_TRANSFORM_URN = "beam:transform:map_windows:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String MERGE_WINDOWS_TRANSFORM_URN = "beam:transform:merge_windows:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String TO_STRING_TRANSFORM_URN = "beam:transform:to_string:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String MANAGED_TRANSFORM_URN = "beam:transform:managed:v1";
    public static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> RUNNER_IMPLEMENTED_TRANSFORMS = ImmutableSet.of((Object)"beam:transform:group_by_key:v1", (Object)"beam:transform:impulse:v1");
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String READ_TRANSFORM_URN = "beam:transform:read:v1";
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String CREATE_VIEW_TRANSFORM_URN = "beam:transform:create_view:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String COMBINE_PER_KEY_TRANSFORM_URN = "beam:transform:combine_per_key:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String COMBINE_GLOBALLY_TRANSFORM_URN = "beam:transform:combine_globally:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String RESHUFFLE_URN = "beam:transform:reshuffle:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String REDISTRIBUTE_BY_KEY_URN = "beam:transform:redistribute_by_key:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String REDISTRIBUTE_ARBITRARILY_URN = "beam:transform:redistribute_arbitrarily:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String WRITE_FILES_TRANSFORM_URN = "beam:transform:write_files:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String GROUP_INTO_BATCHES_WITH_SHARDED_KEY_URN = "beam:transform:group_into_batches_with_sharded_key:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String PUBSUB_READ = "beam:transform:pubsub_read:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String PUBSUB_WRITE = "beam:transform:pubsub_write:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String PUBSUB_WRITE_DYNAMIC = "beam:transform:pubsub_write:v2";
    public static final @UnknownKeyFor @NonNull @Initialized String COMBINE_PER_KEY_PRECOMBINE_TRANSFORM_URN = "beam:transform:combine_per_key_precombine:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String COMBINE_PER_KEY_MERGE_ACCUMULATORS_TRANSFORM_URN = "beam:transform:combine_per_key_merge_accumulators:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String COMBINE_PER_KEY_EXTRACT_OUTPUTS_TRANSFORM_URN = "beam:transform:combine_per_key_extract_outputs:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS_TRANSFORM_URN = "beam:transform:combine_per_key_convert_to_accumulators:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String COMBINE_GROUPED_VALUES_TRANSFORM_URN = "beam:transform:combine_grouped_values:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_PAIR_WITH_RESTRICTION_URN = "beam:transform:sdf_pair_with_restriction:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_TRUNCATE_SIZED_RESTRICTION_URN = "beam:transform:sdf_truncate_sized_restrictions:v1";
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_PROCESS_KEYED_URN = "beam:transform:sdf_process_keyed_elements:v1";
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_PROCESS_ELEMENTS_URN = "beam:transform:sdf_process_elements:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_SPLIT_AND_SIZE_RESTRICTIONS_URN = "beam:transform:sdf_split_and_size_restrictions:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS_URN = "beam:transform:sdf_process_sized_element_and_restrictions:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String GROUP_INTO_BATCHES_URN = "beam:transform:group_into_batches:v1";
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> KNOWN_TRANSLATORS;
    private static @MonotonicNonNull @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @UnknownKeyFor @NonNull @Initialized TransformPayloadTranslator> knownPayloadTranslators;

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> loadKnownTranslators() {
        return ImmutableSortedSet.orderedBy((Comparator)ReflectHelpers.ObjectsClassComparator.INSTANCE).add((Object)new RawPTransformTranslator()).add(new KnownTransformPayloadTranslator()).add((Object)ParDoTranslation.ParDoTranslator.create()).add((Object)ExternalTranslation.ExternalTranslator.create()).build();
    }

    private PTransformTranslation() {
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> subtransforms, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TransformTranslator transformTranslator = (TransformTranslator)Iterables.find(KNOWN_TRANSLATORS, translator -> translator.canTranslate((PTransform<?, ?>)appliedPTransform.getTransform()), (Object)DefaultUnknownTransformTranslator.INSTANCE);
        return transformTranslator.translate(appliedPTransform, subtransforms, components);
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return PTransformTranslation.toProto(appliedPTransform, Collections.emptyList(), components);
    }

    private static @UnknownKeyFor @NonNull @Initialized String toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tag) {
        return tag.getId();
    }

    public static @Nullable @UnknownKeyFor @Initialized String urnForTransformOrNull(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        TransformTranslator transformTranslator = (TransformTranslator)Iterables.find(KNOWN_TRANSLATORS, translator -> translator.canTranslate(transform), (Object)DefaultUnknownTransformTranslator.INSTANCE);
        return transformTranslator.getUrn(transform);
    }

    public static @UnknownKeyFor @NonNull @Initialized String urnForTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        if (urn == null) {
            throw new IllegalStateException(String.format("No translator known for %s", transform.getClass().getName()));
        }
        return urn;
    }

    public static @Nullable @UnknownKeyFor @Initialized String urnForTransformOrNull(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform) {
        return transform.getSpec() == null ? null : transform.getSpec().getUrn();
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @UnknownKeyFor @NonNull @Initialized TransformPayloadTranslator> getKnownPayloadTranslators() {
        if (knownPayloadTranslators == null) {
            knownPayloadTranslators = PTransformTranslation.loadTransformPayloadTranslators();
        }
        return knownPayloadTranslators;
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @UnknownKeyFor @NonNull @Initialized TransformPayloadTranslator> loadTransformPayloadTranslators() {
        HashMap<Class<? extends PTransform>, TransformPayloadTranslator> translators = new HashMap<Class<? extends PTransform>, TransformPayloadTranslator>();
        ImmutableSet.Builder conflictingRegistrations = new ImmutableSet.Builder();
        for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
            Map<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> newTranslators = registrar.getTransformPayloadTranslators();
            for (Map.Entry<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> entry : newTranslators.entrySet()) {
                Class<? extends PTransform> ptransformClass = entry.getKey();
                TransformPayloadTranslator newTranslator = entry.getValue();
                @Nullable TransformPayloadTranslator existingTranslator = (TransformPayloadTranslator)translators.get(ptransformClass);
                if (existingTranslator == null) {
                    translators.put(ptransformClass, newTranslator);
                    continue;
                }
                LOG.error("Conflicting registrations for {}: {} and {}", new Object[]{ptransformClass, existingTranslator, newTranslator});
                conflictingRegistrations.add(ptransformClass);
            }
        }
        ImmutableSet conflictingRegistrationSet = conflictingRegistrations.build();
        if (!conflictingRegistrationSet.isEmpty()) {
            throw new IllegalArgumentException(String.format("Conflicting registrations for: %s", Joiner.on((String)", ").join((Iterable)conflictingRegistrationSet)));
        }
        return ImmutableMap.copyOf(translators);
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform.Builder translateAppliedPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> subtransforms, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
        for (Map.Entry<TupleTag<?>, PCollection<?>> entry : appliedPTransform.getInputs().entrySet()) {
            transformBuilder.putInputs(PTransformTranslation.toProto(entry.getKey()), components.registerPCollection(entry.getValue()));
        }
        for (Map.Entry<TupleTag<?>, PCollection<?>> entry : appliedPTransform.getOutputs().entrySet()) {
            transformBuilder.putOutputs(PTransformTranslation.toProto(entry.getKey()), components.registerPCollection(entry.getValue()));
        }
        for (AppliedPTransform appliedPTransform2 : subtransforms) {
            transformBuilder.addSubtransforms(components.getExistingPTransformId(appliedPTransform2));
        }
        transformBuilder.setUniqueName(appliedPTransform.getFullName());
        transformBuilder.addAllDisplayData(DisplayDataTranslation.toProto(DisplayData.from(appliedPTransform.getTransform())));
        return transformBuilder;
    }

    static {
        Preconditions.checkState((boolean)PAR_DO_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.PAR_DO)));
        Preconditions.checkState((boolean)FLATTEN_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.FLATTEN)));
        Preconditions.checkState((boolean)GROUP_BY_KEY_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.GROUP_BY_KEY)));
        Preconditions.checkState((boolean)IMPULSE_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.IMPULSE)));
        Preconditions.checkState((boolean)ASSIGN_WINDOWS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.ASSIGN_WINDOWS)));
        Preconditions.checkState((boolean)TEST_STREAM_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.TEST_STREAM)));
        Preconditions.checkState((boolean)MAP_WINDOWS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.MAP_WINDOWS)));
        Preconditions.checkState((boolean)MERGE_WINDOWS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.MERGE_WINDOWS)));
        Preconditions.checkState((boolean)READ_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.DeprecatedPrimitives.READ)));
        Preconditions.checkState((boolean)CREATE_VIEW_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.DeprecatedPrimitives.CREATE_VIEW)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.COMBINE_PER_KEY)));
        Preconditions.checkState((boolean)COMBINE_GLOBALLY_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.COMBINE_GLOBALLY)));
        Preconditions.checkState((boolean)RESHUFFLE_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.RESHUFFLE)));
        Preconditions.checkState((boolean)REDISTRIBUTE_BY_KEY_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.REDISTRIBUTE_BY_KEY)));
        Preconditions.checkState((boolean)REDISTRIBUTE_ARBITRARILY_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.REDISTRIBUTE_ARBITRARILY)));
        Preconditions.checkState((boolean)WRITE_FILES_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.WRITE_FILES)));
        Preconditions.checkState((boolean)PUBSUB_READ.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.PUBSUB_READ)));
        Preconditions.checkState((boolean)PUBSUB_WRITE.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.PUBSUB_WRITE)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_PRECOMBINE_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_PRECOMBINE)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_MERGE_ACCUMULATORS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_MERGE_ACCUMULATORS)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_EXTRACT_OUTPUTS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_EXTRACT_OUTPUTS)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS)));
        Preconditions.checkState((boolean)COMBINE_GROUPED_VALUES_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_GROUPED_VALUES)));
        Preconditions.checkState((boolean)SPLITTABLE_PAIR_WITH_RESTRICTION_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PAIR_WITH_RESTRICTION)));
        Preconditions.checkState((boolean)SPLITTABLE_SPLIT_AND_SIZE_RESTRICTIONS_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.SPLIT_AND_SIZE_RESTRICTIONS)));
        Preconditions.checkState((boolean)SPLITTABLE_PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS)));
        Preconditions.checkState((boolean)SPLITTABLE_TRUNCATE_SIZED_RESTRICTION_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.TRUNCATE_SIZED_RESTRICTION)));
        KNOWN_TRANSLATORS = PTransformTranslation.loadKnownTranslators();
    }

    public static abstract class RawPTransform<@UnknownKeyFor InputT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
    extends PTransform<InputT, OutputT> {
        public @Nullable @UnknownKeyFor @Initialized String getUrn() {
            return this.getSpec() == null ? null : this.getSpec().getUrn();
        }

        public abstract // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec getSpec();

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec migrate(@UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.getSpec();
        }

        @Override
        public OutputT expand(InputT input) {
            throw new IllegalStateException(String.format("%s should never be asked to expand; it is the result of deserializing an already-constructed Pipeline", this.getClass().getSimpleName()));
        }
    }

    public static interface TransformPayloadTranslator<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> {
        public @UnknownKeyFor @NonNull @Initialized String getUrn();

        default public @UnknownKeyFor @NonNull @Initialized String getUrn(T transform) {
            return this.getUrn();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> var1, @UnknownKeyFor @NonNull @Initialized SdkComponents var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

        default public @UnknownKeyFor @NonNull @Initialized Row toConfigRow(T transform) {
            throw new UnsupportedOperationException("Not implemented");
        }

        default public T fromConfigRow(@UnknownKeyFor @NonNull @Initialized Row configRow, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public static abstract class NotSerializable<@UnknownKeyFor T/*
         * Issues handling annotations - annotations may be inaccurate
         */
         extends @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
        implements TransformPayloadTranslator<T> {
            public static /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized NotSerializable<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> forUrn(final @UnknownKeyFor @NonNull @Initialized String urn) {
                return new NotSerializable<PTransform<?, ?>>(){

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized String getUrn() {
                        return urn;
                    }
                };
            }

            @Override
            public final // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
                throw new UnsupportedOperationException(String.format("%s should never be translated", transform.getTransform().getClass().getCanonicalName()));
            }
        }
    }

    private static class KnownTransformPayloadTranslator<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
    implements TransformTranslator<T> {
        private KnownTransformPayloadTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(@UnknownKeyFor @NonNull @Initialized PTransform pTransform) {
            return PTransformTranslation.getKnownPayloadTranslators().containsKey(pTransform.getClass());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn(@UnknownKeyFor @NonNull @Initialized PTransform transform) {
            return PTransformTranslation.getKnownPayloadTranslators().get(transform.getClass()).getUrn(transform);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> subtransforms, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            RunnerApi.PTransform.Builder transformBuilder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            TransformPayloadTranslator payloadTranslator = PTransformTranslation.getKnownPayloadTranslators().get(appliedPTransform.getTransform().getClass());
            RunnerApi.FunctionSpec spec = payloadTranslator.translate(appliedPTransform, components);
            if (spec != null) {
                transformBuilder.setSpec(spec);
                if (!RUNNER_IMPLEMENTED_TRANSFORMS.contains((Object)spec.getUrn())) {
                    if (spec.getUrn().equals(PTransformTranslation.READ_TRANSFORM_URN)) {
                        if (appliedPTransform.getTransform().getClass() == Read.Bounded.class) {
                            transformBuilder.setEnvironmentId(components.getEnvironmentIdFor(appliedPTransform.getResourceHints()));
                        }
                    } else {
                        transformBuilder.setEnvironmentId(components.getEnvironmentIdFor(appliedPTransform.getResourceHints()));
                    }
                }
                if (spec.getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM))) {
                    ExternalTransforms.SchemaTransformPayload payload = ExternalTransforms.SchemaTransformPayload.parseFrom((ByteString)spec.getPayload());
                    String identifier = payload.getIdentifier();
                    transformBuilder.putAnnotations(BeamUrns.getConstant((ProtocolMessageEnum)ExternalTransforms.Annotations.Enum.SCHEMATRANSFORM_URN_KEY), ByteString.copyFromUtf8((String)identifier));
                    if (identifier.equals(PTransformTranslation.MANAGED_TRANSFORM_URN)) {
                        Schema configSchema = SchemaTranslation.schemaFromProto(payload.getConfigurationSchema());
                        Row configRow = (Row)RowCoder.of(configSchema).decode(payload.getConfigurationRow().newInput());
                        String underlyingIdentifier = configRow.getString("transform_identifier");
                        if (underlyingIdentifier == null) {
                            throw new IllegalStateException(String.format("Encountered a Managed Transform that has an empty \"transform_identifier\": %n%s", configRow));
                        }
                        transformBuilder.putAnnotations(BeamUrns.getConstant((ProtocolMessageEnum)ExternalTransforms.Annotations.Enum.MANAGED_UNDERLYING_TRANSFORM_URN_KEY), ByteString.copyFromUtf8((String)underlyingIdentifier));
                    }
                }
            }
            Row configRow = null;
            try {
                configRow = payloadTranslator.toConfigRow(appliedPTransform.getTransform());
            }
            catch (UnsupportedOperationException identifier) {
            }
            catch (Exception e) {
                LOG.warn("Could not attach the config row for transform " + ((PTransform)appliedPTransform.getTransform()).getName() + ": " + e);
            }
            if (configRow != null) {
                transformBuilder.putAnnotations(BeamUrns.getConstant((ProtocolMessageEnum)ExternalTransforms.Annotations.Enum.CONFIG_ROW_KEY), ByteString.copyFrom((byte[])CoderUtils.encodeToByteArray(RowCoder.of(configRow.getSchema()), configRow)));
                transformBuilder.putAnnotations(BeamUrns.getConstant((ProtocolMessageEnum)ExternalTransforms.Annotations.Enum.CONFIG_ROW_SCHEMA_KEY), ByteString.copyFrom((byte[])SchemaTranslation.schemaToProto(configRow.getSchema(), true).toByteArray()));
            }
            for (Map.Entry<String, byte[]> annotation : ((PTransform)appliedPTransform.getTransform()).getAnnotations().entrySet()) {
                transformBuilder.putAnnotations(annotation.getKey(), ByteString.copyFrom((byte[])annotation.getValue()));
            }
            return transformBuilder.build();
        }
    }

    private static class RawPTransformTranslator
    implements TransformTranslator<RawPTransform<?, ?>> {
        private RawPTransformTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn(@UnknownKeyFor @NonNull @Initialized RawPTransform transform) {
            return transform.getUrn();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> pTransform) {
            return pTransform instanceof RawPTransform;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> subtransforms, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            RunnerApi.PTransform.Builder transformBuilder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            Object transform = appliedPTransform.getTransform();
            RunnerApi.FunctionSpec spec = ((RawPTransform)transform).migrate(components);
            String urn = "";
            if (spec != null) {
                urn = spec.getUrn();
                transformBuilder.setSpec(spec);
            }
            if (!RUNNER_IMPLEMENTED_TRANSFORMS.contains((Object)urn)) {
                transformBuilder.setEnvironmentId(components.getEnvironmentIdFor(appliedPTransform.getResourceHints()));
            }
            return transformBuilder.build();
        }
    }

    private static class DefaultUnknownTransformTranslator
    implements TransformTranslator<PTransform<?, ?>> {
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> INSTANCE = new DefaultUnknownTransformTranslator();

        private DefaultUnknownTransformTranslator() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getUrn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> pTransform) {
            return true;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull @UnknownKeyFor @Initialized RunnerApi.PTransform translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> subtransforms, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components).build();
        }
    }

    public static interface TransformTranslator<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> {
        public @Nullable @UnknownKeyFor @Initialized String getUrn(T var1);

        public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> var2, @UnknownKeyFor @NonNull @Initialized SdkComponents var3) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }
}

