/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.staticschema.util;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.staticschema.metadata.SchemaDefinition;

public class SchemaDefinitionUtil {
    public SchemaDefinition loadSchemaDefinition(IHopMetadataProvider metadataProvider, String schemaDefinitionName) throws HopTransformException {
        SchemaDefinition schemaDefinition;
        if (StringUtils.isEmpty((String)schemaDefinitionName)) {
            throw new HopTransformException("No schema definition name provided");
        }
        try {
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(SchemaDefinition.class);
            schemaDefinition = (SchemaDefinition)serializer.load(schemaDefinitionName);
        }
        catch (Exception e) {
            throw new HopTransformException("Unable to schema definition '" + schemaDefinitionName + "' from the metadata", (Throwable)e);
        }
        if (schemaDefinition == null) {
            throw new HopTransformException("Unable to find schema definition '" + schemaDefinitionName + "' in the metadata");
        }
        try {
            schemaDefinition.validate();
        }
        catch (Exception e) {
            throw new HopTransformException("There was an error validating file definition " + schemaDefinition.getName(), (Throwable)e);
        }
        return schemaDefinition;
    }
}

