/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.msgboxinfo;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.gui.GuiFactory;
import org.apache.hop.core.gui.IThreadDialogs;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;

@Action(id="MSGBOX_INFO", name="i18n::ActionMsgBoxInfo.Name", description="i18n::ActionMsgBoxInfo.Description", image="MsgBoxInfo.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionMsgBoxInfo.keyword"}, documentationUrl="/workflow/actions/msgboxinfo.html")
public class ActionMsgBoxInfo
extends ActionBase
implements Cloneable,
IAction {
    @HopMetadataProperty(key="bodymessage")
    private String bodyMessage = null;
    @HopMetadataProperty(key="titremessage")
    private String titleMessage = null;

    public ActionMsgBoxInfo(String n, String scr) {
        super(n, "");
    }

    public ActionMsgBoxInfo() {
        this("", "");
    }

    public Object clone() {
        ActionMsgBoxInfo je = (ActionMsgBoxInfo)super.clone();
        return je;
    }

    public boolean evaluate(Result result) {
        try {
            boolean response = true;
            IThreadDialogs dialogs = GuiFactory.getThreadDialogs();
            if (dialogs != null) {
                response = dialogs.threadMessageBox(Const.NVL((String)this.getRealBodyMessage(), (String)"") + Const.CR, Const.NVL((String)this.getRealTitleMessage(), (String)""), true, 3);
            }
            return response;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError("Couldn't display message box: " + e.toString());
            return false;
        }
    }

    public Result execute(Result prevResult, int nr) {
        prevResult.setResult(this.evaluate(prevResult));
        return prevResult;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getRealTitleMessage() {
        return this.resolve(this.getTitleMessage());
    }

    public String getRealBodyMessage() {
        return this.resolve(this.getBodyMessage());
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.addOkRemark((ICheckResultSource)this, (String)"bodyMessage", remarks);
        ActionValidatorUtils.addOkRemark((ICheckResultSource)this, (String)"titleMessage", remarks);
    }

    @Generated
    public String getBodyMessage() {
        return this.bodyMessage;
    }

    @Generated
    public String getTitleMessage() {
        return this.titleMessage;
    }

    @Generated
    public void setBodyMessage(String bodyMessage) {
        this.bodyMessage = bodyMessage;
    }

    @Generated
    public void setTitleMessage(String titleMessage) {
        this.titleMessage = titleMessage;
    }
}

