/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.PrintObjectPageInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

public class PrintObjectPageInputStream
extends InputStream {
    private transient AS400 system_;
    private transient PrintObjectPageInputStreamImpl impl_;

    PrintObjectPageInputStream(SpooledFile spooledFile, PrintParameterList openOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = spooledFile.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (spooledFile.getImpl() == null) {
            spooledFile.chooseImpl();
        }
        this.impl_.createPrintObjectPageInputStream((SpooledFileImpl)spooledFile.getImpl(), openOptions);
    }

    @Override
    public int available() throws IOException {
        return this.impl_.available();
    }

    private void chooseImpl() {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to use PrintObjectPageInputStream before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectPageInputStreamImpl)this.system_.loadImpl2("com.ibm.as400.access.PrintObjectPageInputStreamImplRemote", "com.ibm.as400.access.PrintObjectPageInputStreamImplProxy");
    }

    @Override
    public void close() throws IOException {
        this.impl_.close();
    }

    public int getCurrentPageNumber() {
        return this.impl_.getCurrentPageNumber();
    }

    public int getNumberOfPages() {
        return this.impl_.getNumberOfPages();
    }

    public boolean isPagesEstimated() {
        return this.impl_.isPagesEstimated();
    }

    @Override
    public void mark(int readLimit) {
        this.impl_.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public boolean nextPage() throws IOException {
        return this.impl_.nextPage();
    }

    public boolean previousPage() throws IOException {
        return this.impl_.previousPage();
    }

    @Override
    public int read() throws IOException {
        int readchar = -1;
        byte[] oneByte = new byte[1];
        int rc = this.read(oneByte, 0, 1);
        if (rc == 1) {
            readchar = oneByte[0];
        }
        return readchar;
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int dataOffset, int length) throws IOException {
        return this.impl_.read(data, dataOffset, length);
    }

    @Override
    public void reset() throws IOException {
        this.impl_.reset();
    }

    public boolean selectPage(int page) throws IOException, IllegalArgumentException {
        return this.impl_.selectPage(page);
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        if (bytesToSkip <= 0L) {
            return 0L;
        }
        return this.impl_.skip(bytesToSkip);
    }
}

