/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class AS400JDBCDriver
implements Driver {
    static final int MAJOR_VERSION_ = 13;
    static final int MINOR_VERSION_ = 4;
    static final String DATABASE_PRODUCT_NAME_ = "DB2 UDB for AS/400";
    static final String DRIVER_NAME_ = "AS/400 Toolbox for Java JDBC Driver";
    static final String DRIVER_LEVEL_ = "07050004";
    public static final int JDBC_MAJOR_VERSION_ = 4;
    public static final int JDBC_MINOR_VERSION_ = 0;
    private static final String MRI_NOT_FOUND_ = "9999:9999";
    private static ResourceBundle resources_;
    private static ResourceBundle resources2_;
    private static final String CLASSNAME = "com.ibm.as400.access.AS400JDBCDriver";
    private static Driver nativeDriver;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        return dataSourceUrl.isValid();
    }

    public Connection connect(String url, String userid, char[] password) throws SQLException {
        return this.connect(url, userid, password, (char[])null);
    }

    public Connection connect(String url, String userid, char[] password, char[] additionalAuthenticationFactor) throws SQLException {
        Properties properties = new Properties();
        properties.put("user", userid);
        return this.connect(url, properties, password, additionalAuthenticationFactor);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.connect(url, info, null);
    }

    public Connection connect(String url, Properties info, char[] password) throws SQLException {
        return this.connect(url, info, password, (char[])null);
    }

    public Connection connect(String url, Properties info, char[] password, char[] additionalAuthenticationFactor) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        Properties urlProperties = dataSourceUrl.getProperties();
        if (JDProperties.isTraceSet(urlProperties, info) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(urlProperties, info) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(urlProperties, info) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(urlProperties, info) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        if (JDTrace.isTraceOn()) {
            String traceUrl = url;
            int passwordIndex = url.indexOf("password=");
            if (passwordIndex >= 0) {
                int semicolonIndex = url.indexOf(";", passwordIndex);
                traceUrl = semicolonIndex < 0 ? url.substring(0, passwordIndex) + "password=******" : url.substring(0, passwordIndex) + "password=******" + url.substring(semicolonIndex);
            }
            JDTrace.logInformation(this, "connect called with URL: " + traceUrl);
        }
        JDProperties jdProperties = new JDProperties(urlProperties, info, password, additionalAuthenticationFactor);
        Connection connection = null;
        if (dataSourceUrl.isValid()) {
            connection = this.initializeConnection(dataSourceUrl, jdProperties);
        }
        return connection;
    }

    public Connection connect(AS400 system) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        return this.initializeConnection(AS400.newInstance(system.isSecure(), system));
    }

    public Connection connect(AS400 system, boolean clone) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (!clone) {
            return this.initializeConnection(system);
        }
        return this.connect(system);
    }

    public Connection connect(AS400 system, Properties info, String schema, boolean clone) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (info == null) {
            throw new NullPointerException("properties");
        }
        if (JDProperties.isTraceSet(null, info) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(null, info) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(null, info) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        if (!clone) {
            return this.initializeConnection(schema, info, system);
        }
        return this.initializeConnection(schema, info, AS400.newInstance(system.isSecure(), system));
    }

    public Connection connect(AS400 system, Properties info, String schema) throws SQLException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (info == null) {
            throw new NullPointerException("properties");
        }
        if (JDProperties.isTraceSet(null, info) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(null, info) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(null, info) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, info) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        return this.initializeConnection(schema, info, AS400.newInstance(system.isSecure(), system));
    }

    @Override
    public int getMajorVersion() {
        return 13;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        DriverPropertyInfo[] dpi = null;
        if (dataSourceUrl.isValid()) {
            JDProperties properties = new JDProperties(dataSourceUrl.getProperties(), info, null, null);
            dpi = properties.getInfo();
        }
        return dpi;
    }

    static String getResource(String key, String[] replacementVariables) {
        String resource;
        if (resources_ == null) {
            resource = MRI_NOT_FOUND_;
        } else {
            try {
                resource = resources_.getString(key);
            }
            catch (MissingResourceException e) {
                if (resources2_ == null) {
                    resource = MRI_NOT_FOUND_;
                }
                try {
                    resource = resources2_.getString(key);
                }
                catch (MissingResourceException e1) {
                    JDTrace.logInformation(AS400JDBCDriver.class, "Missing resource [" + key + "]");
                    resource = MRI_NOT_FOUND_;
                }
            }
        }
        if (replacementVariables != null) {
            resource = AS400JDBCDriver.substitute(resource, replacementVariables);
        }
        return resource;
    }

    static String substitute(String text, Object[] values) {
        String result = text;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                String variable = "&" + i;
                int j = result.indexOf(variable);
                if (j < 0) continue;
                StringBuffer buffer = new StringBuffer();
                buffer.append(result.substring(0, j));
                buffer.append(values[i].toString());
                buffer.append(result.substring(j + variable.length()));
                result = buffer.toString();
            }
        }
        return result;
    }

    static AS400 initializeAS400(JDDataSourceURL dataSourceUrl, JDProperties jdProperties) throws SQLException {
        String serverName = dataSourceUrl.getServerName();
        String userName = jdProperties.getString(29);
        char[] clearPassword = jdProperties.getClearPassword();
        char[] additionalAuthenticationFactor = jdProperties.getAdditionalAuthenticationFactor();
        String prompt = jdProperties.getString(18);
        boolean secure = jdProperties.getBoolean(32);
        boolean useThreads = jdProperties.getBoolean(38);
        String secureCurrentUser = SystemProperties.getProperty("com.ibm.as400.access.JDBC.secureCurrentUser");
        boolean isSecureCurrentUser = true;
        if (secureCurrentUser != null && !Boolean.valueOf(secureCurrentUser).booleanValue() || !jdProperties.getBoolean(78)) {
            isSecureCurrentUser = false;
        }
        boolean forcePrompt = false;
        if ("".equals(userName) && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriver.class, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (clearPassword != null && clearPassword.length == 0 && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriver.class, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (userName != null && userName.compareToIgnoreCase("*CURRENT") == 0 && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriver.class, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (!(clearPassword == null || clearPassword.length != 8 || clearPassword[0] != '*' || clearPassword[1] != 'C' && clearPassword[1] != 'c' || clearPassword[2] != 'U' && clearPassword[2] != 'u' || clearPassword[3] != 'R' && clearPassword[3] != 'r' || clearPassword[4] != 'R' && clearPassword[4] != 'r' || clearPassword[5] != 'E' && clearPassword[5] != 'e' || clearPassword[6] != 'N' && clearPassword[6] != 'n' || clearPassword[7] != 'T' && clearPassword[7] != 't' || !isSecureCurrentUser)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(AS400JDBCDriver.class, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        AS400 as400 = null;
        try {
            as400 = serverName.length() == 0 ? AS400.newInstance(secure) : (userName == null || userName.length() == 0 ? AS400.newInstance(secure, serverName) : (clearPassword == null ? AS400.newInstance(secure, serverName, userName) : AS400.newInstance(secure, serverName, userName, clearPassword, additionalAuthenticationFactor)));
        }
        catch (AS400SecurityException e) {
            JDError.throwSQLException((Object)as400, "08004", e);
        }
        catch (IOException e) {
            JDError.throwSQLException((Object)as400, "08001", e);
        }
        if (clearPassword != null) {
            CredentialVault.clearArray(clearPassword);
        }
        try {
            if (!prompt.equals("")) {
                as400.setGuiAvailable(jdProperties.getBoolean(18));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (!useThreads) {
                as400.setThreadUsed(useThreads);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (forcePrompt) {
            as400.forcePrompt();
        }
        return as400;
    }

    private Connection initializeConnection(JDDataSourceURL dataSourceUrl, JDProperties jdProperties) throws SQLException {
        String secondaryUrl;
        AS400 as400 = null;
        boolean proxyServerWasSpecifiedInUrl = false;
        boolean proxyServerWasSpecifiedInProperties = false;
        boolean proxyServerWasSpecified = false;
        String driverImplementation = jdProperties.getString(41);
        if (!driverImplementation.equals("toolbox")) {
            if (nativeDriver == null) {
                try {
                    nativeDriver = (Driver)Class.forName("com.ibm.db2.jdbc.app.DB2Driver").newInstance();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Native IBM Developer Kit for Java JDBC driver implementation was loaded");
                    }
                }
                catch (Throwable e) {
                    nativeDriver = null;
                }
            }
            if (nativeDriver != null && dataSourceUrl.getSecondaryURL().length() == 0) {
                boolean isLocal = false;
                String serverName = dataSourceUrl.getServerName();
                if (serverName.length() == 0 || serverName.equalsIgnoreCase("localhost")) {
                    isLocal = true;
                } else {
                    try {
                        InetAddress localInet = InetAddress.getLocalHost();
                        InetAddress[] remoteInet = InetAddress.getAllByName(serverName);
                        for (int i = 0; i < remoteInet.length; ++i) {
                            if (!localInet.equals(remoteInet[i])) continue;
                            isLocal = true;
                        }
                    }
                    catch (Throwable localInet) {
                        // empty catch block
                    }
                }
                if (isLocal) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Connection is local");
                    }
                    String nativeURL = dataSourceUrl.getNativeURL();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Using native IBM Developer Kit for Java JDBC driver implementation");
                    }
                    return nativeDriver.connect(nativeURL, jdProperties.getOriginalInfo());
                }
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Using IBM Toolbox for Java JDBC driver implementation");
        }
        if (jdProperties.getString(34).length() != 0) {
            proxyServerWasSpecifiedInUrl = true;
        }
        if (SystemProperties.getProperty("com.ibm.as400.access.AS400.proxyServer") != null) {
            proxyServerWasSpecifiedInProperties = true;
        }
        if (proxyServerWasSpecifiedInUrl || proxyServerWasSpecifiedInProperties) {
            proxyServerWasSpecified = true;
        }
        if (!proxyServerWasSpecified && (secondaryUrl = dataSourceUrl.getSecondaryURL()).length() != 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Secondary URL [" + secondaryUrl + "]");
            }
            return DriverManager.getConnection(secondaryUrl, jdProperties.getOriginalInfo());
        }
        as400 = AS400JDBCDriver.initializeAS400(dataSourceUrl, jdProperties);
        if (proxyServerWasSpecifiedInUrl) {
            String proxyServerNameAndPort = jdProperties.getString(34);
            try {
                as400.setProxyServer(proxyServerNameAndPort);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return this.prepareConnection(as400, dataSourceUrl, jdProperties);
    }

    private Connection initializeConnection(AS400 as400) throws SQLException {
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(null);
        Properties info = new Properties();
        JDProperties jdProperties = new JDProperties(null, info, null, null);
        return this.prepareConnection(as400, dataSourceUrl, jdProperties);
    }

    private Connection initializeConnection(String schema, Properties info, AS400 as400) throws SQLException {
        boolean proxyServerWasSpecifiedInUrl = false;
        String url = null;
        url = schema != null ? "jdbc:as400://" + as400.getSystemName() + "/" + schema : "jdbc:as400://" + as400.getSystemName();
        JDDataSourceURL dataSourceUrl = new JDDataSourceURL(url);
        JDProperties jdProperties = new JDProperties(null, info, null, null);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Using IBM Toolbox for Java JDBC driver implementation");
        }
        if (jdProperties.getString(34).length() != 0) {
            proxyServerWasSpecifiedInUrl = true;
        }
        if (proxyServerWasSpecifiedInUrl) {
            String proxyServerNameAndPort = jdProperties.getString(34);
            try {
                as400.setProxyServer(proxyServerNameAndPort);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return this.prepareConnection(as400, dataSourceUrl, jdProperties);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private Connection prepareConnection(AS400 as400, JDDataSourceURL dataSourceUrl, JDProperties jdProperties) throws SQLException {
        return this.prepareConnection(as400, dataSourceUrl, jdProperties, false);
    }

    private Connection prepareConnection(AS400 as400, JDDataSourceURL dataSourceUrl, JDProperties jdProperties, boolean vrmSet) throws SQLException {
        Connection connection;
        SocketProperties sockProps = null;
        if (!jdProperties.getString(67).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setKeepAlive(jdProperties.getBoolean(67));
        }
        if (!jdProperties.getString(68).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setReceiveBufferSize(jdProperties.getInt(68));
        }
        if (!jdProperties.getString(69).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setSendBufferSize(jdProperties.getInt(69));
        }
        if (!as400.arePropertiesFrozen()) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setLoginTimeout(DriverManager.getLoginTimeout() * 1000);
        }
        if (!jdProperties.getString(58).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setLoginTimeout(jdProperties.getInt(58) * 1000);
        }
        if (!jdProperties.getString(81).equals("")) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setSoTimeout(jdProperties.getInt(81));
        }
        if (jdProperties.getBoolean(100)) {
            if (sockProps == null) {
                sockProps = as400.getSocketProperties();
            }
            sockProps.setTcpNoDelay(true);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Setting sockProps.setTcpNoDelay(true)");
            }
        }
        String defaultImpl = "com.ibm.as400.access.AS400JDBCConnectionImpl";
        if (jdProperties.getInt(93) == 1) {
            defaultImpl = "com.ibm.as400.access.AS400JDBCConnectionRedirect";
        }
        if (sockProps != null) {
            as400.setSocketProperties(sockProps);
        }
        if ((connection = (Connection)as400.loadImpl2(defaultImpl, "com.ibm.as400.access.JDConnectionProxy")) != null) {
            try {
                if (connection instanceof JDConnectionProxy) {
                    ((JDConnectionProxy)connection).setSystem(as400);
                    ((JDConnectionProxy)connection).setProperties(dataSourceUrl, jdProperties, as400);
                } else {
                    ((AS400JDBCConnection)connection).setSystem(as400);
                    ((AS400JDBCConnection)connection).setProperties(dataSourceUrl, jdProperties, as400);
                }
            }
            catch (SQLException sqlex) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sqlex;
            }
        }
        if (as400.skipSignonServer_ && !vrmSet) {
            try {
                Statement s = connection.createStatement();
                ResultSet rs = s.executeQuery("SELECT OS_VERSION,OS_RELEASE FROM SYSIBMADM.ENVSYSINFO");
                if (rs.next()) {
                    int version = rs.getInt(1);
                    int release = rs.getInt(2);
                    as400.setVRM(version, release, 0);
                }
                rs.close();
                s.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection.close();
            return this.prepareConnection(as400, dataSourceUrl, jdProperties, true);
        }
        return connection;
    }

    public String toString() {
        return DRIVER_NAME_;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        nativeDriver = null;
        try {
            if (Trace.traceOn_) {
                Trace.logLoadPath(CLASSNAME, 8);
            }
            DriverManager.registerDriver(new AS400JDBCDriver());
            resources_ = ResourceBundle.getBundle("com.ibm.as400.access.JDMRI");
            resources2_ = ResourceBundle.getBundle("com.ibm.as400.access.JDMRI2");
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

